/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.autolayout.utils;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.zhy.autolayout.AutoLayoutInfo;
import com.zhy.autolayout.R;
import com.zhy.autolayout.attr.HeightAttr;
import com.zhy.autolayout.attr.MarginAttr;
import com.zhy.autolayout.attr.MarginBottomAttr;
import com.zhy.autolayout.attr.MarginLeftAttr;
import com.zhy.autolayout.attr.MarginRightAttr;
import com.zhy.autolayout.attr.MarginTopAttr;
import com.zhy.autolayout.attr.MaxHeightAttr;
import com.zhy.autolayout.attr.MaxWidthAttr;
import com.zhy.autolayout.attr.MinHeightAttr;
import com.zhy.autolayout.attr.MinWidthAttr;
import com.zhy.autolayout.attr.PaddingAttr;
import com.zhy.autolayout.attr.PaddingBottomAttr;
import com.zhy.autolayout.attr.PaddingLeftAttr;
import com.zhy.autolayout.attr.PaddingRightAttr;
import com.zhy.autolayout.attr.PaddingTopAttr;
import com.zhy.autolayout.attr.TextSizeAttr;
import com.zhy.autolayout.attr.WidthAttr;
import com.zhy.autolayout.config.AutoLayoutConifg;
import com.zhy.autolayout.utils.DimenUtils;
import com.zhy.autolayout.utils.L;

public class AutoLayoutHelper {
    private final ViewGroup mHost;
    private static final int[] LL = new int[]{16842901, 16842965, 16842966, 16842967, 16842968, 16842969, 16842996, 16842997, 16842998, 16842999, 16843000, 16843001, 16843002, 0x101011F, 0x1010120, 16843071, 0x1010140};
    private static final int INDEX_TEXT_SIZE = 0;
    private static final int INDEX_PADDING = 1;
    private static final int INDEX_PADDING_LEFT = 2;
    private static final int INDEX_PADDING_TOP = 3;
    private static final int INDEX_PADDING_RIGHT = 4;
    private static final int INDEX_PADDING_BOTTOM = 5;
    private static final int INDEX_WIDTH = 6;
    private static final int INDEX_HEIGHT = 7;
    private static final int INDEX_MARGIN = 8;
    private static final int INDEX_MARGIN_LEFT = 9;
    private static final int INDEX_MARGIN_TOP = 10;
    private static final int INDEX_MARGIN_RIGHT = 11;
    private static final int INDEX_MARGIN_BOTTOM = 12;
    private static final int INDEX_MAX_WIDTH = 13;
    private static final int INDEX_MAX_HEIGHT = 14;
    private static final int INDEX_MIN_WIDTH = 15;
    private static final int INDEX_MIN_HEIGHT = 16;
    private static AutoLayoutConifg mAutoLayoutConifg;

    public AutoLayoutHelper(ViewGroup host) {
        this.mHost = host;
        if (mAutoLayoutConifg == null) {
            this.initAutoLayoutConfig(host);
        }
    }

    private void initAutoLayoutConfig(ViewGroup host) {
        mAutoLayoutConifg = AutoLayoutConifg.getInstance();
        mAutoLayoutConifg.init(host.getContext());
    }

    public void adjustChildren() {
        AutoLayoutConifg.getInstance().checkParams();
        int n = this.mHost.getChildCount();
        for (int i = 0; i < n; ++i) {
            AutoLayoutInfo info;
            View view = this.mHost.getChildAt(i);
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (!(params instanceof AutoLayoutParams) || (info = ((AutoLayoutParams)params).getAutoLayoutInfo()) == null) continue;
            info.fillAttrs(view);
        }
    }

    public static AutoLayoutInfo getAutoLayoutInfo(Context context, AttributeSet attrs) {
        AutoLayoutInfo info = new AutoLayoutInfo();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AutoLayout_Layout);
        int baseWidth = a.getInt(R.styleable.AutoLayout_Layout_layout_auto_basewidth, 0);
        int baseHeight = a.getInt(R.styleable.AutoLayout_Layout_layout_auto_baseheight, 0);
        a.recycle();
        TypedArray array = context.obtainStyledAttributes(attrs, LL);
        int n = array.getIndexCount();
        block21: for (int i = 0; i < n; ++i) {
            int index = array.getIndex(i);
            if (!DimenUtils.isPxVal(array.peekValue(index))) continue;
            int pxVal = 0;
            try {
                pxVal = array.getDimensionPixelOffset(index, 0);
            }
            catch (Exception ignore) {
                continue;
            }
            switch (index) {
                case 0: {
                    info.addAttr(new TextSizeAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 1: {
                    info.addAttr(new PaddingAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 2: {
                    info.addAttr(new PaddingLeftAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 3: {
                    info.addAttr(new PaddingTopAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 4: {
                    info.addAttr(new PaddingRightAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 5: {
                    info.addAttr(new PaddingBottomAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 6: {
                    info.addAttr(new WidthAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 7: {
                    info.addAttr(new HeightAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 8: {
                    info.addAttr(new MarginAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 9: {
                    info.addAttr(new MarginLeftAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 10: {
                    info.addAttr(new MarginTopAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 11: {
                    info.addAttr(new MarginRightAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 12: {
                    info.addAttr(new MarginBottomAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 13: {
                    info.addAttr(new MaxWidthAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 14: {
                    info.addAttr(new MaxHeightAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 15: {
                    info.addAttr(new MinWidthAttr(pxVal, baseWidth, baseHeight));
                    continue block21;
                }
                case 16: {
                    info.addAttr(new MinHeightAttr(pxVal, baseWidth, baseHeight));
                }
            }
        }
        array.recycle();
        L.e(" getAutoLayoutInfo " + info.toString());
        return info;
    }

    public static interface AutoLayoutParams {
        public AutoLayoutInfo getAutoLayoutInfo();
    }
}

