/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.autolayout.attr;

import android.os.Build;
import android.view.View;
import com.zhy.autolayout.attr.AutoAttr;
import java.lang.reflect.Field;

public class MinWidthAttr
extends AutoAttr {
    public MinWidthAttr(int pxVal, int baseWidth, int baseHeight) {
        super(pxVal, baseWidth, baseHeight);
    }

    @Override
    protected int attrVal() {
        return 8192;
    }

    @Override
    protected boolean defaultBaseWidth() {
        return true;
    }

    @Override
    protected void execute(View view, int val) {
        view.setMinimumWidth(val);
    }

    public static int getMinWidth(View view) {
        if (Build.VERSION.SDK_INT >= 16) {
            return view.getMinimumWidth();
        }
        try {
            Field minWidth = view.getClass().getField("mMinWidth");
            minWidth.setAccessible(true);
            return (Integer)minWidth.get(view);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static MinWidthAttr generate(int val, int baseFlag) {
        MinWidthAttr attr = null;
        switch (baseFlag) {
            case 1: {
                attr = new MinWidthAttr(val, 8192, 0);
                break;
            }
            case 2: {
                attr = new MinWidthAttr(val, 0, 8192);
                break;
            }
            case 3: {
                attr = new MinWidthAttr(val, 0, 0);
            }
        }
        return attr;
    }
}

