/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xvideolib;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.MediaPlayer;
import android.net.wifi.WifiManager;
import android.os.IBinder;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import android.widget.RemoteViews;
import com.zhxh.xvideolib.R;
import com.zhxh.xvideolib.VideoActivity;
import java.io.IOException;

public class MediaPlayerService
extends Service {
    private static final int DELETE_PENDINGINTENT_REQUESTCODE = 1022;
    private static final int CONTENT_PENDINGINTENT_REQUESTCODE = 1023;
    private static final int NEXT_PENDINGINTENT_REQUESTCODE = 1024;
    private static final int PLAY_PENDINGINTENT_REQUESTCODE = 1025;
    private static final int STOP_PENDINGINTENT_REQUESTCODE = 1026;
    private static final int NOTIFICATION_PENDINGINTENT_ID = 1;
    private NotificationManager notificationManager;
    private NotificationCompat.Builder builder;
    private RemoteViews views;
    private BroadcastReceiver playerReceiver;
    private MediaPlayer mediaPlayer;
    private WifiManager.WifiLock wifiLock;
    private String[] musics = new String[]{"https://github.com/zhxhcoder/XVideo/blob/master/screenshots/xbutton.mp3", "https://github.com/zhxhcoder/XVideo/blob/master/screenshots/xbutton.mp3"};
    private int current_item = 0;
    private boolean isPause = false;

    public void onCreate() {
        super.onCreate();
        this.initMediaPlayer();
        Intent intent = new Intent((Context)this, VideoActivity.class);
        PendingIntent contentPendingIntent = PendingIntent.getActivity((Context)this, (int)1023, (Intent)intent, (int)0x8000000);
        Intent delIntent = new Intent((Context)this, MediaPlayerService.class);
        PendingIntent delPendingIntent = PendingIntent.getService((Context)this, (int)1022, (Intent)delIntent, (int)0x8000000);
        this.views = new RemoteViews(this.getPackageName(), R.layout.layout_mediaplayer);
        Intent intentNext = new Intent("nextMusic");
        PendingIntent nextPendingIntent = PendingIntent.getBroadcast((Context)this, (int)1024, (Intent)intentNext, (int)0x10000000);
        this.views.setOnClickPendingIntent(R.id.tv_next, nextPendingIntent);
        Intent intentPlay = new Intent("playMusic");
        PendingIntent playPendingIntent = PendingIntent.getBroadcast((Context)this, (int)1025, (Intent)intentPlay, (int)0x10000000);
        this.views.setOnClickPendingIntent(R.id.tv_pause, playPendingIntent);
        Intent intentStop = new Intent("stopMusic");
        PendingIntent stopPendingIntent = PendingIntent.getBroadcast((Context)this, (int)1026, (Intent)intentStop, (int)0x10000000);
        this.views.setOnClickPendingIntent(R.id.tv_cancel, stopPendingIntent);
        this.builder = new NotificationCompat.Builder((Context)this).setSmallIcon(R.drawable.video_bg).setContentTitle((CharSequence)"ZMediaPlayer").setContentText((CharSequence)"\u5185\u5bb9").setAutoCancel(false).setContentIntent(contentPendingIntent).setDeleteIntent(delPendingIntent).setContent(this.views);
        this.notificationManager = (NotificationManager)this.getSystemService("notification");
        this.startForeground(1, this.builder.build());
        this.playerReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                Log.d((String)"action", (String)intent.getAction());
                switch (intent.getAction()) {
                    case "nextMusic": {
                        MediaPlayerService.this.nextMusic();
                        break;
                    }
                    case "playMusic": {
                        if (MediaPlayerService.this.mediaPlayer == null) break;
                        if (!MediaPlayerService.this.isPause) {
                            MediaPlayerService.this.mediaPlayer.pause();
                            MediaPlayerService.this.isPause = true;
                            break;
                        }
                        MediaPlayerService.this.mediaPlayer.start();
                        MediaPlayerService.this.isPause = false;
                        break;
                    }
                    case "stopMusic": {
                        MediaPlayerService.this.onDestroy();
                    }
                }
            }
        };
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("nextMusic");
        intentFilter.addAction("playMusic");
        intentFilter.addAction("stopMusic");
        this.registerReceiver(this.playerReceiver, intentFilter);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
        if (this.wifiLock != null && this.wifiLock.isHeld()) {
            this.wifiLock.release();
        }
        try {
            if (this.playerReceiver != null) {
                this.unregisterReceiver(this.playerReceiver);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.notificationManager != null) {
            this.notificationManager.cancel(1);
        }
        this.stopForeground(true);
        this.stopSelf();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        boolean playing = intent.getBooleanExtra("playing", false);
        if (playing) {
            this.play();
        }
        return super.onStartCommand(intent, flags, startId);
    }

    public IBinder onBind(Intent arg0) {
        return null;
    }

    private void initMediaPlayer() {
        if (this.mediaPlayer == null) {
            this.mediaPlayer = new MediaPlayer();
        }
        this.mediaPlayer.setVolume(0.5f, 0.5f);
        this.mediaPlayer.setLooping(false);
        this.mediaPlayer.setWakeMode((Context)this, 1);
        this.wifiLock = ((WifiManager)this.getApplicationContext().getSystemService("wifi")).createWifiLock(1, "wifilock");
        this.wifiLock.acquire();
        this.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                MediaPlayerService.this.mediaPlayer.start();
                MediaPlayerService.this.isPause = false;
            }
        });
        this.mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int i, int i1) {
                mediaPlayer.reset();
                return false;
            }
        });
        this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                MediaPlayerService.this.nextMusic();
            }
        });
    }

    private void play() {
        try {
            if (this.mediaPlayer == null) {
                this.initMediaPlayer();
            }
            if (this.isPause) {
                this.mediaPlayer.start();
                this.isPause = false;
            } else {
                this.mediaPlayer.reset();
                this.mediaPlayer.setDataSource(this.musics[this.current_item]);
                this.mediaPlayer.prepareAsync();
            }
            this.updateNotification();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void nextMusic() {
        ++this.current_item;
        if (this.current_item >= this.musics.length) {
            this.current_item = 0;
        }
        this.play();
    }

    private void updateNotification() {
        if (this.views != null) {
            this.views.setTextViewText(R.id.tv_name, (CharSequence)("\u97f3\u4e50\u540d" + this.current_item));
            this.views.setTextViewText(R.id.tv_author, (CharSequence)("\u4f5c\u8005" + this.current_item));
            if (!this.isPause) {
                this.views.setTextViewText(R.id.tv_pause, (CharSequence)"\u6682\u505c");
            } else {
                this.views.setTextViewText(R.id.tv_pause, (CharSequence)"\u64ad\u653e");
            }
        }
        this.notificationManager.notify(1, this.builder.build());
    }
}

