/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xpermissionlib;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.zhxh.xpermissionlib.PermissionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class Utils {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Application sApplication;
    static final ActivityLifecycleImpl ACTIVITY_LIFECYCLE;

    private Utils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void init(@NonNull Context context) {
        Utils.init((Application)context.getApplicationContext());
    }

    public static void init(@NonNull Application app) {
        if (sApplication == null) {
            sApplication = app;
            sApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)ACTIVITY_LIFECYCLE);
        }
    }

    public static Application getApp() {
        if (sApplication != null) {
            return sApplication;
        }
        try {
            Class<?> activityThread = Class.forName("android.app.ActivityThread");
            Object at = activityThread.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Object app = activityThread.getMethod("getApplication", new Class[0]).invoke(at, new Object[0]);
            if (app == null) {
                throw new NullPointerException("u should init first");
            }
            Utils.init((Application)app);
            return sApplication;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        throw new NullPointerException("u should init first");
    }

    static ActivityLifecycleImpl getActivityLifecycle() {
        return ACTIVITY_LIFECYCLE;
    }

    static LinkedList<Activity> getActivityList() {
        return Utils.ACTIVITY_LIFECYCLE.mActivityList;
    }

    static Context getTopActivityOrApp() {
        if (Utils.isAppForeground()) {
            Activity topActivity = ACTIVITY_LIFECYCLE.getTopActivity();
            return topActivity == null ? Utils.getApp() : topActivity;
        }
        return Utils.getApp();
    }

    static boolean isAppForeground() {
        ActivityManager am = (ActivityManager)Utils.getApp().getSystemService("activity");
        if (am == null) {
            return false;
        }
        List info = am.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (aInfo.importance != 100) continue;
            return aInfo.processName.equals(Utils.getApp().getPackageName());
        }
        return false;
    }

    static {
        ACTIVITY_LIFECYCLE = new ActivityLifecycleImpl();
    }

    public static interface OnAppStatusChangedListener {
        public void onForeground();

        public void onBackground();
    }

    static class ActivityLifecycleImpl
    implements Application.ActivityLifecycleCallbacks {
        final LinkedList<Activity> mActivityList = new LinkedList();
        final HashMap<Object, OnAppStatusChangedListener> mStatusListenerMap = new HashMap();
        private int mForegroundCount = 0;
        private int mConfigCount = 0;

        ActivityLifecycleImpl() {
        }

        void addListener(Object object, OnAppStatusChangedListener listener) {
            this.mStatusListenerMap.put(object, listener);
        }

        void removeListener(Object object) {
            this.mStatusListenerMap.remove(object);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            this.setTopActivity(activity);
        }

        public void onActivityStarted(Activity activity) {
            this.setTopActivity(activity);
            if (this.mForegroundCount <= 0) {
                this.postStatus(true);
            }
            if (this.mConfigCount < 0) {
                ++this.mConfigCount;
            } else {
                ++this.mForegroundCount;
            }
        }

        public void onActivityResumed(Activity activity) {
            this.setTopActivity(activity);
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            if (activity.isChangingConfigurations()) {
                --this.mConfigCount;
            } else {
                --this.mForegroundCount;
                if (this.mForegroundCount <= 0) {
                    this.postStatus(false);
                }
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            this.mActivityList.remove(activity);
        }

        private void postStatus(boolean isForeground) {
            if (this.mStatusListenerMap.isEmpty()) {
                return;
            }
            for (OnAppStatusChangedListener onAppStatusChangedListener : this.mStatusListenerMap.values()) {
                if (onAppStatusChangedListener == null) {
                    return;
                }
                if (isForeground) {
                    onAppStatusChangedListener.onForeground();
                    continue;
                }
                onAppStatusChangedListener.onBackground();
            }
        }

        private void setTopActivity(Activity activity) {
            if (activity.getClass() == PermissionUtils.PermissionActivity.class) {
                return;
            }
            if (this.mActivityList.contains(activity)) {
                if (!this.mActivityList.getLast().equals(activity)) {
                    this.mActivityList.remove(activity);
                    this.mActivityList.addLast(activity);
                }
            } else {
                this.mActivityList.addLast(activity);
            }
        }

        Activity getTopActivity() {
            Activity topActivity;
            if (!this.mActivityList.isEmpty() && (topActivity = this.mActivityList.getLast()) != null) {
                return topActivity;
            }
            try {
                Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
                Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
                Field activitiesField = activityThreadClass.getDeclaredField("mActivityList");
                activitiesField.setAccessible(true);
                Map activities = (Map)activitiesField.get(activityThread);
                if (activities == null) {
                    return null;
                }
                for (Object activityRecord : activities.values()) {
                    Class<?> activityRecordClass = activityRecord.getClass();
                    Field pausedField = activityRecordClass.getDeclaredField("paused");
                    pausedField.setAccessible(true);
                    if (pausedField.getBoolean(activityRecord)) continue;
                    Field activityField = activityRecordClass.getDeclaredField("activity");
                    activityField.setAccessible(true);
                    Activity activity = (Activity)activityField.get(activityRecord);
                    this.setTopActivity(activity);
                    return activity;
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

