/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xpermissionlib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.MotionEvent;
import com.zhxh.xpermissionlib.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class PermissionUtils {
    private static final List<String> PERMISSIONS = PermissionUtils.getPermissions();
    private static PermissionUtils sInstance;
    private OnRationaleListener mOnRationaleListener;
    private SimpleCallback mSimpleCallback;
    private FullCallback mFullCallback;
    private ThemeCallback mThemeCallback;
    private Set<String> mPermissions;
    private List<String> mPermissionsRequest;
    private List<String> mPermissionsGranted;
    private List<String> mPermissionsDenied;
    private List<String> mPermissionsDeniedForever;

    public static List<String> getPermissions() {
        return PermissionUtils.getPermissions(Utils.getApp().getPackageName());
    }

    public static List<String> getPermissions(String packageName) {
        PackageManager pm = Utils.getApp().getPackageManager();
        try {
            return Arrays.asList(pm.getPackageInfo((String)packageName, (int)4096).requestedPermissions);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static boolean isGranted(String ... permissions) {
        for (String permission : permissions) {
            if (PermissionUtils.isGranted(permission)) continue;
            return false;
        }
        return true;
    }

    private static boolean isGranted(String permission) {
        return Build.VERSION.SDK_INT < 23 || 0 == ContextCompat.checkSelfPermission((Context)Utils.getApp(), (String)permission);
    }

    public static void launchAppDetailsSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + Utils.getApp().getPackageName())));
        Utils.getApp().startActivity(intent.addFlags(0x10000000));
    }

    public PermissionUtils rationale(OnRationaleListener listener) {
        this.mOnRationaleListener = listener;
        return this;
    }

    public PermissionUtils callback(SimpleCallback callback) {
        this.mSimpleCallback = callback;
        return this;
    }

    public PermissionUtils callback(FullCallback callback) {
        this.mFullCallback = callback;
        return this;
    }

    public PermissionUtils theme(ThemeCallback callback) {
        this.mThemeCallback = callback;
        return this;
    }

    public void request() {
        this.mPermissionsGranted = new ArrayList<String>();
        this.mPermissionsRequest = new ArrayList<String>();
        if (Build.VERSION.SDK_INT < 23) {
            this.mPermissionsGranted.addAll(this.mPermissions);
            this.requestCallback();
        } else {
            for (String permission : this.mPermissions) {
                if (PermissionUtils.isGranted(permission)) {
                    this.mPermissionsGranted.add(permission);
                    continue;
                }
                this.mPermissionsRequest.add(permission);
            }
            if (this.mPermissionsRequest.isEmpty()) {
                this.requestCallback();
            } else {
                this.startPermissionActivity();
            }
        }
    }

    @RequiresApi(api=23)
    private void startPermissionActivity() {
        this.mPermissionsDenied = new ArrayList<String>();
        this.mPermissionsDeniedForever = new ArrayList<String>();
        PermissionActivity.start((Context)Utils.getApp());
    }

    @RequiresApi(api=23)
    private boolean rationale(Activity activity) {
        boolean isRationale = false;
        if (this.mOnRationaleListener != null) {
            for (String permission : this.mPermissionsRequest) {
                if (!activity.shouldShowRequestPermissionRationale(permission)) continue;
                this.getPermissionsStatus(activity);
                isRationale = true;
                break;
            }
            this.mOnRationaleListener = null;
        }
        return isRationale;
    }

    private void getPermissionsStatus(Activity activity) {
        for (String permission : this.mPermissionsRequest) {
            if (PermissionUtils.isGranted(permission)) {
                this.mPermissionsGranted.add(permission);
                continue;
            }
            this.mPermissionsDenied.add(permission);
            if (activity.shouldShowRequestPermissionRationale(permission)) continue;
            this.mPermissionsDeniedForever.add(permission);
        }
    }

    private void requestCallback() {
        if (this.mSimpleCallback != null) {
            if (this.mPermissionsRequest.size() == 0 || this.mPermissions.size() == this.mPermissionsGranted.size()) {
                this.mSimpleCallback.onGranted();
            } else if (!this.mPermissionsDenied.isEmpty()) {
                this.mSimpleCallback.onDenied();
            }
            this.mSimpleCallback = null;
        }
        if (this.mFullCallback != null) {
            if (this.mPermissionsRequest.size() == 0 || this.mPermissions.size() == this.mPermissionsGranted.size()) {
                this.mFullCallback.onGranted(this.mPermissionsGranted);
            } else if (!this.mPermissionsDenied.isEmpty()) {
                this.mFullCallback.onDenied(this.mPermissionsDeniedForever, this.mPermissionsDenied);
            }
            this.mFullCallback = null;
        }
        this.mOnRationaleListener = null;
        this.mThemeCallback = null;
    }

    private void onRequestPermissionsResult(Activity activity) {
        this.getPermissionsStatus(activity);
        this.requestCallback();
    }

    public static interface ThemeCallback {
        public void onActivityCreate(Activity var1);
    }

    public static interface FullCallback {
        public void onGranted(List<String> var1);

        public void onDenied(List<String> var1, List<String> var2);
    }

    public static interface SimpleCallback {
        public void onGranted();

        public void onDenied();
    }

    public static interface OnRationaleListener {
        public void rationale(ShouldRequest var1);

        public static interface ShouldRequest {
            public void again(boolean var1);
        }
    }

    @RequiresApi(api=23)
    public static class PermissionActivity
    extends Activity {
        public static void start(Context context) {
            Intent starter = new Intent(context, PermissionActivity.class);
            starter.addFlags(0x10000000);
            context.startActivity(starter);
        }

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            this.getWindow().addFlags(262160);
            if (sInstance == null) {
                super.onCreate(savedInstanceState);
                Log.e((String)"PermissionUtils", (String)"request permissions failed");
                this.finish();
                return;
            }
            if (sInstance.mThemeCallback != null) {
                sInstance.mThemeCallback.onActivityCreate(this);
            }
            super.onCreate(savedInstanceState);
            if (sInstance.rationale(this)) {
                this.finish();
                return;
            }
            if (sInstance.mPermissionsRequest != null) {
                int size = sInstance.mPermissionsRequest.size();
                if (size <= 0) {
                    this.finish();
                    return;
                }
                this.requestPermissions(sInstance.mPermissionsRequest.toArray(new String[size]), 1);
            }
        }

        public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            sInstance.onRequestPermissionsResult(this);
            this.finish();
        }

        public boolean dispatchTouchEvent(MotionEvent ev) {
            this.finish();
            return true;
        }
    }
}

