/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xnetworklib.downloader.utils;

import com.zhxh.xnetworklib.downloader.core.Core;
import com.zhxh.xnetworklib.downloader.database.DownloadModel;
import com.zhxh.xnetworklib.downloader.httpclient.HttpClient;
import com.zhxh.xnetworklib.downloader.internal.ComponentHolder;
import com.zhxh.xnetworklib.downloader.request.DownloadRequest;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public final class Utils {
    private static final int MAX_REDIRECTION = 10;

    private Utils() {
    }

    public static String getPath(String dirPath, String fileName) {
        return dirPath + File.separator + fileName;
    }

    public static String getTempPath(String dirPath, String fileName) {
        return Utils.getPath(dirPath, fileName) + ".temp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameFileName(String oldPath, String newPath) throws IOException {
        File oldFile = new File(oldPath);
        try {
            File newFile = new File(newPath);
            if (newFile.exists() && !newFile.delete()) {
                throw new IOException("Deletion Failed");
            }
            if (!oldFile.renameTo(newFile)) {
                throw new IOException("Rename Failed");
            }
        }
        finally {
            if (oldFile.exists()) {
                oldFile.delete();
            }
        }
    }

    public static void deleteTempFileAndDatabaseEntryInBackground(final String path, final int downloadId) {
        Core.getInstance().getExecutorSupplier().forBackgroundTasks().execute(new Runnable(){

            @Override
            public void run() {
                ComponentHolder.getInstance().getDbHelper().remove(downloadId);
                File file = new File(path);
                if (file.exists()) {
                    file.delete();
                }
            }
        });
    }

    public static void deleteUnwantedModelsAndTempFiles(final int days) {
        Core.getInstance().getExecutorSupplier().forBackgroundTasks().execute(new Runnable(){

            @Override
            public void run() {
                List<DownloadModel> models = ComponentHolder.getInstance().getDbHelper().getUnwantedModels(days);
                if (models != null) {
                    for (DownloadModel model : models) {
                        String tempPath = Utils.getTempPath(model.getDirPath(), model.getFileName());
                        ComponentHolder.getInstance().getDbHelper().remove(model.getId());
                        File file = new File(tempPath);
                        if (!file.exists()) continue;
                        file.delete();
                    }
                }
            }
        });
    }

    public static int getUniqueId(String url, String dirPath, String fileName) {
        byte[] hash;
        String string = url + File.separator + dirPath + File.separator + fileName;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("NoSuchAlgorithmException", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UnsupportedEncodingException", e);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString().hashCode();
    }

    public static HttpClient getRedirectedConnectionIfAny(HttpClient httpClient, DownloadRequest request) throws IOException, IllegalAccessException {
        int redirectTimes = 0;
        int code = httpClient.getResponseCode();
        String location = httpClient.getResponseHeader("Location");
        while (Utils.isRedirection(code)) {
            if (location == null) {
                throw new IllegalAccessException("Location is null");
            }
            httpClient.close();
            request.setUrl(location);
            httpClient = ComponentHolder.getInstance().getHttpClient();
            httpClient.connect(request);
            code = httpClient.getResponseCode();
            location = httpClient.getResponseHeader("Location");
            if (++redirectTimes < 10) continue;
            throw new IllegalAccessException("Max redirection done");
        }
        return httpClient;
    }

    private static boolean isRedirection(int code) {
        return code == 301 || code == 302 || code == 303 || code == 300 || code == 307 || code == 308;
    }
}

