/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xnetworklib.downloader.internal;

import com.zhxh.xnetworklib.downloader.Status;
import com.zhxh.xnetworklib.downloader.core.Core;
import com.zhxh.xnetworklib.downloader.internal.DownloadRunnable;
import com.zhxh.xnetworklib.downloader.request.DownloadRequest;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadRequestQueue {
    private static DownloadRequestQueue instance;
    private final Map<Integer, DownloadRequest> currentRequestMap = new ConcurrentHashMap<Integer, DownloadRequest>();
    private final AtomicInteger sequenceGenerator = new AtomicInteger();

    private DownloadRequestQueue() {
    }

    public static void initialize() {
        DownloadRequestQueue.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadRequestQueue getInstance() {
        if (instance != null) return instance;
        Class<DownloadRequestQueue> clazz = DownloadRequestQueue.class;
        synchronized (DownloadRequestQueue.class) {
            if (instance != null) return instance;
            instance = new DownloadRequestQueue();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private int getSequenceNumber() {
        return this.sequenceGenerator.incrementAndGet();
    }

    public void pause(int downloadId) {
        DownloadRequest request = this.currentRequestMap.get(downloadId);
        if (request != null) {
            request.setStatus(Status.PAUSED);
        }
    }

    public void resume(int downloadId) {
        DownloadRequest request = this.currentRequestMap.get(downloadId);
        if (request != null) {
            request.setStatus(Status.QUEUED);
            request.setFuture(Core.getInstance().getExecutorSupplier().forDownloadTasks().submit(new DownloadRunnable(request)));
        }
    }

    private void cancelAndRemoveFromMap(DownloadRequest request) {
        if (request != null) {
            request.cancel();
            this.currentRequestMap.remove(request.getDownloadId());
        }
    }

    public void cancel(int downloadId) {
        DownloadRequest request = this.currentRequestMap.get(downloadId);
        this.cancelAndRemoveFromMap(request);
    }

    public void cancel(Object tag) {
        for (Map.Entry<Integer, DownloadRequest> currentRequestMapEntry : this.currentRequestMap.entrySet()) {
            DownloadRequest request = currentRequestMapEntry.getValue();
            if (request.getTag() instanceof String && tag instanceof String) {
                String tempTag;
                String tempRequestTag = (String)request.getTag();
                if (!tempRequestTag.equals(tempTag = (String)tag)) continue;
                this.cancelAndRemoveFromMap(request);
                continue;
            }
            if (!request.getTag().equals(tag)) continue;
            this.cancelAndRemoveFromMap(request);
        }
    }

    public void cancelAll() {
        for (Map.Entry<Integer, DownloadRequest> currentRequestMapEntry : this.currentRequestMap.entrySet()) {
            DownloadRequest request = currentRequestMapEntry.getValue();
            this.cancelAndRemoveFromMap(request);
        }
    }

    public Status getStatus(int downloadId) {
        DownloadRequest request = this.currentRequestMap.get(downloadId);
        if (request != null) {
            return request.getStatus();
        }
        return Status.UNKNOWN;
    }

    public void addRequest(DownloadRequest request) {
        this.currentRequestMap.put(request.getDownloadId(), request);
        request.setStatus(Status.QUEUED);
        request.setSequenceNumber(this.getSequenceNumber());
        request.setFuture(Core.getInstance().getExecutorSupplier().forDownloadTasks().submit(new DownloadRunnable(request)));
    }

    public void finish(DownloadRequest request) {
        this.currentRequestMap.remove(request.getDownloadId());
    }
}

