/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xnetworklib.downloader.internal;

import android.content.Context;
import com.zhxh.xnetworklib.downloader.XNetDownloader;
import com.zhxh.xnetworklib.downloader.XNetDownloaderConfig;
import com.zhxh.xnetworklib.downloader.database.AppDbHelper;
import com.zhxh.xnetworklib.downloader.database.DbHelper;
import com.zhxh.xnetworklib.downloader.database.NoOpsDbHelper;
import com.zhxh.xnetworklib.downloader.httpclient.DefaultHttpClient;
import com.zhxh.xnetworklib.downloader.httpclient.HttpClient;

public class ComponentHolder {
    private static final ComponentHolder INSTANCE = new ComponentHolder();
    private int readTimeout;
    private int connectTimeout;
    private String userAgent;
    private HttpClient httpClient;
    private DbHelper dbHelper;

    public static ComponentHolder getInstance() {
        return INSTANCE;
    }

    public void init(Context context, XNetDownloaderConfig config) {
        this.readTimeout = config.getReadTimeout();
        this.connectTimeout = config.getConnectTimeout();
        this.userAgent = config.getUserAgent();
        this.httpClient = config.getHttpClient();
        DbHelper dbHelper = this.dbHelper = config.isDatabaseEnabled() ? new AppDbHelper(context) : new NoOpsDbHelper();
        if (config.isDatabaseEnabled()) {
            XNetDownloader.cleanUp(30);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getReadTimeout() {
        if (this.readTimeout != 0) return this.readTimeout;
        Class<ComponentHolder> clazz = ComponentHolder.class;
        synchronized (ComponentHolder.class) {
            if (this.readTimeout != 0) return this.readTimeout;
            this.readTimeout = 20000;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.readTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getConnectTimeout() {
        if (this.connectTimeout != 0) return this.connectTimeout;
        Class<ComponentHolder> clazz = ComponentHolder.class;
        synchronized (ComponentHolder.class) {
            if (this.connectTimeout != 0) return this.connectTimeout;
            this.connectTimeout = 20000;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.connectTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getUserAgent() {
        if (this.userAgent != null) return this.userAgent;
        Class<ComponentHolder> clazz = ComponentHolder.class;
        synchronized (ComponentHolder.class) {
            if (this.userAgent != null) return this.userAgent;
            this.userAgent = "XNetDownloader";
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.userAgent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DbHelper getDbHelper() {
        if (this.dbHelper != null) return this.dbHelper;
        Class<ComponentHolder> clazz = ComponentHolder.class;
        synchronized (ComponentHolder.class) {
            if (this.dbHelper != null) return this.dbHelper;
            this.dbHelper = new NoOpsDbHelper();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.dbHelper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HttpClient getHttpClient() {
        if (this.httpClient != null) return this.httpClient.clone();
        Class<ComponentHolder> clazz = ComponentHolder.class;
        synchronized (ComponentHolder.class) {
            if (this.httpClient != null) return this.httpClient.clone();
            this.httpClient = new DefaultHttpClient();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.httpClient.clone();
        }
    }
}

