/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xnetworklib.downloader;

import android.content.Context;
import com.zhxh.xnetworklib.downloader.Status;
import com.zhxh.xnetworklib.downloader.XNetDownloaderConfig;
import com.zhxh.xnetworklib.downloader.core.Core;
import com.zhxh.xnetworklib.downloader.internal.ComponentHolder;
import com.zhxh.xnetworklib.downloader.internal.DownloadRequestQueue;
import com.zhxh.xnetworklib.downloader.request.DownloadRequestBuilder;
import com.zhxh.xnetworklib.downloader.utils.Utils;

public class XNetDownloader {
    private XNetDownloader() {
    }

    public static void initialize(Context context) {
        XNetDownloader.initialize(context, XNetDownloaderConfig.newBuilder().build());
    }

    public static void initialize(Context context, XNetDownloaderConfig config) {
        ComponentHolder.getInstance().init(context, config);
        DownloadRequestQueue.initialize();
    }

    public static DownloadRequestBuilder download(String url, String dirPath, String fileName) {
        return new DownloadRequestBuilder(url, dirPath, fileName);
    }

    public static void pause(int downloadId) {
        DownloadRequestQueue.getInstance().pause(downloadId);
    }

    public static void resume(int downloadId) {
        DownloadRequestQueue.getInstance().resume(downloadId);
    }

    public static void cancel(int downloadId) {
        DownloadRequestQueue.getInstance().cancel(downloadId);
    }

    public static void cancel(Object tag) {
        DownloadRequestQueue.getInstance().cancel(tag);
    }

    public static void cancelAll() {
        DownloadRequestQueue.getInstance().cancelAll();
    }

    public static Status getStatus(int downloadId) {
        return DownloadRequestQueue.getInstance().getStatus(downloadId);
    }

    public static void cleanUp(int days) {
        Utils.deleteUnwantedModelsAndTempFiles(days);
    }

    public static void shutDown() {
        Core.shutDown();
    }
}

