/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xdialoglib.toast;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationManagerCompat;
import android.util.Log;
import com.zhxh.xdialoglib.toast.CustomToast;
import com.zhxh.xdialoglib.toast.IToast;
import com.zhxh.xdialoglib.toast.SystemToast;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class XToast {
    private static int notificationEnabledValue = -1;
    public static final int UNIVERSAL = 0;
    public static final int EMPHASIZE = 1;
    public static final int CLICKABLE = 2;
    public static final int LENGTH_LONG = 1;
    public static final int LENGTH_SHORT = 0;

    public static IToast makeText(@NonNull Context context, @NonNull String text, int duration) {
        return XToast.makeText(context, text, duration, 0);
    }

    public static IToast makeText(@NonNull Context context, @NonNull String text, int duration, int type) {
        if (notificationEnabledValue < 0) {
            notificationEnabledValue = Build.VERSION.SDK_INT >= 19 ? (NotificationManagerCompat.from((Context)context).areNotificationsEnabled() ? 1 : 0) : 0;
        }
        if (notificationEnabledValue > 0 && type != 2) {
            Log.e((String)"TAG", (String)(notificationEnabledValue + "SystemToast"));
            return SystemToast.makeText(context, text, duration, type);
        }
        Log.e((String)"TAG", (String)(notificationEnabledValue + "CustomToast"));
        return CustomToast.makeText(context, text, duration, type);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Duration {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

