/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xdialoglib.toast;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.zhxh.xdialoglib.R;
import com.zhxh.xdialoglib.toast.IToast;
import com.zhxh.xdialoglib.toast.SafeToastContext;
import com.zhxh.xdialoglib.toast.XToast;
import java.lang.reflect.Field;

public class SystemToast
implements IToast {
    @NonNull
    private final Toast mToast;
    @NonNull
    private final Context mContext;
    private final int mType;
    private static final String TAG = XToast.class.getSimpleName();

    private SystemToast(@NonNull Context context, @NonNull Toast toast, int type) {
        this.mContext = context;
        this.mToast = toast;
        this.mType = type;
    }

    public static SystemToast makeText(@NonNull Context context, @NonNull String text, int duration) {
        return SystemToast.makeText(context, text, duration, 0);
    }

    public static SystemToast makeText(@NonNull Context context, @NonNull String text, int duration, int type) {
        Toast toast = Toast.makeText((Context)context, (CharSequence)text, (int)duration);
        int layoutId = R.layout.toast_universal;
        if (type == 1) {
            layoutId = R.layout.toast_emphasize;
            toast.setGravity(17, 0, 0);
        }
        View view = LayoutInflater.from((Context)context).inflate(layoutId, null);
        ((TextView)view.findViewById(R.id.text)).setText((CharSequence)text);
        toast.setView(view);
        if (Build.VERSION.SDK_INT == 24) {
            SystemToast.setContext(view, (Context)new SafeToastContext(context));
        }
        return new SystemToast(context, toast, type);
    }

    private static void setContext(@NonNull View view, @NonNull Context context) {
        try {
            Field field = View.class.getDeclaredField("mContext");
            field.setAccessible(true);
            field.set(view, context);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Deprecated
    public IToast setDuration(int duration) {
        this.mToast.setDuration(duration);
        return this;
    }

    @Override
    public IToast setIcon(int resId) {
        ImageView imageView = (ImageView)this.mToast.getView().findViewById(R.id.icon);
        imageView.setBackgroundResource(resId);
        imageView.setVisibility(0);
        return this;
    }

    @Override
    @Deprecated
    public IToast setAnimations(int animations) {
        Log.d((String)TAG, (String)"method:setAnimations is Deprecated , animations must be a system resource , considering the window manager does not have access to applications.");
        try {
            Field tnField = this.mToast.getClass().getDeclaredField("mTN");
            tnField.setAccessible(true);
            Object mTN = tnField.get(this.mToast);
            Field tnParamsField = mTN.getClass().getDeclaredField("mParams");
            tnParamsField.setAccessible(true);
            WindowManager.LayoutParams params = (WindowManager.LayoutParams)tnParamsField.get(mTN);
            params.windowAnimations = animations;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public IToast setColor(int colorRes) {
        GradientDrawable drawable2 = (GradientDrawable)this.mToast.getView().getBackground();
        drawable2.setColor(this.mContext.getResources().getColor(colorRes));
        return this;
    }

    @Override
    @TargetApi(value=16)
    public IToast setBackground(Drawable drawable2) {
        this.mToast.getView().setBackground(drawable2);
        return this;
    }

    @Override
    public IToast setGravity(int gravity, int xOffset, int yOffset) {
        this.mToast.setGravity(gravity, xOffset, yOffset);
        return this;
    }

    @Override
    public IToast setMargin(float horizontalMargin, float verticalMargin) {
        this.mToast.setMargin(horizontalMargin, verticalMargin);
        return this;
    }

    @Override
    public IToast setText(int resId) {
        this.mToast.setText(resId);
        return this;
    }

    @Override
    public IToast setText(@NonNull CharSequence charSequence) {
        this.mToast.setText(charSequence);
        return this;
    }

    @Override
    public void show() {
        this.mToast.show();
    }

    @Override
    @Deprecated
    public void cancel() {
        Log.e((String)TAG, (String)"only CustomToast can be canceled by user");
    }

    @Override
    public void showSuccess() {
        this.setIcon(this.mType == 1 ? R.drawable.ic_toast_check_circle_white_24dp : R.drawable.ic_toast_done_white_24dp);
        this.show();
    }

    @Override
    public void showError() {
        this.setIcon(R.drawable.ic_toast_clear_white_24dp);
        this.show();
    }

    @Override
    public void showWarning() {
        this.setIcon(R.drawable.ic_toast_error_outline_white_24dp);
        this.show();
    }

    @Override
    @Deprecated
    public IToast setClickCallBack(@NonNull String text, @NonNull View.OnClickListener listener) {
        Log.e((String)TAG, (String)"only CustomToast has click callback");
        return this;
    }

    @Override
    @Deprecated
    public IToast setClickCallBack(@NonNull String text, int resId, @NonNull View.OnClickListener listener) {
        Log.e((String)TAG, (String)"only CustomToast has click callback");
        return this;
    }
}

