/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xdialoglib.toast;

import android.content.Context;
import android.content.ContextWrapper;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;

final class SafeToastContext
extends ContextWrapper {
    SafeToastContext(@NonNull Context base) {
        super(base);
    }

    public Context getApplicationContext() {
        return new ApplicationContextWrapper(this.getBaseContext().getApplicationContext());
    }

    private static final class WindowManagerWrapper
    implements WindowManager {
        private static final String TAG = "WindowManagerWrapper";
        @NonNull
        private WindowManager base;

        private WindowManagerWrapper(@NonNull WindowManager base) {
            this.base = base;
        }

        public Display getDefaultDisplay() {
            return this.base.getDefaultDisplay();
        }

        public void removeViewImmediate(View view) {
            this.base.removeViewImmediate(view);
        }

        public void addView(View view, ViewGroup.LayoutParams params) {
            try {
                Log.d((String)TAG, (String)"WindowManager's addView(view, params) has been hooked.");
                this.base.addView(view, params);
            }
            catch (WindowManager.BadTokenException e) {
                Log.d((String)TAG, (String)"BadTokenException ignored");
            }
            catch (Throwable throwable) {
                Log.e((String)TAG, (String)"[addView]", (Throwable)throwable);
            }
        }

        public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
            this.base.updateViewLayout(view, params);
        }

        public void removeView(View view) {
            this.base.removeView(view);
        }
    }

    private static final class ApplicationContextWrapper
    extends ContextWrapper {
        private ApplicationContextWrapper(@NonNull Context base) {
            super(base);
        }

        public Object getSystemService(@NonNull String name) {
            if ("window".equals(name)) {
                return new WindowManagerWrapper((WindowManager)this.getBaseContext().getSystemService(name));
            }
            return super.getSystemService(name);
        }
    }
}

