/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xdialoglib.toast;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Handler;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zhxh.xdialoglib.R;
import com.zhxh.xdialoglib.toast.IToast;
import com.zhxh.xdialoglib.toast.XToast;

public class CustomToast
implements IToast {
    private WindowManager.LayoutParams mParams;
    private WindowManager mWindowManager;
    private View mView;
    private int mDuration;
    private Handler mHandler;
    private View.OnClickListener mListener = null;
    private final int mType;
    private static final int TIME_LONG = 3500;
    private static final int TIME_SHORT = 2000;
    private static final String TAG = XToast.class.getSimpleName();

    private CustomToast(@NonNull Context context, @NonNull String text, int duration, int type) {
        this.mType = type;
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        int layoutId = R.layout.toast_universal;
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                layoutId = R.layout.toast_emphasize;
                break;
            }
            case 2: {
                layoutId = R.layout.toast_clickable;
                break;
            }
        }
        this.mView = LayoutInflater.from((Context)context).inflate(layoutId, null);
        ((TextView)this.mView.findViewById(R.id.text)).setText((CharSequence)text);
        this.mDuration = duration == 1 ? 3500 : 2000;
        this.mParams = new WindowManager.LayoutParams();
        this.mParams.height = -2;
        this.mParams.width = -2;
        this.mParams.format = -3;
        this.mParams.windowAnimations = 16973828;
        this.mParams.type = 1003;
        this.mParams.setTitle((CharSequence)"Toast");
        this.mParams.flags = 131264;
        this.mHandler = new Handler();
    }

    public static CustomToast makeText(@NonNull Context context, @NonNull String text, int duration) {
        return CustomToast.makeText(context, text, duration, 0);
    }

    public static CustomToast makeText(@NonNull Context context, @NonNull String text, int duration, int type) {
        return new CustomToast(context, text, duration, type);
    }

    @Override
    public IToast setDuration(int duration) {
        this.mDuration = duration == 0 ? 2000 : (duration == 1 ? 3500 : duration);
        return this;
    }

    @Override
    public IToast setIcon(int resId) {
        ImageView imageView = (ImageView)this.mView.findViewById(R.id.icon);
        imageView.setBackgroundResource(resId);
        imageView.setVisibility(0);
        return this;
    }

    @Override
    public IToast setAnimations(int animations) {
        this.mParams.windowAnimations = animations;
        return this;
    }

    @Override
    public IToast setColor(int colorRes) {
        GradientDrawable drawable2 = (GradientDrawable)this.mView.getBackground();
        drawable2.setColor(this.mView.getContext().getResources().getColor(colorRes));
        return this;
    }

    @Override
    @TargetApi(value=16)
    public IToast setBackground(Drawable drawable2) {
        this.mView.setBackground(drawable2);
        return this;
    }

    @Override
    @TargetApi(value=17)
    public IToast setGravity(int gravity, int xOffset, int yOffset) {
        int g;
        Configuration config = this.mView.getContext().getResources().getConfiguration();
        this.mParams.gravity = g = Gravity.getAbsoluteGravity((int)gravity, (int)config.getLayoutDirection());
        if ((g & 7) == 7) {
            this.mParams.horizontalWeight = 1.0f;
        }
        if ((g & 0x70) == 112) {
            this.mParams.verticalWeight = 1.0f;
        }
        this.mParams.x = xOffset;
        this.mParams.y = yOffset;
        return this;
    }

    @Override
    public IToast setMargin(float horizontalMargin, float verticalMargin) {
        this.mParams.verticalMargin = verticalMargin;
        this.mParams.horizontalMargin = horizontalMargin;
        return this;
    }

    @Override
    public IToast setText(int resId) {
        ((TextView)this.mView.findViewById(R.id.text)).setText(resId);
        return this;
    }

    @Override
    public IToast setText(@NonNull CharSequence charSequence) {
        ((TextView)this.mView.findViewById(R.id.text)).setText(charSequence);
        return this;
    }

    @Override
    public void show() {
        if (this.mType == 2 && this.mListener == null) {
            Log.e((String)TAG, (String)"the listener of clickable toast is null,have you called method:setClickCallBack?");
            return;
        }
        if (this.mView.getParent() != null) {
            this.mWindowManager.removeView(this.mView);
        }
        Log.e((String)TAG, (String)"addView");
        this.mWindowManager.addView(this.mView, (ViewGroup.LayoutParams)this.mParams);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CustomToast.this.cancel();
            }
        }, (long)this.mDuration);
    }

    @Override
    public void cancel() {
        this.mWindowManager.removeView(this.mView);
        this.mParams = null;
        this.mWindowManager = null;
        this.mView = null;
        this.mHandler = null;
        this.mListener = null;
    }

    @Override
    public void showSuccess() {
        this.setIcon(this.mType == 1 ? R.drawable.ic_toast_check_circle_white_24dp : R.drawable.ic_toast_done_white_24dp);
        this.show();
    }

    @Override
    public void showError() {
        this.setIcon(R.drawable.ic_toast_clear_white_24dp);
        this.show();
    }

    @Override
    public void showWarning() {
        this.setIcon(R.drawable.ic_toast_error_outline_white_24dp);
        this.show();
    }

    @Override
    public IToast setClickCallBack(@NonNull String text, @NonNull View.OnClickListener listener) {
        return this.setClickCallBack(text, R.drawable.ic_toast_play_arrow_white_24dp, listener);
    }

    @Override
    public IToast setClickCallBack(@NonNull String text, @DrawableRes int resId, @NonNull View.OnClickListener listener) {
        if (this.mType != 2) {
            Log.d((String)TAG, (String)"only clickable toast has click callback!!!");
            return this;
        }
        this.mListener = listener;
        LinearLayout layout2 = (LinearLayout)this.mView.findViewById(R.id.btn);
        layout2.setVisibility(0);
        layout2.setOnClickListener(listener);
        TextView textView = (TextView)layout2.findViewById(R.id.btn_text);
        textView.setText((CharSequence)text);
        ImageView imageView = (ImageView)layout2.findViewById(R.id.btn_icon);
        imageView.setBackgroundResource(resId);
        return this;
    }
}

