/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xdialoglib.dialog.widget;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import com.zhxh.xdialoglib.R;
import com.zhxh.xdialoglib.dialog.adapter.PopWindowAdapter;
import com.zhxh.xdialoglib.dialog.bean.PopBean;
import com.zhxh.xdialoglib.dialog.listener.IDropListener;
import java.util.ArrayList;
import java.util.List;

public class PopupWindowView
implements AdapterView.OnItemClickListener {
    View viewItem = null;
    ListView popupListView;
    PopupWindow pullDownView;
    private List<PopBean> popupList = new ArrayList<PopBean>();
    private PopWindowAdapter popWindowAdapter;
    private Context mContext;
    private IDropListener dropListener;
    private int maxLine = 5;

    public PopupWindowView(Context mContext, int widthGravity) {
        this.mContext = mContext;
        LayoutInflater inflater = LayoutInflater.from((Context)mContext);
        this.viewItem = inflater.inflate(R.layout.xdialog_popu_options, null);
        this.popupListView = (ListView)this.viewItem.findViewById(R.id.customui_list);
        this.popWindowAdapter = new PopWindowAdapter(mContext, this.popupList);
        this.popupListView.setAdapter((ListAdapter)this.popWindowAdapter);
        this.pullDownView = new PopupWindow(this.viewItem, widthGravity, -2, true);
        this.pullDownView.setOutsideTouchable(true);
        this.pullDownView.setBackgroundDrawable((Drawable)new BitmapDrawable());
        this.popupListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
    }

    public void initPopupData(IDropListener dropListener) {
        this.dropListener = dropListener;
        if (this.dropListener != null) {
            this.dropListener.initPopData(this.popupList);
        }
        if (this.popupList != null && this.popupList.size() > this.maxLine) {
            this.pullDownView.setHeight(this.dip2px(this.maxLine * 40));
        }
        this.popWindowAdapter.notifyDataSetChanged();
    }

    private int dip2px(int dip) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)((float)dip * scale + 0.5f);
    }

    public void setMaxLines(int maxLines) {
        this.maxLine = maxLines;
    }

    public void showing(View v) {
        this.pullDownView.showAsDropDown(v, 0, 0);
    }

    public void dismiss() {
        this.pullDownView.dismiss();
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long l) {
        if (this.dropListener != null) {
            this.dismiss();
            this.dropListener.onItemClick(adapterView, view, position);
        }
    }

    public String getTitle(int popuPosition) {
        return this.popupList.get(popuPosition).getTitle();
    }

    public int getId(int popuPosition) {
        return this.popupList.get(popuPosition).getId();
    }

    public String getSid(int popuPosition) {
        return this.popupList.get(popuPosition).getSid();
    }
}

