/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xdialoglib.dialog.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zhxh.xdialoglib.R;
import com.zhxh.xdialoglib.dialog.adapter.XWheelAdapter;
import com.zhxh.xdialoglib.dialog.listener.OnWheelChangedListener;
import com.zhxh.xdialoglib.dialog.widget.WheelView;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateSelectorWheelView
extends RelativeLayout
implements OnWheelChangedListener {
    private final String flag = this.getClass().getSimpleName();
    public static final int TYPE_YYYYMM = 0;
    public static final int TYPE_YYYYMMDD = 1;
    public static final int TYPE_YYYYMMDDHHMM = 2;
    public static final int TYPE_YYYYMMDDHHMMSS = 3;
    private RelativeLayout rlTitle;
    private View lineL;
    private LinearLayout llWheelViews;
    private TextView tvSubTitle;
    private TextView tvYear;
    private TextView tvMonth;
    private TextView tvDay;
    private TextView tvHour;
    private TextView tvMinute;
    private TextView tvSecond;
    private View line0;
    private TextView tv_empty;
    private TextView tv_line1;
    private TextView tv_line2;
    private WheelView wvYear;
    private WheelView wvMonth;
    private WheelView wvDay;
    private WheelView wvHour;
    private WheelView wvMinute;
    private WheelView wvSecond;
    private long mDate;
    private String[] years = new String[141];
    private String[] months = new String[12];
    private String[] tinyDays = new String[28];
    private String[] smallDays = new String[29];
    private String[] normalDays = new String[30];
    private String[] bigDays = new String[31];
    private String[] hours = new String[24];
    private String[] minutes = new String[60];
    private String[] seconds = new String[60];
    private XWheelAdapter yearsAdapter;
    private XWheelAdapter monthsAdapter;
    private XWheelAdapter tinyDaysAdapter;
    private XWheelAdapter smallDaysAdapter;
    private XWheelAdapter bigDaysAdapter;
    private XWheelAdapter normalDaysAdapter;
    private XWheelAdapter hoursAdapter;
    private XWheelAdapter minutesAdapter;
    private XWheelAdapter secondsAdapter;
    private int currentDateType;
    private int todayHour;
    private int todayMinute;
    private int todaySecond;
    int currentMonth = 1;

    public DateSelectorWheelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initLayout(context);
    }

    public DateSelectorWheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initLayout(context);
    }

    public DateSelectorWheelView(Context context) {
        super(context);
        this.initLayout(context);
    }

    private void initLayout(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.xdialog_datepick_date_selector_layout, (ViewGroup)this, true);
        this.rlTitle = (RelativeLayout)this.findViewById(R.id.rl_date_time_title);
        this.lineL = this.findViewById(R.id.line_1);
        this.llWheelViews = (LinearLayout)this.findViewById(R.id.ll_wheel_views);
        this.tvSubTitle = (TextView)this.findViewById(R.id.tv_date_time_subtitle);
        this.tvYear = (TextView)this.findViewById(R.id.tv_date_time_year);
        this.tvMonth = (TextView)this.findViewById(R.id.tv_date_time_month);
        this.tvDay = (TextView)this.findViewById(R.id.tv_date_time_day);
        this.tvHour = (TextView)this.findViewById(R.id.tv_date_time_hour);
        this.tvMinute = (TextView)this.findViewById(R.id.tv_date_time_minute);
        this.tvSecond = (TextView)this.findViewById(R.id.tv_date_time_second);
        this.line0 = this.findViewById(R.id.tv_date_time_line0);
        this.tv_empty = (TextView)this.findViewById(R.id.tv_date_time_empty);
        this.tv_line1 = (TextView)this.findViewById(R.id.tv_date_time_line1);
        this.tv_line2 = (TextView)this.findViewById(R.id.tv_date_time_line2);
        this.wvYear = (WheelView)this.findViewById(R.id.wv_date_of_year);
        this.wvMonth = (WheelView)this.findViewById(R.id.wv_date_of_month);
        this.wvDay = (WheelView)this.findViewById(R.id.wv_date_of_day);
        this.wvHour = (WheelView)this.findViewById(R.id.wv_date_of_hour);
        this.wvMinute = (WheelView)this.findViewById(R.id.wv_date_of_minute);
        this.wvSecond = (WheelView)this.findViewById(R.id.wv_date_of_second);
        this.wvYear.addChangingListener(this);
        this.wvMonth.addChangingListener(this);
        this.wvDay.addChangingListener(this);
        this.wvHour.addChangingListener(this);
        this.wvMinute.addChangingListener(this);
        this.wvSecond.addChangingListener(this);
        this.setData();
        this.setShowDate(0L);
        this.setShowDateType(1);
    }

    private void setData() {
        int i;
        for (i = 0; i < this.years.length; ++i) {
            this.years[i] = 1960 + i + " \u5e74";
        }
        for (i = 0; i < this.months.length; ++i) {
            this.months[i] = i < 9 ? "0" + (1 + i) + " \u6708" : 1 + i + " \u6708";
        }
        for (i = 0; i < this.tinyDays.length; ++i) {
            this.tinyDays[i] = i < 9 ? "0" + (1 + i) + " \u65e5" : 1 + i + " \u65e5";
        }
        for (i = 0; i < this.smallDays.length; ++i) {
            this.smallDays[i] = i < 9 ? "0" + (1 + i) + " \u65e5" : 1 + i + " \u65e5";
        }
        for (i = 0; i < this.normalDays.length; ++i) {
            this.normalDays[i] = i < 9 ? "0" + (1 + i) + " \u65e5" : 1 + i + " \u65e5";
        }
        for (i = 0; i < this.bigDays.length; ++i) {
            this.bigDays[i] = i < 9 ? "0" + (1 + i) + " \u65e5" : 1 + i + " \u65e5";
        }
        for (i = 0; i < this.hours.length; ++i) {
            this.hours[i] = i <= 9 ? "0" + i + " \u65f6" : i + " \u65f6";
        }
        for (i = 0; i < this.minutes.length; ++i) {
            this.minutes[i] = i <= 9 ? "0" + i + " \u5206" : i + " \u5206";
        }
        for (i = 0; i < this.seconds.length; ++i) {
            this.seconds[i] = i <= 9 ? "0" + i + " \u79d2" : i + " \u79d2";
        }
        this.yearsAdapter = new XWheelAdapter(this.years);
        this.monthsAdapter = new XWheelAdapter(this.months);
        this.tinyDaysAdapter = new XWheelAdapter(this.tinyDays);
        this.smallDaysAdapter = new XWheelAdapter(this.smallDays);
        this.normalDaysAdapter = new XWheelAdapter(this.normalDays);
        this.bigDaysAdapter = new XWheelAdapter(this.bigDays);
        this.hoursAdapter = new XWheelAdapter(this.hours);
        this.minutesAdapter = new XWheelAdapter(this.minutes);
        this.secondsAdapter = new XWheelAdapter(this.seconds);
        this.wvYear.setAdapter(this.yearsAdapter);
        this.wvYear.setCyclic(true);
        this.wvMonth.setAdapter(this.monthsAdapter);
        this.wvMonth.setCyclic(true);
        if (this.isBigMonth(this.getTodayMonth() + 1)) {
            this.wvDay.setAdapter(this.bigDaysAdapter);
        } else if (this.getTodayMonth() == 1 && this.isLeapYear(this.wvYear.getCurrentItemValue().subSequence(0, 4).toString().trim())) {
            this.wvDay.setAdapter(this.smallDaysAdapter);
        } else if (this.getTodayMonth() == 1) {
            this.wvDay.setAdapter(this.tinyDaysAdapter);
        } else {
            this.wvDay.setAdapter(this.normalDaysAdapter);
        }
        this.wvDay.setCyclic(true);
        this.wvHour.setAdapter(this.hoursAdapter);
        this.wvHour.setCyclic(true);
        this.wvMinute.setAdapter(this.minutesAdapter);
        this.wvMinute.setCyclic(true);
        this.wvSecond.setAdapter(this.secondsAdapter);
        this.wvSecond.setCyclic(true);
    }

    public void setShowDate(long date) {
        this.mDate = date;
        this.wvYear.setCurrentItem(this.getTodayYear());
        this.wvMonth.setCurrentItem(this.getTodayMonth());
        this.wvDay.setCurrentItem(this.getTodayDay());
        this.wvHour.setCurrentItem(this.getTodayHour());
        this.wvMinute.setCurrentItem(this.getTodayMinute());
        this.wvSecond.setCurrentItem(this.getTodaySecond());
    }

    public void setShowDateType(int type) {
        this.currentDateType = type;
        switch (type) {
            case 0: {
                this.line0.setVisibility(8);
                this.tvDay.setVisibility(8);
                this.tv_empty.setVisibility(8);
                this.tv_line1.setVisibility(8);
                this.tv_line2.setVisibility(8);
                this.tvHour.setVisibility(8);
                this.tvMinute.setVisibility(8);
                this.tvSecond.setVisibility(8);
                this.wvHour.setVisibility(8);
                this.wvMinute.setVisibility(8);
                this.wvSecond.setVisibility(8);
                this.wvYear.setStyle(18);
                this.wvMonth.setStyle(18);
                this.wvDay.setStyle(18);
                this.wvHour.setStyle(18);
                this.wvMinute.setStyle(18);
                this.wvSecond.setStyle(18);
                break;
            }
            case 1: {
                this.line0.setVisibility(0);
                this.tvDay.setVisibility(0);
                this.tv_empty.setVisibility(8);
                this.tv_line1.setVisibility(8);
                this.tv_line2.setVisibility(8);
                this.tvHour.setVisibility(8);
                this.tvMinute.setVisibility(8);
                this.tvSecond.setVisibility(8);
                this.wvHour.setVisibility(8);
                this.wvMinute.setVisibility(8);
                this.wvSecond.setVisibility(8);
                this.wvYear.setStyle(14);
                this.wvMonth.setStyle(14);
                this.wvDay.setStyle(14);
                this.wvHour.setStyle(14);
                this.wvMinute.setStyle(14);
                this.wvSecond.setStyle(14);
                break;
            }
            case 2: {
                this.line0.setVisibility(0);
                this.tvDay.setVisibility(0);
                this.tv_empty.setVisibility(0);
                this.tv_line1.setVisibility(0);
                this.tvHour.setVisibility(0);
                this.tvMinute.setVisibility(0);
                this.wvHour.setVisibility(0);
                this.wvMinute.setVisibility(0);
                this.tvSecond.setVisibility(8);
                this.tv_line2.setVisibility(8);
                this.wvSecond.setVisibility(8);
                this.wvYear.setStyle(14);
                this.wvMonth.setStyle(14);
                this.wvDay.setStyle(14);
                this.wvHour.setStyle(14);
                this.wvMinute.setStyle(14);
                this.wvSecond.setStyle(14);
                break;
            }
            case 3: {
                this.line0.setVisibility(0);
                this.tvDay.setVisibility(0);
                this.tv_empty.setVisibility(0);
                this.tv_line1.setVisibility(0);
                this.tv_line2.setVisibility(0);
                this.tvHour.setVisibility(0);
                this.tvMinute.setVisibility(0);
                this.tvSecond.setVisibility(0);
                this.wvHour.setVisibility(0);
                this.wvMinute.setVisibility(0);
                this.wvSecond.setVisibility(0);
                this.wvYear.setStyle(14);
                this.wvMonth.setStyle(14);
                this.wvDay.setStyle(14);
                this.wvHour.setStyle(14);
                this.wvMinute.setStyle(14);
                this.wvSecond.setStyle(14);
            }
        }
    }

    public void setCurrentYear(String year) {
        boolean overYear = true;
        year = year + " \u5e74";
        for (int i = 0; i < this.years.length; ++i) {
            if (!year.equals(this.years[i])) continue;
            this.wvYear.setCurrentItem(i);
            overYear = false;
            break;
        }
        if (overYear) {
            Log.e((String)this.flag, (String)"\u8bbe\u7f6e\u7684\u5e74\u4efd\u8d85\u51fa\u4e86\u6570\u7ec4\u7684\u8303\u56f4");
        }
    }

    public void setCurrentMonth(String month) {
        month = month + " \u6708";
        for (int i = 0; i < this.months.length; ++i) {
            if (!month.equals(this.months[i])) continue;
            this.wvMonth.setCurrentItem(i);
            break;
        }
    }

    public void setCurrentDay(String day) {
        day = day + " \u65e5";
        for (int i = 0; i < this.smallDays.length; ++i) {
            if (!day.equals(this.smallDays[i])) continue;
            this.wvDay.setCurrentItem(i);
            break;
        }
    }

    public String getSelectedDate() {
        switch (this.currentDateType) {
            case 0: {
                return this.tvYear.getText().toString().trim() + "-" + this.tvMonth.getText().toString().trim();
            }
            case 1: {
                return this.tvYear.getText().toString().trim() + "-" + this.tvMonth.getText().toString().trim() + "-" + this.tvDay.getText().toString().trim();
            }
            case 2: {
                return this.tvYear.getText().toString().trim() + "-" + this.tvMonth.getText().toString().trim() + "-" + this.tvDay.getText().toString().trim() + " " + this.tvHour.getText().toString().trim() + ":" + this.tvMinute.getText().toString().trim();
            }
            case 3: {
                return this.tvYear.getText().toString().trim() + "-" + this.tvMonth.getText().toString().trim() + "-" + this.tvDay.getText().toString().trim() + " " + this.tvHour.getText().toString().trim() + ":" + this.tvMinute.getText().toString().trim() + ":" + this.tvSecond.getText().toString().trim();
            }
        }
        return this.tvYear.getText().toString().trim() + "-" + this.tvMonth.getText().toString().trim() + "-" + this.tvDay.getText().toString().trim() + " " + this.tvHour.getText().toString().trim() + ":" + this.tvMinute.getText().toString().trim() + ":" + this.tvSecond.getText().toString().trim();
    }

    public void setTitleClick(View.OnClickListener onClickListener) {
        this.rlTitle.setOnClickListener(onClickListener);
    }

    public void setDateSelectorVisiblility(int visibility) {
        this.lineL.setVisibility(visibility);
        this.llWheelViews.setVisibility(visibility);
    }

    public int getDateSelectorVisibility() {
        return this.llWheelViews.getVisibility();
    }

    private boolean isLeapYear(String year) {
        int temp = Integer.parseInt(year);
        return temp % 4 == 0 && (temp % 100 != 0 || temp % 400 == 0);
    }

    private boolean isBigMonth(int month) {
        boolean isBigMonth = false;
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                isBigMonth = true;
                break;
            }
            default: {
                isBigMonth = false;
            }
        }
        return isBigMonth;
    }

    @Override
    public void onChanged(WheelView wheel, int oldValue, int newValue) {
        String trim = null;
        if (wheel.getId() == this.wvYear.getId()) {
            trim = this.wvYear.getCurrentItemValue().trim().split(" ")[0];
            this.tvYear.setText((CharSequence)trim);
            if (this.isLeapYear(trim)) {
                if (this.currentMonth == 2) {
                    this.wvDay.setAdapter(this.smallDaysAdapter);
                } else if (this.isBigMonth(this.currentMonth)) {
                    this.wvDay.setAdapter(this.bigDaysAdapter);
                } else {
                    this.wvDay.setAdapter(this.normalDaysAdapter);
                }
            } else if (this.currentMonth == 2) {
                this.wvDay.setAdapter(this.tinyDaysAdapter);
            } else if (this.isBigMonth(this.currentMonth)) {
                this.wvDay.setAdapter(this.bigDaysAdapter);
            } else {
                this.wvDay.setAdapter(this.normalDaysAdapter);
            }
        } else if (wheel.getId() == this.wvMonth.getId()) {
            trim = this.wvMonth.getCurrentItemValue().trim().split(" ")[0];
            this.currentMonth = Integer.parseInt(trim);
            this.tvMonth.setText((CharSequence)trim);
            switch (this.currentMonth) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    this.wvDay.setAdapter(this.bigDaysAdapter);
                    break;
                }
                case 2: {
                    String yearString = this.wvYear.getCurrentItemValue().trim().split(" ")[0];
                    if (this.isLeapYear(yearString)) {
                        this.wvDay.setAdapter(this.smallDaysAdapter);
                        break;
                    }
                    this.wvDay.setAdapter(this.tinyDaysAdapter);
                    break;
                }
                default: {
                    this.wvDay.setAdapter(this.normalDaysAdapter);
                    break;
                }
            }
        } else if (wheel.getId() == this.wvDay.getId()) {
            this.tvDay.setText((CharSequence)this.wvDay.getCurrentItemValue().trim().split(" ")[0]);
        } else if (wheel.getId() == this.wvHour.getId()) {
            this.tvHour.setText((CharSequence)this.wvHour.getCurrentItemValue().trim().split(" ")[0]);
        } else if (wheel.getId() == this.wvMinute.getId()) {
            this.tvMinute.setText((CharSequence)this.wvMinute.getCurrentItemValue().trim().split(" ")[0]);
        } else if (wheel.getId() == this.wvSecond.getId()) {
            this.tvSecond.setText((CharSequence)this.wvSecond.getCurrentItemValue().trim().split(" ")[0]);
        }
    }

    public int getTitleId() {
        if (this.rlTitle != null) {
            return this.rlTitle.getId();
        }
        return 0;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private String getToday() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
        Date curDate = this.mDate > 0L ? new Date(this.mDate) : new Date(System.currentTimeMillis());
        String str = formatter.format(curDate);
        return str;
    }

    private int getTodayYear() {
        int position = 0;
        String today = this.getToday();
        String year = today.substring(0, 4);
        if (this.tvYear != null) {
            this.tvYear.setText((CharSequence)year);
        }
        year = year + " \u5e74";
        for (int i = 0; i < this.years.length; ++i) {
            if (!year.equals(this.years[i])) continue;
            position = i;
            break;
        }
        return position;
    }

    private int getTodayMonth() {
        int position = 0;
        String today = this.getToday();
        String month = today.substring(5, 7);
        if (this.tvMonth != null) {
            this.tvMonth.setText((CharSequence)month);
        }
        month = month + " \u6708";
        for (int i = 0; i < this.months.length; ++i) {
            if (!month.equals(this.months[i])) continue;
            position = i;
            break;
        }
        return position;
    }

    private int getTodayDay() {
        int position = 0;
        String today = this.getToday();
        String day = today.substring(8, 10);
        if (this.tvDay != null) {
            this.tvDay.setText((CharSequence)day);
        }
        day = day + " \u65e5";
        for (int i = 0; i < this.bigDays.length; ++i) {
            if (!day.equals(this.bigDays[i])) continue;
            position = i;
            break;
        }
        return position;
    }

    public int getTodayHour() {
        int position = 0;
        String today = this.getToday();
        String hour = today.substring(12, 14);
        if (this.tvHour != null) {
            this.tvHour.setText((CharSequence)hour);
        }
        hour = hour + " \u65f6";
        for (int i = 0; i < this.hours.length; ++i) {
            if (!hour.equals(this.hours[i])) continue;
            position = i;
            break;
        }
        return position;
    }

    public int getTodayMinute() {
        int position = 0;
        String today = this.getToday();
        String minute = today.substring(15, 17);
        if (this.tvMinute != null) {
            this.tvMinute.setText((CharSequence)minute);
        }
        minute = minute + " \u5206";
        for (int i = 0; i < this.minutes.length; ++i) {
            if (!minute.equals(this.minutes[i])) continue;
            position = i;
            break;
        }
        return position;
    }

    public int getTodaySecond() {
        int position = 0;
        String today = this.getToday();
        String second = today.substring(18, 20);
        if (this.tvSecond != null) {
            this.tvSecond.setText((CharSequence)second);
        }
        second = second + " \u79d2";
        for (int i = 0; i < this.seconds.length; ++i) {
            if (!second.equals(this.seconds[i])) continue;
            position = i;
            break;
        }
        return position;
    }
}

