/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xdialoglib.dialog.utils;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import com.zhxh.xdialoglib.DialogUtils;
import com.zhxh.xdialoglib.dialog.bean.BuildBean;

public class ToolUtils {
    public static void showDialog(Dialog dialog) {
        try {
            if (dialog != null) {
                dialog.show();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static BuildBean fixContext(BuildBean bean) {
        if (bean.mContext == null) {
            bean.mContext = DialogUtils.appContext;
        } else if (bean.mContext instanceof Activity) {
            Activity activity = (Activity)bean.mContext;
            if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
                bean.mContext = DialogUtils.appContext;
            }
        }
        return bean;
    }

    public static BuildBean setCancelable(BuildBean bean) {
        if (bean.alertDialog != null) {
            bean.alertDialog.setCancelable(bean.cancelable);
            bean.alertDialog.setCanceledOnTouchOutside(bean.outsideTouchable);
        } else if (bean.dialog != null) {
            bean.dialog.setCancelable(bean.cancelable);
            bean.dialog.setCanceledOnTouchOutside(bean.outsideTouchable);
        }
        return bean;
    }

    public static void setDialogStyle(BuildBean bean) {
        if (bean.alertDialog != null) {
            ToolUtils.setMdBtnStytle(bean);
        } else {
            ToolUtils.setDialogStyle(bean.mContext, bean.dialog, bean.viewHeight, bean);
        }
    }

    public static void setMdBtnStytle(BuildBean bean) {
        Button btnPositive = bean.alertDialog.getButton(-1);
        Button btnNegative = bean.alertDialog.getButton(-2);
        Button btnNatural = bean.alertDialog.getButton(-3);
        if (btnPositive != null && btnNegative != null) {
            btnPositive.setTextSize((float)bean.btnTxtSize);
            btnNegative.setTextSize((float)bean.btnTxtSize);
            btnNatural.setTextSize((float)bean.btnTxtSize);
            if (bean.btn1Color != 0) {
                btnPositive.setTextColor(ToolUtils.getColor(null, bean.btn1Color));
            }
            if (bean.btn2Color != 0) {
                btnNegative.setTextColor(ToolUtils.getColor(null, bean.btn2Color));
            }
            if (bean.btn3Color != 0) {
                btnNatural.setTextColor(ToolUtils.getColor(null, bean.btn3Color));
            }
        }
        Window window = bean.alertDialog.getWindow();
        window.setGravity(bean.gravity);
    }

    public static void setDialogStyle(Context context, Dialog dialog, int measuredHeight, BuildBean bean) {
        if (dialog == null) {
            return;
        }
        Window window = dialog.getWindow();
        window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        window.setGravity(bean.gravity);
        WindowManager.LayoutParams wl = window.getAttributes();
        int width = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getWidth();
        int height = (int)((double)((WindowManager)context.getSystemService("window")).getDefaultDisplay().getHeight() * 0.9);
        wl.width = bean.type != 2 ? (int)((double)width * 0.94) : -2;
        wl.height = -2;
        if (measuredHeight > height) {
            wl.height = height;
        }
        if (context instanceof Activity) {
            Activity activity1 = (Activity)context;
            if (Build.VERSION.SDK_INT >= 17 && activity1.isDestroyed()) {
                context = DialogUtils.appContext;
            }
        } else {
            wl.type = 2005;
        }
        dialog.onWindowAttributesChanged(wl);
    }

    public static void measureView(View child) {
        ViewGroup.LayoutParams p = child.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
        }
        int lpHeight = p.height;
        int lpWidth = p.width;
        int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int childWidthSpec = lpWidth > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    public static int mesureHeight(View root, int id2) {
        View view;
        ToolUtils.measureView(root);
        int height = root.getMeasuredHeight();
        int heightExtra = 0;
        if (id2 > 0 && (view = root.findViewById(id2)) != null) {
            ToolUtils.measureView(view);
            heightExtra = view.getMeasuredHeight();
        }
        return height + heightExtra;
    }

    public static int mesureHeight(View root, View ... subViews) {
        ToolUtils.measureView(root);
        int height = root.getMeasuredHeight();
        int heightExtra = 0;
        if (subViews != null && subViews.length > 0) {
            for (View view : subViews) {
                ToolUtils.measureView(view);
                heightExtra += view.getMeasuredHeight();
            }
        }
        return height + heightExtra;
    }

    public static int getColor(Context context, int colorRes) {
        if (context == null) {
            context = DialogUtils.appContext;
        }
        return context.getResources().getColor(colorRes);
    }

    public static String getString(Context context, int resId) {
        return context.getResources().getString(resId);
    }

    public static int dip2px(Context context, int dip) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)dip * scale + 0.5f);
    }

    public static int getScreenWidth(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        return windowManager.getDefaultDisplay().getWidth();
    }
}

