/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xdialoglib.dialog.listener;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.design.widget.BottomSheetDialog;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zhxh.xdialoglib.DialogUtils;
import com.zhxh.xdialoglib.R;
import com.zhxh.xdialoglib.dialog.bean.BuildBean;
import com.zhxh.xdialoglib.dialog.holder.AlertDialogHolder;
import com.zhxh.xdialoglib.dialog.holder.SheetHolder;
import com.zhxh.xdialoglib.dialog.utils.ToolUtils;
import com.zhxh.xdialoglib.dialog.widget.DateSelectorWheelView;

public class Buildable {
    protected static int singleChosen;

    protected BuildBean buildByType(BuildBean bean) {
        ToolUtils.fixContext(bean);
        switch (bean.type) {
            case 19: {
                this.buildDatePick(bean);
                break;
            }
            case 1: {
                this.buildLoading(bean);
                break;
            }
            case 2: {
                this.buildMdLoading(bean);
                break;
            }
            case 3: {
                this.buildMdAlert(bean);
                break;
            }
            case 5: {
                this.buildSingleChoose(bean);
                break;
            }
            case 4: {
                this.buildMdMultiChoose(bean);
                break;
            }
            case 6: {
                this.buildAlert(bean);
                break;
            }
            case 10: {
                this.buildSheet(bean);
                break;
            }
            case 15: {
                this.buildCustomAlert(bean);
                break;
            }
            case 16: {
                this.buildCustomBottomAlert(bean);
                break;
            }
            case 14: {
                this.buildBottomSheet(bean);
                break;
            }
        }
        ToolUtils.setDialogStyle(bean);
        ToolUtils.setCancelable(bean);
        return bean;
    }

    private BuildBean buildDatePick(final BuildBean bean) {
        AlertDialog dialog;
        AlertDialog.Builder builder = new AlertDialog.Builder(bean.mContext);
        View root = View.inflate((Context)bean.mContext, (int)R.layout.xdialog_datepick_layout, null);
        RelativeLayout rl_title_panel = (RelativeLayout)root.findViewById(R.id.rl_title_panel);
        FrameLayout flFirst = (FrameLayout)root.findViewById(R.id.fl_first);
        FrameLayout flNext = (FrameLayout)root.findViewById(R.id.fl_next);
        TextView tv_title = (TextView)root.findViewById(R.id.tv_title);
        TextView tv_first = (TextView)root.findViewById(R.id.tv_first);
        TextView tv_next = (TextView)root.findViewById(R.id.tv_next);
        FrameLayout fl_top_customPanel = (FrameLayout)root.findViewById(R.id.fl_top_customPanel);
        final DateSelectorWheelView dwvDate = (DateSelectorWheelView)root.findViewById(R.id.dwv_date);
        FrameLayout fl_bottom_customPanel = (FrameLayout)root.findViewById(R.id.fl_bottom_customPanel);
        dwvDate.setShowDate(bean.date);
        dwvDate.setShowDateType(bean.dateType);
        dwvDate.setTitleClick(new View.OnClickListener(){

            public void onClick(View v) {
                int id2 = v.getId();
                if (id2 == R.id.rl_date_time_title) {
                    if (dwvDate.getDateSelectorVisibility() == 0) {
                        dwvDate.setDateSelectorVisiblility(8);
                    } else {
                        dwvDate.setDateSelectorVisiblility(0);
                    }
                }
            }
        });
        builder.setView(root);
        bean.alertDialog = dialog = builder.create();
        if (bean.gravity == 80) {
            Window window = dialog.getWindow();
            window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
        flFirst.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
            }
        });
        flNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null != bean.dateTimeListener) {
                    bean.dateTimeListener.onSaveSelectedDate(bean.tag, dwvDate.getSelectedDate());
                }
                dialog.dismiss();
            }
        });
        return bean;
    }

    protected BuildBean buildMdLoading(BuildBean bean) {
        AlertDialog dialog;
        AlertDialog.Builder builder = new AlertDialog.Builder(bean.mContext);
        View root = bean.isVertical ? View.inflate((Context)bean.mContext, (int)R.layout.xdialog_loading_vertical, null) : View.inflate((Context)bean.mContext, (int)R.layout.xdialog_loading_horizontal, null);
        View llBg = root.findViewById(R.id.xdialog_ll_bg);
        ProgressBar pbBg = (ProgressBar)root.findViewById(R.id.pb_bg);
        TextView tvMsg = (TextView)root.findViewById(R.id.xdialog_tv_msg);
        tvMsg.setText(bean.msg);
        if (bean.isWhiteBg) {
            llBg.setBackgroundResource(R.drawable.xdialog_shape_wihte_round_corner);
            pbBg.setIndeterminateDrawable(bean.mContext.getResources().getDrawable(R.drawable.xdialog_rotate_mum));
            tvMsg.setTextColor(bean.mContext.getResources().getColor(R.color.C3));
        } else {
            llBg.setBackgroundResource(R.drawable.xdialog_shape_gray_round_corner);
            pbBg.setIndeterminateDrawable(bean.mContext.getResources().getDrawable(R.drawable.xdialog_rotate_mum_light));
            tvMsg.setTextColor(-1);
        }
        builder.setView(root);
        bean.alertDialog = dialog = builder.create();
        return bean;
    }

    protected BuildBean buildLoading(BuildBean bean) {
        Dialog dialog = new Dialog(bean.mContext);
        dialog.requestWindowFeature(1);
        bean.dialog = dialog;
        View root = bean.isVertical ? View.inflate((Context)bean.mContext, (int)R.layout.xdialog_loading_vertical, null) : View.inflate((Context)bean.mContext, (int)R.layout.xdialog_loading_horizontal, null);
        View llBg = root.findViewById(R.id.xdialog_ll_bg);
        ProgressBar pbBg = (ProgressBar)root.findViewById(R.id.pb_bg);
        TextView tvMsg = (TextView)root.findViewById(R.id.xdialog_tv_msg);
        tvMsg.setText(bean.msg);
        if (bean.isWhiteBg) {
            llBg.setBackgroundResource(R.drawable.xdialog_shape_wihte_round_corner);
            pbBg.setIndeterminateDrawable(bean.mContext.getResources().getDrawable(R.drawable.xdialog_rotate_mum));
            tvMsg.setTextColor(bean.mContext.getResources().getColor(R.color.C3));
        } else {
            llBg.setBackgroundResource(R.drawable.xdialog_shape_gray_round_corner);
            pbBg.setIndeterminateDrawable(bean.mContext.getResources().getDrawable(R.drawable.xdialog_rotate_mum_light));
            tvMsg.setTextColor(-1);
        }
        bean.dialog.setContentView(root);
        return bean;
    }

    protected BuildBean buildMdAlert(final BuildBean bean) {
        AlertDialog.Builder builder = new AlertDialog.Builder(bean.mContext);
        builder.setTitle(bean.title).setMessage(bean.msg).setPositiveButton(bean.text1, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                bean.listener.onPositive();
                dialog.dismiss();
            }
        }).setNegativeButton(bean.text2, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                bean.listener.onNegative();
                dialog.dismiss();
            }
        }).setNeutralButton(bean.text3, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                bean.listener.onNeutral();
                dialog.dismiss();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                bean.listener.onCancel();
            }
        });
        bean.alertDialog = dialog;
        return bean;
    }

    protected BuildBean buildSingleChoose(final BuildBean bean) {
        AlertDialog dialog;
        AlertDialog.Builder builder = new AlertDialog.Builder(bean.mContext);
        singleChosen = bean.defaultChosen;
        builder.setTitle(bean.title).setSingleChoiceItems(bean.wordsMd, bean.defaultChosen, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                singleChosen = i;
                if (bean.itemListener != null) {
                    bean.itemListener.onItemClick(bean.wordsMd[i], i);
                }
                if (bean.listener == null) {
                    DialogUtils.dismiss(dialogInterface);
                }
            }
        });
        bean.alertDialog = dialog = builder.create();
        return bean;
    }

    protected BuildBean buildMdMultiChoose(final BuildBean bean) {
        AlertDialog dialog;
        AlertDialog.Builder builder = new AlertDialog.Builder(bean.mContext);
        builder.setTitle(bean.title).setCancelable(true).setPositiveButton(bean.text1, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (bean.listener != null) {
                    DialogUtils.dismiss(dialogInterface);
                    bean.listener.onPositive();
                    bean.listener.onGetChoose(bean.checkedItems);
                }
            }
        }).setNegativeButton(bean.text2, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (bean.listener != null) {
                    DialogUtils.dismiss(dialogInterface);
                    bean.listener.onNegative();
                }
            }
        }).setMultiChoiceItems(bean.wordsMd, bean.checkedItems, new DialogInterface.OnMultiChoiceClickListener(){

            public void onClick(DialogInterface dialogInterface, int i, boolean b) {
            }
        });
        bean.alertDialog = dialog = builder.create();
        return bean;
    }

    protected BuildBean buildAlert(BuildBean bean) {
        AlertDialog dialog;
        AlertDialog.Builder builder = new AlertDialog.Builder(bean.mContext);
        AlertDialogHolder holder = new AlertDialogHolder(bean.mContext);
        builder.setView(holder.rootView);
        bean.alertDialog = dialog = builder.create();
        holder.assignDatasAndEvents(bean.mContext, bean);
        return bean;
    }

    private void buildCustomAlert(BuildBean bean) {
        AlertDialog dialog;
        AlertDialog.Builder builder = new AlertDialog.Builder(bean.mContext);
        builder.setView(bean.customView);
        bean.alertDialog = dialog = builder.create();
    }

    private void buildCustomBottomAlert(BuildBean bean) {
        BottomSheetDialog dialog = new BottomSheetDialog(bean.mContext);
        dialog.setContentView(bean.customView);
        bean.dialog = dialog;
    }

    protected BuildBean buildSheet(BuildBean bean) {
        AlertDialog dialog;
        AlertDialog.Builder builder = new AlertDialog.Builder(bean.mContext);
        SheetHolder holder = new SheetHolder(bean.mContext, true);
        builder.setView(holder.rootView);
        bean.alertDialog = dialog = builder.create();
        if (bean.isVertical && !TextUtils.isEmpty((CharSequence)bean.bottomTxt)) {
            Window window = dialog.getWindow();
            window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
        holder.assignDatasAndEvents(bean.mContext, bean);
        return bean;
    }

    private void buildBottomSheet(BuildBean bean) {
        BottomSheetDialog dialog = new BottomSheetDialog(bean.mContext);
        SheetHolder sheetHolder = new SheetHolder(bean.mContext, false);
        dialog.setContentView(sheetHolder.rootView);
        sheetHolder.assignDatasAndEvents(bean.mContext, bean);
        bean.dialog = dialog;
    }
}

