/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xdialoglib.dialog.holder;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.zhxh.xdialoglib.DialogUtils;
import com.zhxh.xdialoglib.R;
import com.zhxh.xdialoglib.dialog.adapter.BottomAdapter;
import com.zhxh.xdialoglib.dialog.bean.BuildBean;
import com.zhxh.xdialoglib.dialog.holder.BaseHolder;
import com.zhxh.xdialoglib.dialog.listener.OnItemClickListener;
import com.zhxh.xdialoglib.dialog.widget.DialogUIDividerItemDecoration;

public class SheetHolder
extends BaseHolder {
    private TextView tvTitle;
    private RecyclerView rView;
    private Button btnBottom;
    private boolean isItemType;

    public SheetHolder(Context context, boolean isItemType) {
        super(context);
        this.isItemType = isItemType;
    }

    @Override
    protected void findViews() {
        this.tvTitle = (TextView)this.rootView.findViewById(R.id.xdialog_tv_title);
        this.rView = (RecyclerView)this.rootView.findViewById(R.id.rlv);
        this.btnBottom = (Button)this.rootView.findViewById(R.id.btn_bottom);
    }

    @Override
    protected int setLayoutRes() {
        return R.layout.xdialog_holder_sheet;
    }

    @Override
    public void assignDatasAndEvents(Context context, final BuildBean bean) {
        if (TextUtils.isEmpty((CharSequence)bean.bottomTxt)) {
            this.btnBottom.setVisibility(8);
        } else {
            this.btnBottom.setVisibility(0);
            this.btnBottom.setText(bean.bottomTxt);
            this.btnBottom.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DialogUtils.dismiss(new DialogInterface[]{bean.dialog, bean.alertDialog});
                    bean.itemListener.onBottomBtnClick();
                }
            });
        }
        if (TextUtils.isEmpty((CharSequence)bean.title)) {
            this.tvTitle.setVisibility(8);
        } else {
            this.tvTitle.setVisibility(0);
            this.tvTitle.setText(bean.title);
        }
        if (bean.isVertical) {
            this.rView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(bean.mContext));
            this.rView.addItemDecoration((RecyclerView.ItemDecoration)new DialogUIDividerItemDecoration(bean.mContext));
        } else {
            this.rView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(bean.mContext, bean.gridColumns));
        }
        this.rView.setHasFixedSize(true);
        this.rView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        if (bean.mAdapter == null) {
            BottomAdapter adapter = new BottomAdapter(bean.mContext, bean.mLists, this.isItemType);
            bean.mAdapter = adapter;
        }
        this.rView.setAdapter((RecyclerView.Adapter)bean.mAdapter);
        bean.mAdapter.setOnItemClickListener(new OnItemClickListener(){

            @Override
            public void onItemClick(int position) {
                DialogUtils.dismiss(new DialogInterface[]{bean.dialog, bean.alertDialog});
                bean.itemListener.onItemClick(bean.mLists.get(position).getTitle(), position);
            }
        });
    }
}

