/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xdialoglib.dialog.holder;

import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zhxh.xdialoglib.DialogUtils;
import com.zhxh.xdialoglib.R;
import com.zhxh.xdialoglib.dialog.bean.BuildBean;
import com.zhxh.xdialoglib.dialog.holder.BaseHolder;
import com.zhxh.xdialoglib.dialog.utils.ToolUtils;

public class AlertDialogHolder
extends BaseHolder {
    protected TextView tvTitle;
    public TextView tvMsg;
    public EditText et1;
    public EditText et2;
    protected View line;
    protected Button btn1;
    protected View lineBtn2;
    protected Button btn2;
    protected View lineBtn3;
    protected Button btn3;
    protected LinearLayout llContainerHorizontal;
    protected Button btn1Vertical;
    protected View lineBtn2Vertical;
    protected Button btn2Vertical;
    protected View lineBtn3Vertical;
    protected Button btn3Vertical;
    protected LinearLayout llContainerVertical;

    public AlertDialogHolder(Context context) {
        super(context);
    }

    @Override
    protected void findViews() {
        this.tvTitle = (TextView)this.rootView.findViewById(R.id.xdialog_tv_title);
        this.tvMsg = (TextView)this.rootView.findViewById(R.id.xdialog_tv_msg);
        this.et1 = (EditText)this.rootView.findViewById(R.id.et_1);
        this.et2 = (EditText)this.rootView.findViewById(R.id.et_2);
        this.line = this.rootView.findViewById(R.id.line);
        this.btn1 = (Button)this.rootView.findViewById(R.id.btn_1);
        this.lineBtn2 = this.rootView.findViewById(R.id.line_btn2);
        this.btn2 = (Button)this.rootView.findViewById(R.id.btn_2);
        this.lineBtn3 = this.rootView.findViewById(R.id.line_btn3);
        this.btn3 = (Button)this.rootView.findViewById(R.id.btn_3);
        this.llContainerHorizontal = (LinearLayout)this.rootView.findViewById(R.id.ll_container_horizontal);
        this.btn1Vertical = (Button)this.rootView.findViewById(R.id.btn_1_vertical);
        this.lineBtn2Vertical = this.rootView.findViewById(R.id.line_btn2_vertical);
        this.btn2Vertical = (Button)this.rootView.findViewById(R.id.btn_2_vertical);
        this.lineBtn3Vertical = this.rootView.findViewById(R.id.line_btn3_vertical);
        this.btn3Vertical = (Button)this.rootView.findViewById(R.id.btn_3_vertical);
        this.llContainerVertical = (LinearLayout)this.rootView.findViewById(R.id.ll_container_vertical);
    }

    @Override
    protected int setLayoutRes() {
        return R.layout.xdialog_holder_alert;
    }

    @Override
    public void assignDatasAndEvents(Context context, final BuildBean bean) {
        this.tvMsg.setTextColor(ToolUtils.getColor(this.tvMsg.getContext(), bean.msgTxtColor));
        this.tvMsg.setTextSize((float)bean.msgTxtSize);
        this.tvTitle.setTextColor(ToolUtils.getColor(this.tvTitle.getContext(), bean.titleTxtColor));
        this.tvTitle.setTextSize((float)bean.titleTxtSize);
        this.btn3Vertical.setTextSize((float)bean.btnTxtSize);
        this.btn2Vertical.setTextSize((float)bean.btnTxtSize);
        this.btn1Vertical.setTextSize((float)bean.btnTxtSize);
        this.btn3.setTextSize((float)bean.btnTxtSize);
        this.btn2.setTextSize((float)bean.btnTxtSize);
        this.btn1.setTextSize((float)bean.btnTxtSize);
        this.btn1.setTextColor(ToolUtils.getColor(this.btn1.getContext(), bean.btn1Color));
        this.btn2.setTextColor(ToolUtils.getColor(this.btn1.getContext(), bean.btn2Color));
        this.btn3.setTextColor(ToolUtils.getColor(this.btn1.getContext(), bean.btn3Color));
        this.btn1Vertical.setTextColor(ToolUtils.getColor(this.btn1.getContext(), bean.btn1Color));
        this.btn2Vertical.setTextColor(ToolUtils.getColor(this.btn1.getContext(), bean.btn2Color));
        this.btn3Vertical.setTextColor(ToolUtils.getColor(this.btn1.getContext(), bean.btn3Color));
        if (bean.isVertical) {
            this.llContainerVertical.setVisibility(0);
            this.llContainerHorizontal.setVisibility(8);
        } else {
            this.llContainerVertical.setVisibility(8);
            this.llContainerHorizontal.setVisibility(0);
        }
        if (TextUtils.isEmpty((CharSequence)bean.title)) {
            this.tvTitle.setVisibility(8);
        } else {
            this.tvTitle.setVisibility(0);
            this.tvTitle.setText(bean.title);
        }
        if (TextUtils.isEmpty((CharSequence)bean.msg)) {
            this.tvMsg.setVisibility(8);
        } else {
            this.tvMsg.setVisibility(0);
            this.tvMsg.setText(bean.msg);
            this.tvMsg.setTextColor(ToolUtils.getColor(this.tvMsg.getContext(), bean.msgTxtColor));
            this.tvMsg.setTextSize((float)bean.msgTxtSize);
        }
        if (TextUtils.isEmpty((CharSequence)bean.hint1)) {
            this.et1.setVisibility(8);
        } else {
            this.et1.setVisibility(0);
            this.et1.setHint(bean.hint1);
            this.et1.setTextColor(ToolUtils.getColor(this.et1.getContext(), bean.inputTxtColor));
            this.et1.setTextSize((float)bean.inputTxtSize);
        }
        if (TextUtils.isEmpty((CharSequence)bean.hint2)) {
            this.et2.setVisibility(8);
        } else {
            this.et2.setVisibility(0);
            this.et2.setHint(bean.hint2);
            this.et2.setTextColor(ToolUtils.getColor(this.et2.getContext(), bean.inputTxtColor));
            this.et2.setTextSize((float)bean.inputTxtSize);
        }
        if (TextUtils.isEmpty((CharSequence)bean.text3)) {
            if (bean.isVertical) {
                this.btn3Vertical.setVisibility(8);
                this.lineBtn3Vertical.setVisibility(8);
                this.btn2Vertical.setBackgroundResource(R.drawable.xdialog_selector_all_bottom);
            } else {
                this.btn3.setVisibility(8);
                this.lineBtn3.setVisibility(8);
                this.btn2.setBackgroundResource(R.drawable.xdialog_selector_right_bottom);
            }
        } else if (bean.isVertical) {
            this.btn3Vertical.setVisibility(0);
            this.lineBtn3Vertical.setVisibility(0);
            this.btn3Vertical.setText(bean.text3);
        } else {
            this.btn3.setVisibility(0);
            this.lineBtn3.setVisibility(0);
            this.btn3.setText(bean.text3);
        }
        if (TextUtils.isEmpty((CharSequence)bean.text2)) {
            if (bean.isVertical) {
                this.btn2Vertical.setVisibility(8);
                this.lineBtn2Vertical.setVisibility(8);
                this.btn1Vertical.setBackgroundResource(R.drawable.xdialog_selector_all_bottom);
            } else {
                this.btn2.setVisibility(8);
                this.lineBtn2.setVisibility(8);
                this.btn1.setBackgroundResource(R.drawable.xdialog_selector_right_bottom);
            }
        } else if (bean.isVertical) {
            this.btn2Vertical.setVisibility(0);
            this.lineBtn2Vertical.setVisibility(0);
            this.btn2Vertical.setText(bean.text2);
        } else {
            this.btn2.setVisibility(0);
            this.lineBtn2.setVisibility(0);
            this.btn2.setText(bean.text2);
        }
        if (TextUtils.isEmpty((CharSequence)bean.text1)) {
            this.line.setVisibility(8);
            this.llContainerHorizontal.setVisibility(8);
            this.llContainerVertical.setVisibility(8);
        } else if (bean.isVertical) {
            this.btn1Vertical.setText(bean.text1);
        } else {
            this.btn1.setText(bean.text1);
        }
        if (bean.isVertical) {
            this.btn1Vertical.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DialogUtils.dismiss(new DialogInterface[]{bean.dialog, bean.alertDialog});
                    bean.listener.onPositive();
                    bean.listener.onGetInput(AlertDialogHolder.this.et1.getText().toString().trim(), AlertDialogHolder.this.et2.getText().toString().trim());
                }
            });
            this.btn2Vertical.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DialogUtils.dismiss(new DialogInterface[]{bean.dialog, bean.alertDialog});
                    bean.listener.onNegative();
                }
            });
            this.btn3Vertical.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DialogUtils.dismiss(new DialogInterface[]{bean.dialog, bean.alertDialog});
                    bean.listener.onNeutral();
                }
            });
        } else {
            this.btn1.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DialogUtils.dismiss(new DialogInterface[]{bean.dialog, bean.alertDialog});
                    bean.listener.onPositive();
                    bean.listener.onGetInput(AlertDialogHolder.this.et1.getText().toString().trim(), AlertDialogHolder.this.et2.getText().toString().trim());
                }
            });
            this.btn2.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DialogUtils.dismiss(new DialogInterface[]{bean.dialog, bean.alertDialog});
                    bean.listener.onNegative();
                }
            });
            this.btn3.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DialogUtils.dismiss(new DialogInterface[]{bean.dialog, bean.alertDialog});
                    bean.listener.onNeutral();
                }
            });
        }
    }
}

