/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xdialoglib;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AppCompatDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Toast;
import com.zhxh.xdialoglib.R;
import com.zhxh.xdialoglib.dialog.bean.BottomBean;
import com.zhxh.xdialoglib.dialog.bean.BuildBean;
import com.zhxh.xdialoglib.dialog.listener.DialogAssigner;
import com.zhxh.xdialoglib.dialog.listener.DialogUIDateTimeSaveListener;
import com.zhxh.xdialoglib.dialog.listener.DialogUIItemListener;
import com.zhxh.xdialoglib.dialog.listener.DialogUIListener;
import com.zhxh.xdialoglib.dialog.listener.IDropListener;
import com.zhxh.xdialoglib.dialog.utils.ToolUtils;
import com.zhxh.xdialoglib.dialog.widget.PopupWindowView;
import java.util.List;

public class DialogUtils {
    public static Context appContext;
    private static Toast mToast;
    private static Toast mToastTop;
    private static Toast mToastCenter;
    private static Toast mToastBottom;
    private static BuildBean mBuildBean;

    public static void init(Context appContext) {
        DialogUtils.appContext = appContext;
    }

    public static void dismiss(DialogInterface ... dialogs) {
        if (dialogs != null && dialogs.length > 0) {
            for (DialogInterface dialog : dialogs) {
                AppCompatDialog dialog2;
                if (dialog instanceof Dialog) {
                    Dialog dialog1 = (Dialog)dialog;
                    if (!dialog1.isShowing()) continue;
                    dialog1.dismiss();
                    continue;
                }
                if (!(dialog instanceof AppCompatDialog) || !(dialog2 = (AppCompatDialog)dialog).isShowing()) continue;
                dialog2.dismiss();
            }
        }
    }

    public static void dismiss(BuildBean buildBean) {
        if (buildBean != null) {
            if (buildBean.dialog != null && buildBean.dialog.isShowing()) {
                buildBean.dialog.dismiss();
            }
            if (buildBean.alertDialog != null && buildBean.alertDialog.isShowing()) {
                buildBean.alertDialog.dismiss();
            }
        }
    }

    public static void dismiss(Dialog dialog) {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }

    public static BuildBean showDatePick(Context context, int gravity, String dateTitle, long date, int dateType, int tag, DialogUIDateTimeSaveListener listener) {
        return DialogAssigner.getInstance().assignDatePick(context, gravity, dateTitle, date, dateType, tag, listener);
    }

    public static BuildBean showLoading(Context context, CharSequence msg, boolean isVertical, boolean cancleable, boolean outsideTouchable, boolean isWhiteBg) {
        return DialogAssigner.getInstance().assignLoading(context, msg, isVertical, cancleable, outsideTouchable, isWhiteBg);
    }

    public static BuildBean showMdLoading(Context context, CharSequence msg, boolean isVertical, boolean cancleable, boolean outsideTouchable, boolean isWhiteBg) {
        return DialogAssigner.getInstance().assignMdLoading(context, msg, isVertical, cancleable, outsideTouchable, isWhiteBg);
    }

    public static BuildBean showMdAlert(Activity activity, CharSequence title, CharSequence msg, DialogUIListener listener) {
        return DialogUtils.showMdAlert(activity, title, msg, true, true, listener);
    }

    public static BuildBean showMdAlert(Activity activity, CharSequence title, CharSequence msg, boolean cancleable, boolean outsideTouchable, DialogUIListener listener) {
        return DialogAssigner.getInstance().assignMdAlert(activity, title, msg, cancleable, outsideTouchable, listener);
    }

    public static BuildBean showMdMultiChoose(Activity activity, CharSequence title, CharSequence[] words, boolean[] checkedItems, DialogUIListener listener) {
        return DialogUtils.showMdMultiChoose(activity, title, words, checkedItems, true, true, listener);
    }

    public static BuildBean showMdMultiChoose(Activity activity, CharSequence title, CharSequence[] words, boolean[] checkedItems, boolean cancleable, boolean outsideTouchable, DialogUIListener listener) {
        return DialogAssigner.getInstance().assignMdMultiChoose(activity, title, words, checkedItems, cancleable, outsideTouchable, listener);
    }

    public static BuildBean showSingleChoose(Activity activity, CharSequence title, int defaultChosen, CharSequence[] words, DialogUIItemListener listener) {
        return DialogUtils.showSingleChoose(activity, title, defaultChosen, words, true, true, listener);
    }

    public static BuildBean showSingleChoose(Activity activity, CharSequence title, int defaultChosen, CharSequence[] words, boolean cancleable, boolean outsideTouchable, DialogUIItemListener listener) {
        return DialogAssigner.getInstance().assignSingleChoose(activity, title, defaultChosen, words, cancleable, outsideTouchable, listener);
    }

    public static BuildBean showAlert(Activity activity, CharSequence title, CharSequence msg, CharSequence hint1, CharSequence hint2, CharSequence firstTxt, CharSequence secondTxt, boolean isVertical, boolean cancleable, boolean outsideTouchable, DialogUIListener listener) {
        return DialogAssigner.getInstance().assignAlert((Context)activity, title, msg, hint1, hint2, firstTxt, secondTxt, isVertical, cancleable, outsideTouchable, listener);
    }

    public static BuildBean showSheet(Context context, List<BottomBean> datas, CharSequence bottomTxt, int gravity, boolean cancleable, boolean outsideTouchable, DialogUIItemListener listener) {
        return DialogAssigner.getInstance().assignSheet(context, datas, bottomTxt, gravity, cancleable, outsideTouchable, listener);
    }

    public static BuildBean showMdBottomSheet(Context context, boolean isVertical, CharSequence title, List<BottomBean> datas, int columnsNum, DialogUIItemListener listener) {
        return DialogUtils.showMdBottomSheet(context, isVertical, title, datas, columnsNum, true, true, listener);
    }

    public static BuildBean showMdBottomSheet(Context context, boolean isVertical, CharSequence title, List<BottomBean> datas, int columnsNum, boolean cancleable, boolean outsideTouchable, DialogUIItemListener listener) {
        return DialogAssigner.getInstance().assignMdBottomSheet(context, isVertical, title, datas, columnsNum, cancleable, outsideTouchable, listener);
    }

    public static BuildBean showCustomAlert(Context context, View contentView) {
        return DialogUtils.showCustomAlert(context, contentView, 17, true, true);
    }

    public static BuildBean showCustomAlert(Context context, View contentView, int gravity) {
        return DialogUtils.showCustomAlert(context, contentView, gravity, true, true);
    }

    public static BuildBean showCustomAlert(Context context, View contentView, int gravity, boolean cancleable, boolean outsideTouchable) {
        return DialogAssigner.getInstance().assignCustomAlert(context, contentView, gravity, cancleable, outsideTouchable);
    }

    public static BuildBean showCustomBottomAlert(Context context, View contentView) {
        return DialogUtils.showCustomBottomAlert(context, contentView, true, true);
    }

    public static BuildBean showCustomBottomAlert(Context context, View contentView, boolean cancleable, boolean outsideTouchable) {
        return DialogAssigner.getInstance().assignCustomBottomAlert(context, contentView, cancleable, outsideTouchable);
    }

    public static void showToast(int resId) {
        DialogUtils.showToast(ToolUtils.getString(appContext, resId));
    }

    public static void showToast(String str) {
        DialogUtils.showToast(str, 0, 80);
    }

    public static void showToastLong(int resId) {
        DialogUtils.showToastLong(ToolUtils.getString(appContext, resId));
    }

    public static void showToastLong(String str) {
        DialogUtils.showToast(str, 1, 80);
    }

    public static void showToastCenter(int resId) {
        DialogUtils.showToastCenter(ToolUtils.getString(appContext, resId));
    }

    public static void showToastCenter(String str) {
        DialogUtils.showToast(str, 0, 17);
    }

    public static void showToastCenterLong(int resId) {
        DialogUtils.showToastCenterLong(ToolUtils.getString(appContext, resId));
    }

    public static void showToastCenterLong(String str) {
        DialogUtils.showToast(str, 1, 17);
    }

    public static void showToastTop(int resId) {
        DialogUtils.showToastTop(ToolUtils.getString(appContext, resId));
    }

    public static void showToastTop(String str) {
        DialogUtils.showToast(str, 0, 48);
    }

    public static void showToastTopLong(int resId) {
        DialogUtils.showToastTopLong(ToolUtils.getString(appContext, resId));
    }

    public static void showToastTopLong(String str) {
        DialogUtils.showToast(str, 1, 48);
    }

    private static void showToast(String str, int showTime, int gravity) {
        if (appContext == null) {
            throw new RuntimeException("DialogUtils not initialized!");
        }
        if (gravity == 48) {
            if (mToastTop == null) {
                mToastTop = Toast.makeText((Context)appContext, (CharSequence)str, (int)showTime);
                LayoutInflater inflate = (LayoutInflater)appContext.getSystemService("layout_inflater");
                View view = inflate.inflate(R.layout.xdialog_toast, null);
                mToastTop.setView(view);
                mToastTop.setGravity(gravity, 0, appContext.getResources().getDimensionPixelSize(R.dimen.xdialog_toast_margin));
            }
            mToast = mToastTop;
            mToast.setText((CharSequence)str);
            mToast.show();
        } else if (gravity == 17) {
            if (mToastCenter == null) {
                mToastCenter = Toast.makeText((Context)appContext, (CharSequence)str, (int)showTime);
                LayoutInflater inflate = (LayoutInflater)appContext.getSystemService("layout_inflater");
                View view = inflate.inflate(R.layout.xdialog_toast, null);
                mToastCenter.setView(view);
                mToastCenter.setGravity(gravity, 0, 0);
            }
            mToast = mToastCenter;
            mToast.setText((CharSequence)str);
            mToast.show();
        } else if (gravity == 80) {
            if (mToastBottom == null) {
                mToastBottom = Toast.makeText((Context)appContext, (CharSequence)str, (int)showTime);
                LayoutInflater inflate = (LayoutInflater)appContext.getSystemService("layout_inflater");
                View view = inflate.inflate(R.layout.xdialog_toast, null);
                mToastBottom.setView(view);
                mToastBottom.setGravity(gravity, 0, appContext.getResources().getDimensionPixelSize(R.dimen.xdialog_toast_margin));
            }
            mToast = mToastBottom;
            mToast.setText((CharSequence)str);
            mToast.show();
        }
    }

    public static void showBottom(Context context) {
        DialogUtils.showBottom(context, "\u52a0\u8f7d\u4e2d...");
    }

    public static void showBottom(Context context, String str) {
        if (mBuildBean != null) {
            DialogUtils.dismiss(mBuildBean);
        }
        mBuildBean = DialogUtils.showLoading(context, str, false, true, false, true);
        mBuildBean.show();
    }

    public static void dismssBottom() {
        DialogUtils.dismiss(mBuildBean);
    }

    public static void showPopWindow(Context context, int widthGravity, int maxLine, View view, IDropListener dropListener) {
        PopupWindowView popupWindowView = new PopupWindowView(context, widthGravity);
        popupWindowView.setMaxLines(maxLine);
        popupWindowView.initPopupData(dropListener);
        popupWindowView.showing(view);
    }
}

