/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xdialoglib;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.zhxh.xdialoglib.R;

public class CommonDropDownView {
    private Context context;
    private View view;
    private Handler handler;
    public PopupWindow popupwindow;
    private int height = 0;
    private int width = 0;
    private View popView;
    private int selectIndex = 0;
    private String[] customArray;
    private boolean isShowUp = false;
    private int viewType = 0;
    int selectColor;
    int density = 3;

    public CommonDropDownView(Context context, View view, Handler handler, String[] showArray, int selectIndex) {
        this.isShowUp = false;
        this.context = context;
        this.view = view;
        this.handler = handler;
        this.customArray = showArray;
        this.selectIndex = selectIndex;
        this.createAutoDialog();
    }

    public CommonDropDownView(int viewType, Context context, View view, Handler handler, String[] showArray, int selectIndex) {
        this.viewType = viewType;
        this.isShowUp = false;
        this.context = context;
        this.view = view;
        this.handler = handler;
        this.customArray = showArray;
        this.selectIndex = selectIndex;
        this.createAutoDialog();
    }

    public CommonDropDownView(Context context, View view, Handler handler, String[] showArray, int selectIndex, boolean isShowUp) {
        this.context = context;
        this.view = view;
        this.handler = handler;
        this.customArray = showArray;
        this.selectIndex = selectIndex;
        this.isShowUp = isShowUp;
        this.createAutoDialog();
    }

    private void createAutoDialog() {
        this.selectColor = this.context.getResources().getColor(R.color.hot_red);
        if (this.viewType == 1) {
            this.selectColor = this.context.getResources().getColor(R.color.C13);
        }
        LayoutInflater inflate = (LayoutInflater)this.context.getSystemService("layout_inflater");
        View popupView = inflate.inflate(R.layout.pop_common_drop_down, null);
        if (this.isShowUp) {
            popupView.setBackgroundResource(R.drawable.topicchoose_down);
        } else {
            popupView.setBackgroundResource(R.drawable.topicchoose);
        }
        popupView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                CommonDropDownView.this.dismiss();
                return false;
            }
        });
        LinearLayout ll_pop_layout = (LinearLayout)popupView.findViewById(R.id.ll_pop_layout);
        for (int i = 0; i < this.customArray.length; ++i) {
            int tempIndex;
            int j;
            if (this.isShowUp) {
                j = this.customArray.length - 1 - i;
                tempIndex = this.selectIndex;
            } else {
                j = i;
                tempIndex = this.selectIndex;
            }
            View spaceLine = new View(this.context);
            spaceLine.setBackgroundColor(-10724003);
            LinearLayout.LayoutParams lineParams = new LinearLayout.LayoutParams(-1, 1);
            spaceLine.setLayoutParams((ViewGroup.LayoutParams)lineParams);
            spaceLine.setPadding(10, 0, 10, 0);
            TextView textView = new TextView(this.context);
            textView.setGravity(17);
            textView.setTextSize(2, 16.0f);
            textView.setText((CharSequence)this.customArray[j]);
            if (j == tempIndex) {
                textView.setTextColor(this.selectColor);
            } else {
                textView.setTextColor(this.context.getResources().getColor(R.color.color_white));
            }
            LinearLayout.LayoutParams textViewParams = new LinearLayout.LayoutParams(-1, -2);
            textView.setLayoutParams((ViewGroup.LayoutParams)textViewParams);
            if (j == 0 || j == this.customArray.length - 1) {
                textView.setPadding(0, this.getDensityValue(10, this.context), 0, this.getDensityValue(10, this.context));
            } else {
                textView.setPadding(0, this.getDensityValue(12, this.context), 0, this.getDensityValue(12, this.context));
            }
            textView.setBackgroundResource(R.drawable.trade_button_bg);
            ll_pop_layout.addView((View)textView);
            if (!this.isShowUp && j != this.customArray.length - 1) {
                ll_pop_layout.addView(spaceLine);
            }
            if (this.isShowUp && j != 0) {
                ll_pop_layout.addView(spaceLine);
            }
            textView.setOnClickListener((View.OnClickListener)new ClickTextView(j, ll_pop_layout));
        }
        int w = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int h = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        ll_pop_layout.measure(w, h);
        this.popView = ll_pop_layout;
        this.view.measure(w, h);
        this.width = ll_pop_layout.getMeasuredWidth();
        this.height = ll_pop_layout.getMeasuredHeight();
        int[] location = new int[2];
        this.view.getLocationOnScreen(location);
        this.popupwindow = new PopupWindow(popupView, this.width, this.height);
        this.popupwindow.setTouchable(true);
        this.popupwindow.setOutsideTouchable(true);
        this.popupwindow.setFocusable(true);
        this.popupwindow.setBackgroundDrawable((Drawable)new BitmapDrawable());
        this.popupwindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                CommonDropDownView.this.handler.sendEmptyMessage(-2);
            }
        });
    }

    private int getDensityValue(int i, Context context) {
        return this.density * i;
    }

    public void dismiss() {
        if (this.popupwindow != null && this.popupwindow.isShowing()) {
            this.popupwindow.dismiss();
        }
    }

    public void show() {
        int[] location = new int[2];
        this.view.getLocationInWindow(location);
        this.popupwindow.setAnimationStyle(R.style.popWindow_animation);
        this.popupwindow.showAtLocation(this.view, 48, location[0] - this.width * 3 / 2, location[1] - this.height - 15);
    }

    public void showPublish() {
        int[] location = new int[2];
        this.view.getLocationInWindow(location);
        this.popupwindow.setAnimationStyle(R.style.popWindow_animation);
        this.popupwindow.showAtLocation(this.view, 48, location[0] - this.width * 5 / 4 + this.getDensityValue(12, this.context), location[1] - this.height - 15);
    }

    public void show(int x, int y) {
        int[] location = new int[2];
        this.view.getLocationInWindow(location);
        this.popupwindow.setAnimationStyle(R.style.popWindow_animation);
        this.popupwindow.showAtLocation(this.view, 48, x, y);
    }

    public void show(int y) {
        int[] location = new int[2];
        this.view.getLocationInWindow(location);
        this.popupwindow.setAnimationStyle(R.style.popWindow_animation);
        this.popupwindow.showAtLocation(this.view, 48, location[0] - this.width * 3 / 2, y);
    }

    public void showOnViewBottom() {
        int[] location = new int[2];
        this.view.getLocationInWindow(location);
        this.popupwindow.setAnimationStyle(R.style.popWindow_animation1);
        if (location[1] > 320 * this.density) {
            this.popupwindow.showAsDropDown(this.view, location[0] - this.width * 3 / 2, -this.height - 16 * this.density);
        } else {
            this.popupwindow.showAsDropDown(this.view, location[0] - this.width * 3 / 2, 0);
        }
        this.popupwindow.update();
    }

    class ClickTextView
    implements View.OnClickListener {
        int position;
        LinearLayout linearLayout;

        public ClickTextView(int position, LinearLayout linearLayout) {
            this.position = position;
            this.linearLayout = linearLayout;
        }

        public void onClick(View v) {
            int childCount = this.linearLayout.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View view = this.linearLayout.getChildAt(i);
                if (!(view instanceof TextView)) continue;
                ((TextView)view).setTextColor(CommonDropDownView.this.context.getResources().getColor(R.color.color_white));
            }
            TextView textView = (TextView)v;
            textView.setTextColor(CommonDropDownView.this.selectColor);
            CommonDropDownView.this.handler.sendEmptyMessage(this.position);
            CommonDropDownView.this.dismiss();
        }
    }
}

