/*
 * Decompiled with CFR 0.152.
 */
package com.zhxh.xchartlib;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.zhxh.xchartlib.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StockCandleChart
extends View
implements GestureDetector.OnGestureListener {
    private PointF pOrigin;
    private PointF pRight;
    private PointF pTop;
    private Bitmap bitmapD;
    private Bitmap bitmapDD;
    private Bitmap bitmapK;
    private Bitmap bitmapAdd;
    private float yHeightPerValue;
    private float canvasWight;
    private float canvasHeight;
    private float density;
    private Map<String, KLItemData> dataMap1;
    private List<Float> yList;
    private List<String> xList;
    private List<KLItemData> dataList1;
    private int dataNum;
    private int yNum;
    private Paint paintTextGrey;
    private Paint paintLineCandle;
    private Paint paintLineGrey;
    private Paint paintArea;
    private float minY;
    private float maxY;
    private static final int intervals = 87;
    private float xOffset;
    private float xDayOffset;
    private int xDayNum;
    private Canvas canvas;
    private boolean isAnim;
    private boolean isShowArea;
    private List<String> colorList;
    int lineType;
    private int currentTouchPos = 0;
    private boolean isShowCursor = false;
    private Paint mPaint = new Paint();
    private float currentCursorX = 0.0f;
    boolean isShowLastLine = false;
    boolean isFirstOpen = false;
    private int currentTouchStopIndex = -1;
    List<Integer> dkIndexList = new ArrayList<Integer>();
    boolean isShowLock;
    GestureDetector detector;
    DisplayMetrics displayMetrics;
    private int progress = 0;
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            if (StockCandleChart.this.progress == StockCandleChart.this.dataNum) {
                return;
            }
            StockCandleChart.this.progress++;
            StockCandleChart.this.invalidate();
        }
    };

    public StockCandleChart(Builder builder) {
        super(builder.context);
        this.detector = new GestureDetector(builder.context, (GestureDetector.OnGestureListener)this);
        this.lineType = builder.lineType;
        this.isShowLock = builder.bottomStatus == 1 || builder.bottomStatus == 3;
        this.displayMetrics = builder.context.getResources().getDisplayMetrics();
        this.density = this.displayMetrics.density;
        this.canvasWight = (float)this.displayMetrics.widthPixels - 30.0f * this.density;
        this.canvasHeight = this.density * 160.0f;
        this.paintTextGrey = new Paint();
        this.paintTextGrey.setAntiAlias(true);
        this.paintTextGrey.setColor(-7829368);
        this.paintTextGrey.setStrokeWidth(2.0f * this.density);
        this.paintTextGrey.setTextSize(10.0f * this.density);
        this.paintLineCandle = new Paint();
        this.paintLineCandle.setAntiAlias(true);
        this.paintLineCandle.setColor(-65536);
        this.paintLineCandle.setStrokeWidth(1.0f * this.density);
        this.paintLineGrey = new Paint();
        this.paintLineGrey.setAntiAlias(true);
        this.paintLineGrey.setColor(Color.parseColor((String)"#dfdfdf"));
        this.paintLineGrey.setStrokeWidth(0.5f * this.density);
        this.paintLineGrey.setPathEffect((PathEffect)new DashPathEffect(new float[]{10.0f, 5.0f}, 0.0f));
        this.paintLineGrey.setStyle(Paint.Style.STROKE);
        this.paintArea = new Paint();
        this.paintArea.setAntiAlias(true);
        this.pOrigin = new PointF();
        this.pRight = new PointF();
        this.pTop = new PointF();
        if (this.lineType == 1) {
            this.pOrigin.set(33.0f * this.density, this.canvasHeight * 0.79f);
            this.pRight.set(this.canvasWight - 10.0f * this.density, this.canvasHeight * 0.79f);
            this.pTop.set(33.0f * this.density, this.canvasHeight * 0.1f);
        } else {
            this.pOrigin.set(43.0f * this.density, this.canvasHeight * 0.79f);
            this.pRight.set(this.canvasWight - 10.0f * this.density, this.canvasHeight * 0.79f);
            this.pTop.set(43.0f * this.density, this.canvasHeight * 0.1f);
        }
        this.setOnTouchListener((v, event) -> {
            if (this.lineType == 1) {
                this.isFirstOpen = false;
                if (event.getAction() == 0) {
                    this.isShowLastLine = false;
                    if (null != this.getParent()) {
                        this.getParent().requestDisallowInterceptTouchEvent(false);
                    }
                } else if (event.getAction() == 1) {
                    this.isShowLastLine = false;
                    if (null != this.getParent()) {
                        this.getParent().requestDisallowInterceptTouchEvent(false);
                    }
                }
            }
            return false;
        });
    }

    public boolean onDown(MotionEvent e) {
        this.cleanCursor();
        this.getParent().requestDisallowInterceptTouchEvent(false);
        return true;
    }

    public void onShowPress(MotionEvent e) {
        this.cleanCursor();
        this.getParent().requestDisallowInterceptTouchEvent(false);
    }

    public boolean onSingleTapUp(MotionEvent e) {
        this.getParent().requestDisallowInterceptTouchEvent(true);
        this.currentTouchPos = this.getCurrentTouchPosByCoordinate(e.getX());
        if (this.currentTouchPos <= this.dataList1.size() - 1 && this.currentTouchPos >= 0) {
            this.isShowCursor = true;
            this.drawCursor(e.getX());
        }
        if (this.currentTouchPos > this.dataList1.size() - 1) {
            this.currentTouchPos = this.dataList1.size() - 1;
        }
        if (1 == e.getAction() || 3 == e.getAction()) {
            this.cleanCursor();
            this.getParent().requestDisallowInterceptTouchEvent(false);
        }
        return false;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        this.getParent().requestDisallowInterceptTouchEvent(true);
        this.currentTouchPos = this.getCurrentTouchPosByCoordinate(e2.getX());
        if (this.currentTouchPos <= this.dataList1.size() - 1 && this.currentTouchPos >= 0) {
            this.isShowCursor = true;
            this.drawCursor(e2.getX());
        }
        if (this.currentTouchPos > this.dataList1.size() - 1) {
            this.currentTouchPos = this.dataList1.size() - 1;
        }
        if (1 == e2.getAction() || 3 == e2.getAction()) {
            this.cleanCursor();
            this.getParent().requestDisallowInterceptTouchEvent(false);
        }
        return false;
    }

    public void onLongPress(MotionEvent e) {
        this.cleanCursor();
        this.getParent().requestDisallowInterceptTouchEvent(false);
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        return false;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        return super.dispatchTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.lineType != 1) {
            return super.onTouchEvent(event);
        }
        if (1 == event.getAction() || 3 == event.getAction()) {
            this.cleanCursor();
            this.getParent().requestDisallowInterceptTouchEvent(false);
            return true;
        }
        return this.detector.onTouchEvent(event);
    }

    private int getCurrentTouchPosByCoordinate(float x) {
        int index = (int)((x - this.pOrigin.x) / this.xOffset);
        return index;
    }

    private void drawCursor(float x) {
        this.currentCursorX = x;
        this.invalidate();
    }

    private void cleanCursor() {
        this.currentTouchPos = -1;
        this.isShowCursor = false;
        this.invalidate();
    }

    public void setViewData(List<KLItemData> dateList1, boolean isAnim, boolean isShowArea, List<String> colorList) {
        int i;
        if (dateList1 == null) {
            dateList1 = new ArrayList<KLItemData>();
        }
        if (colorList == null) {
            colorList = new ArrayList<String>();
        }
        this.isAnim = isAnim;
        this.isShowArea = isShowArea;
        this.dataList1 = dateList1;
        this.colorList = colorList;
        this.dataNum = dateList1.size();
        this.xOffset = (this.pRight.x - this.pOrigin.x) / (float)this.dataNum;
        if (this.dataNum == 0) {
            return;
        }
        this.dataMap1 = new HashMap<String, KLItemData>();
        this.yList = new ArrayList<Float>();
        this.xList = new ArrayList<String>();
        for (i = 0; i < dateList1.size(); ++i) {
            this.dataMap1.put(dateList1.get(i).getTimes(), dateList1.get(i));
            dateList1.get(i).setIndex(i);
            if (dateList1.get(i).getSignFlag() != 2 && dateList1.get(i).getSignFlag() != 1 && dateList1.get(i).getSignFlag() != -1) continue;
            this.dkIndexList.add(i);
        }
        this.yNum = 5;
        this.minY = this.getMinValue(dateList1) * 0.9f;
        this.maxY = this.getMaxValue(dateList1) * 1.1f;
        this.yHeightPerValue = (this.pOrigin.y - this.pTop.y) / (this.maxY - this.minY);
        for (i = 0; i < this.yNum; ++i) {
            this.yList.add(Float.valueOf(this.minY + (float)i * (this.maxY - this.minY) / (float)(this.yNum - 1)));
        }
        this.xList.add(dateList1.get(this.dataNum - 1).getTimes().substring(0, 4) + "/" + dateList1.get(this.dataNum - 1).getTimes().substring(4, 6) + "/" + dateList1.get(this.dataNum - 1).getTimes().substring(6, 8));
        this.xList.add(dateList1.get((this.dataNum - 1) / 2).getTimes().substring(0, 4) + "/" + dateList1.get((this.dataNum - 1) / 2).getTimes().substring(4, 6) + "/" + dateList1.get((this.dataNum - 1) / 2).getTimes().substring(6, 8));
        this.xList.add(dateList1.get(0).getTimes().substring(0, 4) + "/" + dateList1.get(0).getTimes().substring(4, 6) + "/" + dateList1.get(0).getTimes().substring(6, 8));
        this.xDayNum = this.xList.size();
        this.bitmapD = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.ic_flag_d);
        this.bitmapDD = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.ic_flag_d);
        this.bitmapK = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.ic_flag_k);
        this.bitmapAdd = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.ic_flag_add);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        int i;
        if (this.dataNum == 0) {
            return;
        }
        this.canvas = canvas;
        if (this.isShowArea) {
            ArrayList<String> typeList = new ArrayList<String>();
            ArrayList<KLItemData> areaIndexList = new ArrayList<KLItemData>();
            for (i = 0; i < this.dataNum; ++i) {
                if (TextUtils.isEmpty((CharSequence)this.dataList1.get(i).getAreaType()) || this.isInList(typeList, this.dataList1.get(i).getAreaType())) continue;
                typeList.add(this.dataList1.get(i).getAreaType());
            }
            for (i = 0; i < typeList.size(); ++i) {
                int sum = 0;
                int startI = 0;
                String areaType = "";
                int signFlag = 0;
                KLItemData item = new KLItemData();
                for (int j = 0; j < this.dataNum; ++j) {
                    if (!((String)typeList.get(i)).equals(this.dataList1.get(j).getAreaType())) continue;
                    ++sum;
                    if (startI == 0) {
                        startI = j;
                    }
                    if (0 != this.dataList1.get(j).getSignFlag()) {
                        signFlag = this.dataList1.get(j).getSignFlag();
                    }
                    areaType = (String)typeList.get(i);
                }
                item.setSignFlag(signFlag);
                item.setAreaType(areaType);
                item.setStartI(startI);
                item.setLengthI(sum);
                areaIndexList.add(item);
            }
            for (i = 0; i < areaIndexList.size(); ++i) {
                String showArea = ((KLItemData)areaIndexList.get(i)).getAreaType().replace("\u533a\u95f4", "");
                if (1 == ((KLItemData)areaIndexList.get(i)).getSignFlag()) {
                    this.paintArea.setColor(Color.parseColor((String)"#ffe4e4"));
                } else if (-1 == ((KLItemData)areaIndexList.get(i)).getSignFlag()) {
                    this.paintArea.setColor(Color.parseColor((String)"#ddf3e4"));
                } else {
                    this.paintArea.setColor(Color.parseColor((String)"#ddf3e4"));
                }
                if (areaIndexList.size() >= this.colorList.size()) {
                    if ("D".equals(this.colorList.get(i))) {
                        this.paintArea.setColor(Color.parseColor((String)"#ffe4e4"));
                    } else if ("K".equals(this.colorList.get(i))) {
                        this.paintArea.setColor(Color.parseColor((String)"#ddf3e4"));
                    } else {
                        this.paintArea.setColor(Color.parseColor((String)"#ddf3e4"));
                    }
                }
                this.paintArea.setStrokeWidth((float)((KLItemData)areaIndexList.get(i)).getLengthI() * this.xOffset + 2.0f * this.density);
                canvas.drawRect(this.pOrigin.x + (float)((KLItemData)areaIndexList.get(i)).getStartI() * this.xOffset, this.pTop.y, this.pOrigin.x + (float)(((KLItemData)areaIndexList.get(i)).getStartI() + ((KLItemData)areaIndexList.get(i)).getLengthI()) * this.xOffset, this.pOrigin.y, this.paintArea);
                canvas.drawText(showArea, this.pOrigin.x + (float)(((KLItemData)areaIndexList.get(i)).getStartI() + ((KLItemData)areaIndexList.get(i)).getLengthI() / 2) * this.xOffset - 3.0f * this.density, this.pOrigin.y + 12.0f * this.density, this.paintTextGrey);
            }
        }
        float yOffset = (this.pOrigin.y - this.pTop.y) / (float)(this.yNum - 1);
        Path path = new Path();
        for (i = 0; i < this.yNum; ++i) {
            path.reset();
            path.moveTo(this.pOrigin.x, this.pOrigin.y - (float)i * yOffset);
            path.lineTo(this.pRight.x, this.pRight.y - (float)i * yOffset);
            canvas.drawPath(path, this.paintLineGrey);
            canvas.drawText(String.format("%.2f", Float.valueOf(this.yList.get(i).floatValue() / 100.0f)), this.pOrigin.x - 33.0f * this.density, this.pOrigin.y - (float)i * yOffset + 3.0f * this.density, this.paintTextGrey);
        }
        this.xDayOffset = (this.pRight.x - this.pOrigin.x) / 3.0f - 5.0f * this.density;
        for (i = 0; i < this.xDayNum; ++i) {
            String strData = this.xList.get(this.xDayNum - 1 - i);
            if (i == 2) {
                canvas.drawText(strData, this.pRight.x - this.paintTextGrey.measureText(strData), this.pOrigin.y + 33.0f * this.density, this.paintTextGrey);
                path.reset();
                path.moveTo(this.pRight.x, this.pOrigin.y);
                path.lineTo(this.pRight.x, this.pTop.y);
                continue;
            }
            if (i == 1) {
                canvas.drawText(strData, (this.pOrigin.x + this.pRight.x) / 2.0f - this.paintTextGrey.measureText(strData) / 2.0f, this.pOrigin.y + 33.0f * this.density, this.paintTextGrey);
                path.reset();
                path.moveTo((this.pOrigin.x + this.pRight.x) / 2.0f, this.pOrigin.y);
                path.lineTo((this.pOrigin.x + this.pRight.x) / 2.0f, this.pTop.y);
                canvas.drawPath(path, this.paintLineGrey);
                continue;
            }
            if (i != 0) continue;
            canvas.drawText(strData, this.pOrigin.x, this.pOrigin.y + 33.0f * this.density, this.paintTextGrey);
            path.reset();
            path.moveTo(this.pOrigin.x, this.pOrigin.y);
            path.lineTo(this.pOrigin.x, this.pTop.y);
        }
        if (this.isAnim) {
            for (i = 0; i < this.progress; ++i) {
                this.drawItemData(this.dataMap1, this.dataList1, i, this.paintLineCandle);
            }
            this.getHandler().postDelayed(this.runnable, 87L);
        } else {
            for (i = 0; i < this.dataNum; ++i) {
                this.drawItemData(this.dataMap1, this.dataList1, i, this.paintLineCandle);
            }
        }
        if (this.isShowCursor) {
            KLItemData currentStock = this.currentTouchPos <= this.dataList1.size() - 1 ? this.dataList1.get(this.currentTouchPos) : this.dataList1.get(this.dataList1.size() - 1);
            this.currentTouchStopIndex = this.indexFromCursor(currentStock.getIndex());
            this.drawCursorText(this.pOrigin.x + (float)this.currentTouchStopIndex * this.xOffset, this.dataList1.get(this.currentTouchStopIndex));
        }
    }

    private int indexFromCursor(int dataIndex) {
        int index = this.dkIndexList.get(0);
        int minDiffValue = Integer.MAX_VALUE;
        for (int i = 0; i < this.dkIndexList.size(); ++i) {
            if (Math.abs(this.dkIndexList.get(i) - dataIndex) >= minDiffValue) continue;
            minDiffValue = Math.abs(this.dkIndexList.get(i) - dataIndex);
            index = this.dkIndexList.get(i);
        }
        return index;
    }

    private void drawCursorText(float currentCursorX, KLItemData currentStock) {
        if (this.isShowLock && this.dataList1.size() >= 10 && currentStock.getIndex() > this.dataList1.size() - 10) {
            return;
        }
        Path path = new Path();
        this.mPaint.setStrokeWidth(1.0f * this.density);
        this.mPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{10.0f, 5.0f}, 0.0f));
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(-7759963);
        float lineCursorX = currentCursorX;
        if (lineCursorX < this.pOrigin.x) {
            lineCursorX = this.pOrigin.x;
        } else if (lineCursorX > this.pRight.x) {
            lineCursorX = this.pRight.x;
        }
        path.reset();
        path.moveTo(lineCursorX, this.getDataYvalue(this.maxY));
        path.lineTo(lineCursorX + 1.0f, this.getDataYvalue(this.minY));
        this.canvas.drawPath(path, this.mPaint);
        this.mPaint.reset();
        this.mPaint.setColor(-12219147);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextSize(9.0f * this.density);
        this.mPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        String timeStr = currentStock.getTimes().replace(" 00:00", "");
        String priceStr = String.format("%.2f", Float.valueOf(Float.parseFloat(currentStock.getNowv()) / 100.0f));
        String text = timeStr + " \u6536\u76d8\u4ef7" + priceStr;
        float textCursorX = currentCursorX - this.mPaint.measureText(text) / 2.0f;
        if (textCursorX < this.pOrigin.x) {
            textCursorX = this.pOrigin.x;
        } else if (textCursorX > this.pRight.x - this.mPaint.measureText(text)) {
            textCursorX = this.pRight.x - this.mPaint.measureText(text);
        }
        this.canvas.drawText(text, textCursorX, 9.0f * this.density, this.mPaint);
    }

    private float getDataYvalue(float dateProfit) {
        float yValue = this.pOrigin.y - this.yHeightPerValue * (dateProfit - this.minY);
        return yValue;
    }

    public float getMaxValue(List<KLItemData> dataList) {
        float maxValue = Float.parseFloat(dataList.get(0).getHighp());
        for (KLItemData data : dataList) {
            if (!(Float.parseFloat(data.getHighp()) >= maxValue)) continue;
            maxValue = Float.parseFloat(data.getHighp());
        }
        return maxValue;
    }

    public float getMinValue(List<KLItemData> dataList) {
        float minValue = Float.parseFloat(dataList.get(0).getLowp());
        for (KLItemData data : dataList) {
            if (!(Float.parseFloat(data.getLowp()) <= minValue)) continue;
            minValue = Float.parseFloat(data.getLowp());
        }
        return minValue;
    }

    private void drawItemData(Map<String, KLItemData> dataMap, List<KLItemData> dataList, int i, Paint paintLine) {
        if (this.pOrigin.x + (float)i * this.xOffset > this.pRight.x) {
            return;
        }
        if (Float.parseFloat(dataList.get(i).getOpenp()) < Float.parseFloat(dataList.get(i).getNowv())) {
            paintLine.setColor(-45999);
        } else if (Float.parseFloat(dataList.get(i).getOpenp()) > Float.parseFloat(dataList.get(i).getNowv())) {
            paintLine.setColor(-14501007);
        } else if (Float.parseFloat(dataList.get(i).getOpenp()) == Float.parseFloat(dataList.get(i).getNowv()) && Float.parseFloat(dataList.get(i).getHighp()) == Float.parseFloat(dataList.get(i).getLowp()) && Float.parseFloat(dataList.get(i).getNowv()) > Float.parseFloat(dataList.get(i).getPreclose())) {
            paintLine.setColor(-45999);
        } else if (Float.parseFloat(dataList.get(i).getOpenp()) == Float.parseFloat(dataList.get(i).getNowv()) && Float.parseFloat(dataList.get(i).getHighp()) == Float.parseFloat(dataList.get(i).getLowp()) && Float.parseFloat(dataList.get(i).getNowv()) < Float.parseFloat(dataList.get(i).getPreclose())) {
            paintLine.setColor(-14501007);
        } else if (Float.parseFloat(dataList.get(i).getOpenp()) == Float.parseFloat(dataList.get(i).getNowv()) && Float.parseFloat(dataList.get(i).getHighp()) == Float.parseFloat(dataList.get(i).getLowp()) && Float.parseFloat(dataList.get(i).getNowv()) == Float.parseFloat(dataList.get(i).getPreclose())) {
            paintLine.setColor(-6710887);
        } else {
            paintLine.setColor(-45999);
        }
        paintLine.setStrokeWidth(0.5f * this.density);
        this.canvas.drawLine(this.pOrigin.x + (float)i * this.xOffset, this.getDataYvalue(Float.parseFloat(dataMap.get(dataList.get(i).getTimes()).getHighp())), this.pOrigin.x + (float)i * this.xOffset, this.getDataYvalue(Float.parseFloat(dataMap.get(dataList.get(i).getTimes()).getLowp())), paintLine);
        paintLine.setStrokeWidth(2.0f * this.density);
        this.canvas.drawLine(this.pOrigin.x + (float)i * this.xOffset, this.getDataYvalue(Float.parseFloat(dataMap.get(dataList.get(i).getTimes()).getOpenp())), this.pOrigin.x + (float)i * this.xOffset, this.getDataYvalue(Float.parseFloat(dataMap.get(dataList.get(i).getTimes()).getNowv()) + 0.5f * this.density), paintLine);
        if (this.isShowLock && dataList.size() >= 10 && i > dataList.size() - 10) {
            if (this.currentTouchStopIndex == i && this.isShowLastLine) {
                this.drawCursorText(this.pOrigin.x + (float)i * this.xOffset, dataList.get(i));
            }
            return;
        }
        if (-1 == dataList.get(i).getSignFlag()) {
            this.canvas.drawBitmap(this.bitmapK, this.pOrigin.x + (float)i * this.xOffset - (float)(this.bitmapK.getWidth() / 2) + 0.5f * this.density, this.getDataYvalue(Float.parseFloat(dataMap.get(dataList.get(i).getTimes()).getHighp())) - (float)(this.bitmapK.getHeight() / 2) - (float)(this.bitmapK.getHeight() / 2) - 3.0f * this.density, paintLine);
        } else if (1 == dataList.get(i).getSignFlag()) {
            if (dataList.get(i).isResistance()) {
                if (this.isFirstOpen) {
                    this.currentTouchStopIndex = i;
                }
                this.canvas.drawBitmap(this.bitmapDD, this.pOrigin.x + (float)i * this.xOffset - (float)(this.bitmapDD.getWidth() / 2) + 0.5f * this.density, this.getDataYvalue(Float.parseFloat(dataMap.get(dataList.get(i).getTimes()).getLowp())) + (float)(this.bitmapDD.getHeight() / 2) - 3.0f * this.density, paintLine);
            } else {
                this.canvas.drawBitmap(this.bitmapD, this.pOrigin.x + (float)i * this.xOffset - (float)(this.bitmapD.getWidth() / 2) + 0.5f * this.density, this.getDataYvalue(Float.parseFloat(dataMap.get(dataList.get(i).getTimes()).getLowp())) + (float)(this.bitmapK.getHeight() / 2) - 3.0f * this.density, paintLine);
            }
        } else if (2 == dataList.get(i).getSignFlag()) {
            if (this.isFirstOpen) {
                this.currentTouchStopIndex = i;
            }
            this.canvas.drawBitmap(this.bitmapAdd, this.pOrigin.x + (float)i * this.xOffset - (float)(this.bitmapAdd.getWidth() / 2) + 0.5f * this.density, this.getDataYvalue(Float.parseFloat(dataMap.get(dataList.get(i).getTimes()).getLowp())) + (float)(this.bitmapAdd.getHeight() / 2) - 6.0f * this.density, paintLine);
        }
        if (this.currentTouchStopIndex == i && this.isShowLastLine) {
            this.drawCursorText(this.pOrigin.x + (float)i * this.xOffset, dataList.get(i));
        }
    }

    boolean isInList(List<String> list, String item) {
        for (String data : list) {
            if (!data.equals(item)) continue;
            return true;
        }
        return false;
    }

    private class KLItemData {
        private String times;
        private String highp;
        private String openp;
        private String breakp;
        private String reversep;
        private String lowp;
        private String nowv;
        private String preclose;
        private String curvol;
        private String curvalue;
        private String signType;
        private String date;
        private String price;
        private String wPointP;
        private String channelPointP;
        private int signFlag;
        private String areaType;
        private String type;
        private int resistancePrice;
        private boolean isResistance;
        private String dkWarnType;
        private int index;
        private int startI;
        private int lengthI;

        private KLItemData() {
        }

        public String getChannelPointP() {
            return this.channelPointP;
        }

        public void setChannelPointP(String channelPointP) {
            this.channelPointP = channelPointP;
        }

        public String getReversep() {
            return this.reversep;
        }

        public void setReversep(String reversep) {
            this.reversep = reversep;
        }

        public String getwPointP() {
            return this.wPointP;
        }

        public void setwPointP(String wPointP) {
            this.wPointP = wPointP;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getPrice() {
            return this.price;
        }

        public void setPrice(String price) {
            this.price = price;
        }

        public String getBreakp() {
            return this.breakp;
        }

        public void setBreakp(String breakp) {
            this.breakp = breakp;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getDkWarnType() {
            return this.dkWarnType;
        }

        public void setDkWarnType(String dkWarnType) {
            this.dkWarnType = dkWarnType;
        }

        public int getResistancePrice() {
            return this.resistancePrice;
        }

        public void setResistancePrice(int resistancePrice) {
            this.resistancePrice = resistancePrice;
        }

        public boolean isResistance() {
            return this.isResistance;
        }

        public void setResistance(boolean resistance) {
            this.isResistance = resistance;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getLengthI() {
            return this.lengthI;
        }

        public void setLengthI(int lengthI) {
            this.lengthI = lengthI;
        }

        public int getStartI() {
            return this.startI;
        }

        public void setStartI(int startI) {
            this.startI = startI;
        }

        public int getSignFlag() {
            return this.signFlag;
        }

        public void setSignFlag(int signFlag) {
            this.signFlag = signFlag;
        }

        public String getAreaType() {
            return this.areaType;
        }

        public void setAreaType(String areaType) {
            this.areaType = areaType;
        }

        public String getTimes() {
            return this.times;
        }

        public void setTimes(String times) {
            this.times = times;
        }

        public String getHighp() {
            return this.highp;
        }

        public void setHighp(String highp) {
            this.highp = highp;
        }

        public String getOpenp() {
            return this.openp;
        }

        public void setOpenp(String openp) {
            this.openp = openp;
        }

        public String getLowp() {
            return this.lowp;
        }

        public void setLowp(String lowp) {
            this.lowp = lowp;
        }

        public String getNowv() {
            return this.nowv;
        }

        public void setNowv(String nowv) {
            this.nowv = nowv;
        }

        public String getPreclose() {
            return this.preclose;
        }

        public void setPreclose(String preclose) {
            this.preclose = preclose;
        }

        public String getCurvol() {
            return this.curvol;
        }

        public void setCurvol(String curvol) {
            this.curvol = curvol;
        }

        public String getCurvalue() {
            return this.curvalue;
        }

        public void setCurvalue(String curvalue) {
            this.curvalue = curvalue;
        }

        public String getSignType() {
            return this.signType;
        }

        public void setSignType(String signType) {
            this.signType = signType;
        }
    }

    public static class Builder {
        Context context;
        int lineType;
        int bottomStatus;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder lineType(int lineType) {
            this.lineType = lineType;
            return this;
        }

        public Builder bottomStatus(int bottomStatus) {
            this.bottomStatus = bottomStatus;
            return this;
        }

        public StockCandleChart build() {
            return new StockCandleChart(this);
        }
    }
}

