/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.stat;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.zhuge.analysis.stat.ZhugeSDK;
import com.zhuge.analysis.sys_svs.AccountInfoUtils;
import com.zhuge.analysis.sys_svs.ConnectivityUtils;
import com.zhuge.analysis.sys_svs.DeviceInfoUtils;
import com.zhuge.analysis.sys_svs.ManifestUtils;
import com.zhuge.analysis.sys_svs.PackageInfosUtils;
import com.zhuge.analysis.sys_svs.TelephonyUtils;
import com.zhuge.analysis.sys_svs.WifiInfoUtils;
import com.zhuge.analysis.util_svs.EventStore;
import com.zhuge.analysis.util_svs.UpdateOnlineConfig;
import com.zhuge.analysis.util_svs.ZGJSONObject;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public class ZhugeConfig {
    public static final String SDK_V = "v1.2";
    public static final String TAG = "ZhugeSDK";
    public static final String CUID_KEY = "cuid";
    private String did = null;
    private String imei = null;
    private String mac = null;
    private String appkey = "";
    private String channel = "";
    private String appName = "";
    private String appVersion = "";
    private String cr = "";
    private int net = -100;
    private int mnet = -100;
    private int read_timeout = 30000;
    private int upload_per_day = 500;
    private int connect_timeout = 30000;
    private int period_time = 10;
    private int localMax = 5;
    private boolean debug = false;
    private boolean disable_upload = false;
    private int session_exceed = 30;
    private boolean disable_accounts = false;
    private boolean disable_phonenum = false;
    private boolean disable_applist = false;
    private ExecutorService executor_;
    private EventStore eventStore;
    private long session_time;
    private String base_config_key;
    private SharedPreferences zhugeSettings;

    private synchronized void ensureExecutor() {
        if (this.executor_ == null) {
            this.executor_ = Executors.newSingleThreadExecutor();
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private void setDisableUpload(boolean disable_upload) {
        this.disable_upload = disable_upload;
    }

    public int getSessionExceed() {
        return this.session_exceed;
    }

    private void setSessionExceed(int session_exceed) {
        this.session_exceed = session_exceed;
    }

    public boolean isDisableAccounts() {
        return this.disable_accounts;
    }

    public void setDisableAccounts(boolean disable_accounts) {
        this.disable_accounts = disable_accounts;
    }

    private boolean isDisableApplist() {
        return this.disable_applist;
    }

    private void setDisableApplist(boolean disable_applist) {
        this.disable_applist = disable_applist;
    }

    public int getConnectTimeout() {
        return this.connect_timeout;
    }

    public int getReadTimeout() {
        return this.read_timeout;
    }

    public String getDid() {
        return this.did;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getAppkey() {
        return this.appkey;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getSessionTime() {
        return new DecimalFormat("0.000").format((double)this.session_time / 1000.0);
    }

    private void setSessionTime(long session_time) {
        this.session_time = session_time;
    }

    public void setChannel(String channel) {
        if (this.channel.equals("") && !channel.equals("")) {
            this.channel = channel;
        } else {
            this.debug("\u6e20\u9053\u540d\u5df2\u7ecf\u8bbe\u7f6e\u6216\u4e3a\u7a7a");
        }
    }

    public void setAppkey(String appkey) {
        if (this.appkey.equals("") && !appkey.equals("")) {
            this.appkey = appkey;
            this.base_config_key = appkey;
        } else {
            this.debug("appkey\u5df2\u7ecf\u8bbe\u7f6e\u6216\u4e3a\u7a7a");
        }
    }

    private void setConnectTimeout(int connect_timeout) {
        this.connect_timeout = connect_timeout;
    }

    private void setReadTimeout(int read_timeout) {
        this.read_timeout = read_timeout;
    }

    public void setDisablePhonenum(boolean disable_phonenum) {
        this.disable_phonenum = disable_phonenum;
    }

    private SharedPreferences getZhugeSettings() {
        return this.zhugeSettings;
    }

    public boolean isDisablePhonenum() {
        return this.disable_phonenum;
    }

    public int getNet() {
        return this.net;
    }

    public int getPeriodTime() {
        return this.period_time;
    }

    private void setPeriodTime(int period_time) {
        this.period_time = period_time;
    }

    public int getLocalMax() {
        return this.localMax;
    }

    private void setLocalMax(int localMax) {
        this.localMax = localMax;
    }

    public void initDeviceInfo(Context context) {
        try {
            String mac = null;
            String imei = null;
            try {
                TelephonyManager tm = new TelephonyUtils(context).getTM();
                imei = tm.getDeviceId();
                this.cr = tm.getSimOperator();
                this.mnet = tm.getNetworkType();
            }
            catch (Exception e) {
                this.debug("\u83b7\u53d6IMEI\u548c\u8fd0\u8425\u5546\u5931\u8d25\uff0c\u68c0\u67e5\u6743\u9650READ_PHONE_STATE");
            }
            try {
                mac = new WifiInfoUtils(context).getMacAddress();
            }
            catch (Exception e) {
                this.debug("\u83b7\u53d6MAC\u5931\u8d25\uff0c\u68c0\u67e5\u6743\u9650ACCESS_WIFI_STATE");
            }
            if (mac == null && imei == null) {
                return;
            }
            try {
                this.mac = mac;
                this.imei = imei;
                this.did = ZhugeConfig.md5(imei + mac);
            }
            catch (Exception e) {
                this.debug("\u8ba1\u7b97\u7528\u6237\u552f\u4e00ID\u5931\u8d25");
            }
            try {
                this.net = new ConnectivityUtils(context).getNetworkType();
            }
            catch (Exception e) {
                this.debug("\u83b7\u53d6\u7f51\u7edc\u7c7b\u578b\u5931\u8d25\uff0c\u68c0\u67e5\u6743\u9650ACCESS_NETWORK_STATE\uff0c\u6216\u8005\u7f51\u7edc\u8fde\u63a5\u72b6\u6001");
            }
            this.eventStore = new EventStore(context, this.base_config_key);
            this.zhugeSettings = context.getSharedPreferences(this.base_config_key, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.debug("\u521d\u59cb\u5316\u8bbe\u5907\u4fe1\u606f\u9519\u8bef");
        }
    }

    public void initDevinfo(Context context) {
        String[] devInfo = ManifestUtils.getDevInfo(context);
        this.setAppkey(devInfo[0]);
        this.channel = devInfo[1];
    }

    public void initAppinfo(Context context) {
        try {
            PackageInfo devInfo = ManifestUtils.getAppInfo(context);
            if (devInfo != null) {
                this.appName = devInfo.applicationInfo.loadLabel(context.getPackageManager()).toString();
                this.appVersion = devInfo.versionName;
            } else {
                this.debug("\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\u9519\u8bef");
            }
        }
        catch (Exception e) {
            this.debug("\u521d\u59cb\u5316\u5e94\u7528\u4fe1\u606f\u9519\u8bef");
        }
    }

    public void updateConfig(Context context) {
        try {
            String config_key = "upload";
            this.ensureExecutor();
            this.executor_.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        String config;
                        String save_key = "config_ts";
                        JSONObject config_info = null;
                        long info_ts = ZhugeConfig.this.getZhugeSettings().getLong("config_ts", -1L);
                        long now_t = System.currentTimeMillis();
                        if (info_ts == -1L || now_t / 86400000L - info_ts / 86400000L > 0L) {
                            config_info = UpdateOnlineConfig.getServerConfig();
                        }
                        if (config_info == null) {
                            config = ZhugeConfig.this.getZhugeSettings().getString("upload", null);
                        } else {
                            config = config_info.optString("config");
                            if (config != null) {
                                SharedPreferences.Editor editor = ZhugeConfig.this.getZhugeSettings().edit();
                                editor.putString("upload", config);
                                editor.putLong("config_ts", now_t);
                                editor.commit();
                            }
                        }
                        if (config != null) {
                            ZhugeConfig.this.setConfigInfo(config);
                        }
                        ZhugeConfig.this.debug(ZhugeConfig.this.getConfigInfo());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ZhugeConfig.this.debug("\u89e3\u6790\u914d\u7f6e\u51fa\u9519" + e.getMessage());
                    }
                }
            });
        }
        catch (Exception e) {
            this.debug("\u521d\u59cb\u7ebf\u7a0b\u8bf7\u6c42\u914d\u7f6e\u51fa\u9519");
        }
    }

    public static String md5(String string) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Huh, MD5 should be supported?", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Huh, UTF-8 should be supported?", e);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public String getInitDebugInfo(Context context) {
        StringBuilder info = new StringBuilder();
        info.append("appkey\uff1a" + this.appkey + "\n");
        info.append("\u6e20\u9053\u540d\u79f0\uff1a" + this.channel + "\n");
        info.append("\u5e94\u7528\u540d\u79f0\uff1a" + this.appName + "\n");
        info.append("\u5e94\u7528\u7248\u672c\uff1a" + this.appVersion + "\n");
        info.append("\u7528\u6237\u6807\u8bc6\uff1a" + this.did + "\n");
        info.append("\u8fd0\u8425\u5546\u4ee3\u53f7\uff1a" + this.cr + "\n");
        info.append("\u7f51\u7edc\u8fde\u63a5\u7c7b\u578b\uff1a" + this.net + "\n");
        info.append("\u79fb\u52a8\u7f51\u7edc\u7c7b\u578b\uff1a" + this.mnet + "\n");
        info.append("\u7cfb\u7edf\u7248\u672c\uff1a" + DeviceInfoUtils.getOSVersion() + "\n");
        info.append("\u624b\u673a\u578b\u53f7\uff1a" + DeviceInfoUtils.getDevice() + "\n");
        info.append("\u7cfb\u7edf\u5206\u8fa8\u7387\uff1a" + DeviceInfoUtils.getResolution(context) + "\n");
        return info.toString();
    }

    public String getConfigInfo() {
        StringBuilder info = new StringBuilder();
        info.append("\u7981\u6b62\u6536\u96c6\u8be5\u8bbe\u5907\uff1a" + this.disable_upload + "\n");
        info.append("\u7981\u6b62\u4e0a\u4f20\u5e94\u7528\u5217\u8868\uff1a" + this.disable_applist + "\n");
        info.append("\u7981\u7528\u8d26\u6237\u4e2d\u5fc3\uff1a" + this.disable_accounts + "\n");
        info.append("\u4f1a\u8bdd\u8d85\u671f\u65f6\u95f4\uff08\u79d2\uff09\uff1a" + this.session_exceed + "\n");
        return info.toString();
    }

    private void setConfigInfo(String config) {
        String[] configArray = config.split(":");
        boolean disableUpload = Boolean.valueOf(configArray[0]);
        String[] serviceDisabled = configArray[1].split("\\|");
        boolean disableApplist = Boolean.valueOf(serviceDisabled[0]);
        boolean disableAccounts = Boolean.valueOf(serviceDisabled[1]);
        boolean disablePhoneNum = Boolean.valueOf(serviceDisabled[2]);
        String[] uploadConfig = configArray[2].split("\\|");
        int uploadMethod = Integer.valueOf(uploadConfig[0]);
        int sessionExceed = Integer.valueOf(uploadConfig[1]);
        int localMax = Integer.valueOf(uploadConfig[3]);
        int connectTimeout = Integer.valueOf(uploadConfig[5]);
        int readTimeout = Integer.valueOf(uploadConfig[6]);
        int periodTime = Integer.valueOf(uploadConfig[7]);
        this.setDisableUpload(disableUpload);
        this.setDisableApplist(disableApplist);
        this.setDisableAccounts(disableAccounts);
        this.setDisablePhonenum(disablePhoneNum);
        this.setLocalMax(localMax);
        this.setSessionExceed(sessionExceed);
        this.setReadTimeout(readTimeout);
        this.setPeriodTime(periodTime);
        this.setConnectTimeout(connectTimeout);
    }

    private void initInfo(Context context) {
        try {
            String config_key = "info_ts";
            long info_ts = this.getZhugeSettings().getLong("info_ts", -1L);
            long now_t = System.currentTimeMillis();
            if (info_ts == -1L || now_t / 86400000L - info_ts / 86400000L > 7L) {
                ZGJSONObject infoObject = new ZGJSONObject();
                infoObject.put("et", "info");
                infoObject.put("an", this.getAppName());
                infoObject.put("vn", this.getAppVersion());
                infoObject.put("ov", DeviceInfoUtils.getOSVersion());
                infoObject.put("rs", DeviceInfoUtils.getResolution(context));
                infoObject.put("dv", DeviceInfoUtils.getDevice());
                infoObject.put("maker", DeviceInfoUtils.getManfacturer());
                infoObject.put("br", DeviceInfoUtils.getBrand());
                infoObject.put("cr", this.cr);
                infoObject.put("net", this.net);
                infoObject.put("imei", this.imei);
                infoObject.put("mac", this.mac);
                infoObject.put("cn", this.getChannel());
                infoObject.put("ts", new DecimalFormat("0.000").format(now_t / 1000L));
                infoObject.put("sid", this.getSessionTime());
                infoObject.put("mb", this.isDisablePhonenum() ? "" : new TelephonyUtils(context).getPhoneNumber());
                this.eventStore.addEvent(infoObject);
                this.getZhugeSettings().edit().putLong("info_ts", now_t).commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.debug("\u521d\u59cb\u5316\u4e8b\u4ef6\u51fa\u95193");
        }
    }

    private void initSession(Context context) {
        try {
            long now_t = System.currentTimeMillis();
            try {
                this.net = new ConnectivityUtils(context).getNetworkType();
            }
            catch (Exception e) {
                this.debug("\u83b7\u53d6\u7f51\u7edc\u7c7b\u578b\u5931\u8d25\uff0c\u68c0\u67e5\u6743\u9650ACCESS_NETWORK_STATE\uff0c\u6216\u8005\u7f51\u7edc\u8fde\u63a5\u72b6\u6001");
            }
            this.setSessionTime(now_t);
            ZGJSONObject infoObject = new ZGJSONObject();
            infoObject.put("et", "ss");
            infoObject.put("an", this.getAppName());
            infoObject.put("vn", this.getAppVersion());
            infoObject.put("ov", DeviceInfoUtils.getOSVersion());
            infoObject.put("cr", this.cr);
            infoObject.put("net", this.net);
            infoObject.put("mnet", this.mnet);
            infoObject.put("ts", new DecimalFormat("0.000").format(now_t / 1000L));
            infoObject.put("sid", this.getSessionTime());
            this.eventStore.addEvent(infoObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.debug("\u521d\u59cb\u5316\u4e8b\u4ef6\u51fa\u9519\u51fa\u95192");
        }
    }

    public void initEvent(final Context context) {
        if (this.eventStore.timerService_ == null) {
            this.eventStore.startUploadService(context);
        }
        this.completeLastSession(context);
        this.initSession(context);
        this.eventStore.send(true);
        this.ensureExecutor();
        this.executor_.submit(new Runnable(){

            @Override
            public void run() {
                ZhugeConfig.this.initInfo(context);
                if (!ZhugeConfig.this.isDisableAccounts()) {
                    ZhugeConfig.this.initAcs(context);
                }
                if (!ZhugeConfig.this.isDisableApplist()) {
                    ZhugeConfig.this.initPkgs(context);
                }
            }
        });
    }

    public void saveSessionEnd(long end_time) {
        this.getZhugeSettings().edit().putString("pre_end", this.session_time + "|" + end_time).commit();
    }

    public synchronized void completeLastSession(Context context) {
        try {
            String last_end = this.getZhugeSettings().getString("pre_end", "");
            if (last_end.equals("")) {
                return;
            }
            this.debug("last_end:" + last_end);
            String[] last_info = last_end.split("\\|");
            long sid = Long.valueOf(last_info[0]);
            long ts = Long.valueOf(last_info[1]);
            ZGJSONObject infoObject = new ZGJSONObject();
            infoObject.put("et", "se");
            infoObject.put("ts", new DecimalFormat("0.000").format((double)ts / 1000.0));
            infoObject.put("sid", new DecimalFormat("0.000").format((double)sid / 1000.0));
            infoObject.put("dr", new DecimalFormat("0.000").format((double)(ts - sid) / 1000.0));
            this.getZhugeSettings().edit().putString("pre_end", "").commit();
            this.eventStore.addEvent(infoObject);
            ZhugeSDK.getInstance().halt();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.debug("\u521d\u59cb\u5316\u4e8b\u4ef6\u51fa\u95191");
        }
    }

    public void onCustomEvent(Context context, String event_name, JSONObject kv) {
        try {
            long now_t = System.currentTimeMillis();
            ZGJSONObject infoObject = new ZGJSONObject();
            infoObject.put("et", "cus");
            infoObject.put("ts", new DecimalFormat("0.000").format((double)now_t / 1000.0));
            infoObject.put("eid", event_name);
            infoObject.put("pr", kv);
            infoObject.put("sid", this.getSessionTime());
            this.eventStore.addEvent(infoObject);
        }
        catch (Exception e) {
            this.debug("\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u51fa\u9519" + e.getMessage());
        }
    }

    public void channelData(String chan, String userId) {
        try {
            long now_t = System.currentTimeMillis();
            ZGJSONObject infoObject = new ZGJSONObject();
            infoObject.put("et", "3rdpush");
            infoObject.put("ts", new DecimalFormat("0.000").format((double)now_t / 1000.0));
            JSONObject ch = new JSONObject();
            ch.put("channel", (Object)chan);
            ch.put("user_id", (Object)userId);
            infoObject.put("pr", ch);
            String info = infoObject.toString();
            this.debug(info);
            this.eventStore.addEvent(infoObject);
        }
        catch (Exception e) {
            this.debug("\u6e20\u9053\u6570\u636e\u51fa\u9519" + e.getMessage());
        }
    }

    public void onCustomEvent(Context context, String event_name, HashMap<String, Object> kv) {
        try {
            long now_t = System.currentTimeMillis();
            ZGJSONObject infoObject = new ZGJSONObject();
            infoObject.put("et", "cus");
            infoObject.put("ts", new DecimalFormat("0.000").format((double)now_t / 1000.0));
            infoObject.put("eid", event_name);
            infoObject.put("pr", new JSONObject(kv));
            infoObject.put("sid", this.getSessionTime());
            this.eventStore.addEvent(infoObject);
        }
        catch (Exception e) {
            this.debug("\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u51fa\u9519" + e.getMessage());
        }
    }

    public void onCustomEvent(Context context, String event_name) {
        try {
            long now_t = System.currentTimeMillis();
            ZGJSONObject infoObject = new ZGJSONObject();
            infoObject.put("et", "cus");
            infoObject.put("ts", new DecimalFormat("0.000").format((double)now_t / 1000.0));
            infoObject.put("eid", event_name);
            infoObject.put("sid", this.getSessionTime());
            this.eventStore.addEvent(infoObject);
        }
        catch (Exception e) {
            this.debug("\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u51fa\u9519" + e.getMessage());
        }
    }

    public void identifyPerson(Context context, String uid, HashMap<String, Object> kv) {
        try {
            long now_t = System.currentTimeMillis();
            ZGJSONObject infoObject = new ZGJSONObject();
            infoObject.put("et", "idf");
            infoObject.put("ts", new DecimalFormat("0.000").format((double)now_t / 1000.0));
            infoObject.put(CUID_KEY, uid);
            infoObject.put("pr", new JSONObject(kv));
            infoObject.put("sid", this.getSessionTime());
            this.getZhugeSettings().edit().putString(CUID_KEY, uid).commit();
            this.eventStore.addEvent(infoObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.debug("\u6807\u8bc6\u7528\u6237\u51fa\u9519");
        }
    }

    public void identifyPerson(Context context, String uid, JSONObject kv) {
        try {
            long now_t = System.currentTimeMillis();
            ZGJSONObject infoObject = new ZGJSONObject();
            infoObject.put("et", "idf");
            infoObject.put("ts", new DecimalFormat("0.000").format((double)now_t / 1000.0));
            infoObject.put(CUID_KEY, uid);
            infoObject.put("pr", kv);
            infoObject.put("sid", this.getSessionTime());
            this.getZhugeSettings().edit().putString(CUID_KEY, uid).commit();
            this.eventStore.addEvent(infoObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.debug("\u6807\u8bc6\u7528\u6237\u51fa\u9519");
        }
    }

    private void initPkgs(Context context) {
        try {
            String config_key = "pkg_ts";
            long info_ts = this.getZhugeSettings().getLong("pkg_ts", -1L);
            long now_t = System.currentTimeMillis();
            if (info_ts == -1L || now_t / 86400000L - info_ts / 86400000L > 14L) {
                ZGJSONObject infoObject = new ZGJSONObject();
                infoObject.put("et", "pkgs");
                infoObject.put("list", new PackageInfosUtils(context).getUserAppInfos());
                infoObject.put("ts", new DecimalFormat("0.000").format((double)now_t / 1000.0));
                infoObject.put("sid", this.getSessionTime());
                this.eventStore.addEvent(infoObject);
                this.getZhugeSettings().edit().putLong("pkg_ts", now_t).commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.debug("\u521d\u59cb\u5316\u4e8b\u4ef6\u51fa\u95195");
        }
    }

    private void initAcs(Context context) {
        try {
            String config_key = "acs_ts";
            long info_ts = this.getZhugeSettings().getLong("acs_ts", -1L);
            long now_t = System.currentTimeMillis();
            if (info_ts == -1L || now_t / 86400000L - info_ts / 86400000L > 14L) {
                ZGJSONObject infoObject = new ZGJSONObject();
                infoObject.put("et", "acs");
                infoObject.put("list", new AccountInfoUtils(context).getAccountInfos());
                infoObject.put("ts", new DecimalFormat("0.000").format((double)now_t / 1000.0));
                infoObject.put("sid", this.getSessionTime());
                this.eventStore.addEvent(infoObject);
                this.getZhugeSettings().edit().putLong("acs_ts", now_t).commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.debug("\u521d\u59cb\u5316\u4e8b\u4ef6\u51fa\u95194\uff0c\u4f60\u5f00\u542f\u4e86\u8d26\u6237\u4e2d\u5fc3\uff0c\u6ca1\u6709\u6dfb\u52a0\u6743\u9650GET_ACCOUNTS");
        }
    }

    public void saveEvent(Context context, ZGJSONObject zhuge_event) {
        this.eventStore.addEvent(zhuge_event);
    }

    public void debug(String info) {
        if (this.debug) {
            Log.e((String)TAG, (String)info);
        }
    }

    public void sendData() {
        this.eventStore.send(true);
    }

    public int getUpload_per_day() {
        return this.upload_per_day;
    }

    public void setUpload_per_day(int upload_per_day) {
        this.upload_per_day = upload_per_day;
    }

    public boolean stopUpload() {
        return this.eventStore.stopTimeService();
    }
}

