package com.zhuge.analysis.stat;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.zhuge.analysis.util.AccountInfoUtils;
import com.zhuge.analysis.util.ActivityServicesUtils;
import com.zhuge.analysis.util.ConnectivityUtils;
import com.zhuge.analysis.util.DeviceInfoUtils;
import com.zhuge.analysis.util.ManifestUtils;
import com.zhuge.analysis.util.PackageInfosUtils;
import com.zhuge.analysis.util.TelephonyUtils;
import com.zhuge.analysis.util.Utils;
import com.zhuge.analysis.util.WifiInfoUtils;
import com.zhuge.analysis.util.ZGJSONObject;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;
import java.util.UUID;

/**
 * 诸葛统计配置信息
 * Created by jiaokang on 15/11/9.
 */
/*package*/ class ZhugeConfig {


    /*package*/ static final String SDK_V = "v2.3.0";
    private static final String TAG = "ZhugeSDK";
    private static final String CUID_KEY = "cuid";

    public static final String API_PATH = "https://apipool.zhugeio.com/APIPOOL/";

    /**
     * sharedPreference相关
     * 存放SDK全局变量文件名
     * 会话上次活动时间
     */
    private SharedPreferences globalSP;
    private static final String LAST_SESSION = "ZhugeLastSession";
    private static final String TOTALDAY_KEY = "Today_total";

    private final String config_info = "info_ts";
    private final String config_account = "acs_ts";
    private final String config_pkg = "pkg_ts";

    private final String did_string = "zhuge_did";

    /**
     * 实时调试 日志开关 禁止获取账户  禁止获取电话号码 禁止获取应用列表
     */
    /*package*/static boolean debug = false;
    /*package*/ boolean logEnable = false;

    private boolean disable_accounts = false;
    private boolean disable_phonenum = false;
    private boolean disable_applist = false;

    /**
     * 设备应用相关 did 用户唯一标识 appKey  channel 渠道
     */
    private String did = null;
    private String imei = null;
    private String mac = null;
    private String appkey = "";
    private String appChannel = "";
    private String appName = "";
    private String appVersion = "";

    /**
     * 会话相关 会话时长限制 会话上次活动时间 会话ID
     */

    private static final int session_exceed = 30;
    /*package*/ long preSessionEnd = -1;
    private long session_time;
    /**
     * 网络信息
     * cr    运营商代号
     * net   网络连接类型
     * mnet  移动网络类型
     */
    private String cr = "";
    private int net = -100;
    private int mnet = -100;


    static final int MSG_RECV = 0;
    static final int MSG_READ = 1;


    /**
     * 每日上传事件数
     */
    /*package*/ int getUpload_per_day() {
        return 500;
    }

    /*package*/ String getTotaldayKey() {
        return TOTALDAY_KEY;
    }

    /*package*/  String getConfig_Cuid() {
        return CUID_KEY;
    }

    /*package*/ String getConfig_pkg() {
        return config_pkg;
    }

    /*package*/ String getConfig_info() {
        return config_info;
    }

    /*package*/ String getConfig_account() {
        return config_account;
    }

    /**
     * 获取会话信息关键字
     */
    /*package*/ String getLastSession() {
        return LAST_SESSION;
    }

    /**
     * @return 存放全局信息的SharedPreferences
     */
    /*package*/ SharedPreferences getGlobalSP() {
        return globalSP;
    }

    /**
     * 获取会话ID
     */
    /*package*/ long getSessionTime() {
        return session_time;
    }


    /**
     * 上传间隔
     *
     * @return 数据上传间隔
     */

    /*package*/
    static short getPeriod_time() {
        if (debug) {
            return 1;
        } else {
            return 10;
        }
    }

    /*package*/ String getAppVersion() {
        return appVersion;
    }

    /*package*/ String getAppChannel() {
        return appChannel;
    }

    /*package*/ void setAppChannel(String appChannel) {
        this.appChannel = appChannel;
    }

    /*package*/ String getAppkey() {
        return appkey;
    }

    /*package*/ String getDid() {
        return did;
    }

    /*package*/ void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    /*package*/ void disableAccounts() {
        this.disable_accounts = true;
    }

    /*package*/ void disablePhonenum() {
        this.disable_phonenum = true;
    }

    /*package*/ void disableAppList() {
        this.disable_applist = true;
    }

    public void debug(String message) {
        if (logEnable) {
            Log.e(TAG, message);
        }
    }

    /*package*/ boolean checkSelf(String key, String channel) {
        long interval = Math.abs(System.currentTimeMillis() - preSessionEnd);
        debug("间隔时长：" + interval / 1000 + "\n" + "channel = " + channel);
        return interval / 1000 < session_exceed || key.equals("null") || channel.equals("null");
    }


    /*package*/ void initDevInfo(Context context) {
        String[] info = ManifestUtils.getDevInfo(context);
        setAppkey(info[0]);
        setAppChannel(info[1]);
    }

    /*package*/ void initGlobalSettingFile(Context context) {
        String myProcessName = new ActivityServicesUtils(context).getMyProcessName();
        String myGlobalSPName = myProcessName + appkey;
        globalSP = context.getSharedPreferences(myGlobalSPName, Context.MODE_PRIVATE);
    }

    /*package*/ void initDeviceInfo(Context context) {
        String imei = null;
        try {
            TelephonyManager tm = new TelephonyUtils(context).getTM();
            imei = tm.getDeviceId();
            this.cr = tm.getSimOperator();
            this.mnet = tm.getNetworkType();
        } catch (Exception e) {
            debug("获取IMEI和运营商失败，检查权限READ_PHONE_STATE");
        }
        try {
            this.net = new ConnectivityUtils(context).getNetworkType();
        } catch (Exception e) {
            debug("获取网络类型失败，检查权限ACCESS_NETWORK_STATE，或者网络连接状态");
        }

        try {
            String localDid = globalSP.getString(did_string,null);
            if (null != localDid ){
                String[] strings = localDid.split("\\|");
                this.did = strings[0];
                if (strings.length >2){
                    this.mac = strings[1];
                    this.imei = strings[2];
                }
                return;
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        String mac = null;
        try {
            mac = new WifiInfoUtils(context).getMacAddress();
        } catch (Exception e) {
            debug("获取MAC失败，检查权限ACCESS_WIFI_STATE");
        }
        try {
            this.mac = mac+"";
            this.imei = imei+"";
            this.did = generateDid();
            String deviceInfo = this.did+"|"+mac+"|"+imei;
            globalSP.edit().putString(did_string,deviceInfo).apply();
        } catch (Exception e) {
            debug("计算用户唯一ID失败");
        }
    }

    /*package*/ String generateDid(){
        long info_ts = globalSP.getLong(config_info, -1);
        String did ;
        if (info_ts == -1){
            did =  Utils.md5(imei+UUID.randomUUID().toString());
        }else {
            did = Utils.md5(imei+mac);
        }
        return did;
    }

//    /*package*/ void initDeviceInfo(Context context) {
//        String imei = null;
//        try {
//            TelephonyManager tm = new TelephonyUtils(context).getTM();
//            imei = tm.getDeviceId();
//            this.cr = tm.getSimOperator();
//            this.mnet = tm.getNetworkType();
//        } catch (Exception e) {
//            debug("获取IMEI和运营商失败，检查权限READ_PHONE_STATE");
//        }
//        try {
//            this.net = new ConnectivityUtils(context).getNetworkType();
//        } catch (Exception e) {
//            debug("获取网络类型失败，检查权限ACCESS_NETWORK_STATE，或者网络连接状态");
//        }
//
//        String localDid = globalSP.getString(did_string,null);
//        if (null != localDid ){
//            String[] strings = localDid.split("\\|");
//            this.did = strings[0];
//            if (strings.length >1){
//                this.mac = strings[1];
//                this.imei = strings[2];
//            }
//            return;
//        }
//        String mac = null;
//        try {
//            mac = new WifiInfoUtils(context).getMacAddress();
//        } catch (Exception e) {
//            debug("获取MAC失败，检查权限ACCESS_WIFI_STATE");
//        }
//        if (mac == null && imei == null)
//            return;
//        this.mac = mac;
//        this.imei = imei;
//        this.did = Utils.md5(imei + mac);
//        String deviceInfo = this.did+"|"+mac+"|"+imei;
//        globalSP.edit().putString(did_string,deviceInfo).apply();
//    }

    /*package*/ void initAppinfo(Context context) {
        try {
            PackageInfo devInfo = ManifestUtils.getAppInfo(context);
            if (devInfo != null) {
                this.appName = devInfo.applicationInfo.loadLabel(context.getPackageManager()).toString();
                this.appVersion = devInfo.versionName;
            } else {
                debug("获取应用信息错误");
            }
        } catch (Exception e) {
            debug("初始化应用信息错误");
        }
    }

    /*package*/ void debugInitInfo(Context context) {
        if (logEnable) {
            StringBuilder info = new StringBuilder();
            info.append("appKey：" + this.appkey + "\n");
            info.append("sdkVersion：" + this.SDK_V + "\n");
            info.append("实时调试：" + debug + "\n");
            info.append("禁止获取手机号：" + disable_phonenum + "\n");
            info.append("禁止获取应用列表：" + disable_applist + "\n");
            info.append("禁止获取用户账号信息：" + disable_accounts + "\n");
            info.append("渠道名称：" + this.appChannel + "\n");
            info.append("应用名称：" + this.appName + "\n");
            info.append("应用版本：" + this.appVersion + "\n");
            info.append("用户标识：" + this.did + "\n");
            info.append("运营商代号：" + this.cr + "\n");
            info.append("网络连接类型：" + this.net + "\n");
            info.append("移动网络类型：" + this.mnet + "\n");
            info.append("系统版本：" + DeviceInfoUtils.getOSVersion() + "\n");
            info.append("手机型号：" + DeviceInfoUtils.getDevice() + "\n");
            info.append("系统分辨率：" + DeviceInfoUtils.getResolution(context) + "\n");
            debug(info.toString());
        }
    }

    /*package*/ ZGJSONObject completeLastSession(int state, int eventCount) {
        String info = globalSP.getString(LAST_SESSION, "");
        if (info.equals("")) {
            return null;
        }
        String[] infos = info.split("\\|");
        long sid = Long.valueOf(infos[0]);
        long ts = Long.valueOf(infos[1]);
        ZGJSONObject infoObject = new ZGJSONObject();
        try {
            infoObject.put("et", "se");
            infoObject.put("sr", state);
            infoObject.put("ec", eventCount);
            infoObject.put("tz", "" + Utils.getTimeZone());
            infoObject.put("ts", Utils.formatTime(ts));
            infoObject.put("sid", Utils.formatTime(sid));
            infoObject.put("dr", Utils.formatTime(ts - sid));
        } catch (JSONException e) {
            debug("数据组装出错" + e.getMessage());
        }
        return infoObject;
    }

    /*package*/ ZGJSONObject startSession() {
        long now_t = System.currentTimeMillis();
        session_time = now_t;
        ZGJSONObject infoObject = new ZGJSONObject();
        try {
            infoObject.put("et", "ss");
            infoObject.put("an", appName);
            infoObject.put("vn", appVersion);
            infoObject.put("ov", DeviceInfoUtils.getOSVersion());
            infoObject.put("cr", cr);
            infoObject.put("net", net);
            infoObject.put("mnet", mnet);
            infoObject.put("tz", "" + Utils.getTimeZone());
            infoObject.put("ts", Utils.formatTime(now_t));
            infoObject.put("sid", Utils.formatTime(session_time));
        } catch (JSONException e) {
            debug("数据组装出错" + e.getMessage());
        }
        return infoObject;
    }

    /*package*/ ZGJSONObject initInfo(Context context) {
        ZGJSONObject infoObject = new ZGJSONObject();
        try {
            long info_ts = globalSP.getLong(config_info, -1);
            long now_t = System.currentTimeMillis();
            if (info_ts == -1 || (now_t / 86400000 - info_ts / 86400000) > 1) {
                infoObject.put("et", "info");
                infoObject.put("an", appName);
                infoObject.put("vn", appVersion);
                infoObject.put("ov", DeviceInfoUtils.getOSVersion());
                infoObject.put("rs", DeviceInfoUtils.getResolution(context));
                infoObject.put("dv", DeviceInfoUtils.getDevice());
                infoObject.put("maker", DeviceInfoUtils.getManfacturer());
                infoObject.put("br", DeviceInfoUtils.getBrand());
                infoObject.put("cr", this.cr);
                infoObject.put("net", this.net);
                infoObject.put("imei", this.imei);
                infoObject.put("mac", this.mac);
                infoObject.put("cn", appChannel);
                infoObject.put("tz", "" + Utils.getTimeZone());
                infoObject.put("ts", Utils.formatTime(now_t));
                infoObject.put("sid", Utils.formatTime(session_time));
                infoObject.put("mb", disable_phonenum ? "" : new TelephonyUtils(context).getPhoneNumber());
            } else {
                return null;
            }
        } catch (Exception e) {
            debug("初始化个人信息出错" + e.getMessage());
        }
        return infoObject;
    }

    /*package*/ ZGJSONObject initAcs(Context context) {
        if (disable_accounts) {
            return null;
        }
        ZGJSONObject infoObject;
        try {
            long info_ts = globalSP.getLong(config_account, -1);

            long now_t = System.currentTimeMillis();
            if (info_ts == -1 || (now_t / 86400000 - info_ts / 86400000) > 14) {
                infoObject = new ZGJSONObject();
                infoObject.put("et", "acs");
                infoObject.put("list", new AccountInfoUtils(context).getAccountInfos());
                infoObject.put("tz", "" + Utils.getTimeZone());
                infoObject.put("ts", Utils.formatTime(now_t));
                infoObject.put("sid", Utils.formatTime(session_time));
                return infoObject;
            }
        } catch (Exception e) {
            debug("没有添加权限GET_ACCOUNTS");
        }
        return null;
    }

    /*package*/ ZGJSONObject initApplist(Context context) {
        if (disable_applist) {
            return null;
        }
        try {
            long info_ts = globalSP.getLong(config_pkg, -1);

            long now_t = System.currentTimeMillis();
            if (info_ts == -1 || (now_t / 86400000 - info_ts / 86400000) > 14) {
                ZGJSONObject infoObject = new ZGJSONObject();
                infoObject.put("et", "pkgs");
                infoObject.put("list", new PackageInfosUtils(context).getUserAppInfos());
                infoObject.put("tz", "" + Utils.getTimeZone());
                infoObject.put("ts", Utils.formatTime(now_t));
                infoObject.put("sid", Utils.formatTime(session_time));
                return infoObject;
            }
        } catch (Exception e) {
            debug("获取应用列表出错。" + e.getMessage());
        }
        return null;
    }

    /*package*/ ZGJSONObject customEvent(String event_name, JSONObject kv) {
        long now_t = System.currentTimeMillis();
        ZGJSONObject infoObject = new ZGJSONObject();
        try {
            infoObject.put("et", "cus");
            infoObject.put("tz", "" + Utils.getTimeZone());
            infoObject.put("ts", Utils.formatTime(now_t));
            infoObject.put("eid", event_name);
            if (null != kv) {
                infoObject.put("pr", kv);
            }
            infoObject.put("sid", Utils.formatTime(session_time));
//            if (duration != 0l){
//                infoObject.put("$duration",Utils.formatTime(duration));
//            }
        } catch (JSONException e) {
            debug("数据组装出错" + e.getMessage());
        }
        return infoObject;
    }

    /*pacakge*/ ZGJSONObject identifyPerson(String uid, JSONObject kv) {


        long now_t = System.currentTimeMillis();
        ZGJSONObject infoObject = new ZGJSONObject();
        try {
            infoObject.put("et", "idf");
            infoObject.put("tz", "" + Utils.getTimeZone());
            infoObject.put("ts", Utils.formatTime(now_t));
            infoObject.put("cuid", uid);
            infoObject.put("pr", kv);
            infoObject.put("sid", Utils.formatTime(session_time));
        } catch (JSONException e) {
            debug("数据组装出错" + e.getMessage());
        }
        return infoObject;
    }

    /*package*/ JSONObject wrapData(String events) {
        try {
            JSONObject postData = new JSONObject();
            postData.put("ak", appkey);
            postData.put("sdkv", SDK_V);
            postData.put("sdk", "and");
            postData.put("did", did);
            postData.put("cn", appChannel);
            if (debug) {
                postData.put("debug", 1);
            }
            String cuid = globalSP.getString(CUID_KEY, null);
            if (cuid != null) {
                postData.put("cuid", cuid);
            }
            long now_t = System.currentTimeMillis();
            postData.put("ts", Utils.formatTime(now_t));
            postData.put("type", "statis");
            postData.put("data", new JSONArray(events));
            return postData;
        } catch (Exception e) {
            debug("数据组装出错" + e.getMessage());
        }
        return null;
    }

    /*package*/ ZGJSONObject channelData(String chan, String userId) {
        try {
            long now_t = System.currentTimeMillis();
            ZGJSONObject infoObject = new ZGJSONObject();
            infoObject.put("et", "_usermap_");
            infoObject.put("tz", "" + Utils.getTimeZone());
            infoObject.put("ts", Utils.formatTime(now_t));
            JSONObject ch = new JSONObject();
            ch.put("channel", chan);
            ch.put("user_id", userId);
            infoObject.put("pr", ch);
            return infoObject;
        } catch (JSONException e) {
            debug("数据组装出错" + e.getMessage());
        }
        return null;
    }

    /*package*/ ZGJSONObject parseMid(int msgState, ZhugeSDK.PushChannel channel, Object t) {
        JSONObject js;
        String mid = "";
        try {
            switch (channel) {
                case BAIDU:
                    String baidu = (String) t;
                    if (null == baidu)
                        return null;
                    js = new JSONObject(baidu);
                    mid = js.getString("mid");
                    break;

                case GETUI:
                    break;
                case JPUSH:
                    if (t instanceof String) {
                        String jpush = (String) t;
                        js = new JSONObject(jpush);
                        mid = js.getString("mid");
                    } else if (t instanceof JSONObject) {
                        js = (JSONObject) t;

                        mid = js.getString("mid");
                    }
                    break;
                case UMENG:
                    js = (JSONObject) t;
                    JSONObject midJson = js.getJSONObject("extra");
                    mid = midJson.getString("mid");
                    break;
                case XIAOMI:
                    if (t instanceof Map) {
                        Map<String, String> map = (Map<String, String>) t;
                        mid = map.get("mid");
                    }
                    break;
                case XINGE:

                    if (t instanceof String) {
                        String xinge = (String) t;
                        js = new JSONObject(xinge);
                        mid = js.getString("mid");
                    }
                    break;
            }
        } catch (ClassCastException e) {
            debug("Object参数传递错误");
        } catch (JSONException e) {
            debug("json转换出错" + e.getMessage());
        }
        return dealMid(mid, channel.toString(), msgState);
    }

    private ZGJSONObject dealMid(String mid, String chan, int msgState) {
        if (null == mid || "".equals(mid) || "null".equals(mid) || mid.length() < 1) {
            return null;
        }
        try {
            long now_t = System.currentTimeMillis();
            ZGJSONObject infoObject = new ZGJSONObject();
            switch (msgState) {
                case MSG_RECV:
                    infoObject.put("et", "_msgrecv_");
                    break;
                case MSG_READ:
                    infoObject.put("et", "_msgread_");
                    break;
                default:
                    return null;
            }
            infoObject.put("tz", "" + Utils.getTimeZone());
            infoObject.put("ts", Utils.formatTime(now_t));
            JSONObject ch = new JSONObject();
            ch.put("channel", chan);
            ch.put("mid", mid);
            infoObject.put("pr", ch);
            return infoObject;
        } catch (Exception e) {
            debug("通知上传错误" + e.getMessage());
        }
        return null;
    }
}

