/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.viewSpider;

import android.util.Log;
import com.zhuge.analysis.java_websocket.client.WebSocketClient;
import com.zhuge.analysis.java_websocket.drafts.Draft_17;
import com.zhuge.analysis.java_websocket.exceptions.NotSendableException;
import com.zhuge.analysis.java_websocket.exceptions.WebsocketNotConnectedException;
import com.zhuge.analysis.java_websocket.framing.Framedata;
import com.zhuge.analysis.java_websocket.handshake.ServerHandshake;
import com.zhuge.analysis.stat.CodeLessConfig;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import org.json.JSONException;
import org.json.JSONObject;

class EditorConnection {
    private final Editor mService;
    private final EditorClient mClient;
    private final URI mURI;
    private static final int CONNECT_TIMEOUT = 5000;
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    private static final String LOGTAG = "Zhuge.EditorCnctn";

    public EditorConnection(URI uri, Editor service, Socket sslSocket) throws EditorConnectionException {
        this.mService = service;
        this.mURI = uri;
        try {
            this.mClient = new EditorClient(uri, 5000, sslSocket);
            this.mClient.connectBlocking();
        }
        catch (InterruptedException e) {
            throw new EditorConnectionException((Throwable)e);
        }
    }

    public boolean isValid() {
        return !this.mClient.isClosed() && !this.mClient.isClosing() && !this.mClient.isFlushAndClose();
    }

    public BufferedOutputStream getBufferedOutputStream() {
        return new BufferedOutputStream(new WebSocketOutputStream());
    }

    private class WebSocketOutputStream
    extends OutputStream {
        private WebSocketOutputStream() {
        }

        @Override
        public void write(int b) throws EditorConnectionException {
            byte[] oneByte = new byte[]{(byte)b};
            this.write(oneByte, 0, 1);
        }

        @Override
        public void write(byte[] b) throws EditorConnectionException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws EditorConnectionException {
            ByteBuffer message = ByteBuffer.wrap(b, off, len);
            try {
                EditorConnection.this.mClient.sendFragmentedFrame(Framedata.Opcode.TEXT, message, false);
            }
            catch (WebsocketNotConnectedException e) {
                throw new EditorConnectionException((Throwable)e);
            }
        }

        @Override
        public void close() throws EditorConnectionException {
            try {
                EditorConnection.this.mClient.sendFragmentedFrame(Framedata.Opcode.TEXT, EMPTY_BYTE_BUFFER, true);
            }
            catch (WebsocketNotConnectedException e) {
                throw new EditorConnectionException((Throwable)e);
            }
            catch (NotSendableException e) {
                throw new EditorConnectionException((Throwable)e);
            }
        }
    }

    private class EditorClient
    extends WebSocketClient {
        public EditorClient(URI uri, int connectTimeout, Socket sslSocket) throws InterruptedException {
            super(uri, new Draft_17(), null, connectTimeout);
            this.setSocket(sslSocket);
        }

        @Override
        public void onOpen(ServerHandshake handshakedata) {
            if (CodeLessConfig.isDEBUG()) {
                Log.v((String)EditorConnection.LOGTAG, (String)"Websocket connected");
            }
        }

        @Override
        public void onMessage(String message) {
            if (CodeLessConfig.isDEBUG()) {
                Log.v((String)EditorConnection.LOGTAG, (String)("Received message from editor:\n" + message));
            }
            try {
                JSONObject messageJson = new JSONObject(message);
                String type = messageJson.getString("type");
                if (type.equals("device_info_request")) {
                    EditorConnection.this.mService.sendDeviceInfo();
                } else if (type.equals("snapshot_request")) {
                    EditorConnection.this.mService.sendSnapshot(messageJson);
                } else if (type.equals("change_request")) {
                    EditorConnection.this.mService.performEdit(messageJson);
                } else if (type.equals("event_binding_request")) {
                    EditorConnection.this.mService.bindEvents(messageJson);
                } else if (type.equals("clear_request")) {
                    EditorConnection.this.mService.clearEdits(messageJson);
                } else if (type.equals("tweak_request")) {
                    EditorConnection.this.mService.setTweaks(messageJson);
                }
            }
            catch (JSONException e) {
                Log.e((String)EditorConnection.LOGTAG, (String)("Bad JSON received:" + message), (Throwable)e);
            }
        }

        @Override
        public void onClose(int code, String reason, boolean remote) {
            if (CodeLessConfig.isDEBUG()) {
                Log.v((String)EditorConnection.LOGTAG, (String)("WebSocket closed. Code: " + code + ", reason: " + reason + "\nURI: " + EditorConnection.this.mURI));
            }
            EditorConnection.this.mService.cleanup();
        }

        @Override
        public void onError(Exception ex) {
            if (ex != null && ex.getMessage() != null) {
                Log.e((String)EditorConnection.LOGTAG, (String)("Websocket Error: " + ex.getMessage()));
                ex.printStackTrace();
            } else {
                Log.e((String)EditorConnection.LOGTAG, (String)"Unknown websocket error occurred");
            }
        }
    }

    public static interface Editor {
        public void sendSnapshot(JSONObject var1);

        public void performEdit(JSONObject var1);

        public void clearEdits(JSONObject var1);

        public void bindEvents(JSONObject var1);

        public void setTweaks(JSONObject var1);

        public void sendDeviceInfo();

        public void cleanup();
    }

    public class EditorConnectionException
    extends IOException {
        private static final long serialVersionUID = -1884953175346045636L;

        public EditorConnectionException(Throwable cause) {
            super(cause.getMessage());
        }
    }
}

