/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.viewSpider;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.JsonWriter;
import android.util.Log;
import android.util.Pair;
import com.zhuge.analysis.metrics.ResourceReader;
import com.zhuge.analysis.metrics.Tweaks;
import com.zhuge.analysis.stat.CodeLessConfig;
import com.zhuge.analysis.stat.ZhugeSDK;
import com.zhuge.analysis.util.HttpServices;
import com.zhuge.analysis.util.JSONUtils;
import com.zhuge.analysis.viewSpider.DynamicEventTracker;
import com.zhuge.analysis.viewSpider.EditProtocol;
import com.zhuge.analysis.viewSpider.EditState;
import com.zhuge.analysis.viewSpider.EditorConnection;
import com.zhuge.analysis.viewSpider.ImageStore;
import com.zhuge.analysis.viewSpider.ShakeGesture;
import com.zhuge.analysis.viewSpider.TrackingDebug;
import com.zhuge.analysis.viewSpider.UpdatesFromZhuge;
import com.zhuge.analysis.viewSpider.ViewSnapConfig;
import com.zhuge.analysis.viewSpider.ViewSnapshot;
import com.zhuge.analysis.viewSpider.ViewVisitor;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=16)
public class ViewCrawler
implements UpdatesFromZhuge,
TrackingDebug,
ViewVisitor.OnLayoutErrorListener {
    private boolean inConnect = false;
    private boolean inSnapShot = false;
    private final CodeLessConfig mConfig;
    private final DynamicEventTracker mDynamicEventTracker;
    private final EditState mEditState;
    private final Tweaks mTweaks;
    private final Map<String, String> mDeviceInfo;
    private final ViewCrawlerHandler mMessageThreadHandler;
    private final float mScaledDensity;
    private final String mAppKey;
    private final String mAppVersion;
    private static final String SHARED_PREF_EDITS_FILE = "zhugeCodeless";
    private static final String SHARED_PREF_CHANGES_KEY = "Zhuge.changes";
    private static final String SHARED_PREF_BINDINGS_KEY = "Zhuge.bindings";
    private static final String EVENT_TIME = "Zhuge.pretime";
    private static final int MESSAGE_INITIALIZE_CHANGES = 0;
    private static final int MESSAGE_CONNECT_TO_EDITOR = 1;
    private static final int MESSAGE_SEND_STATE_FOR_EDITING = 2;
    private static final int MESSAGE_HANDLE_EDITOR_CHANGES_RECEIVED = 3;
    private static final int MESSAGE_SEND_DEVICE_INFO = 4;
    private static final int MESSAGE_EVENT_BINDINGS_RECEIVED = 5;
    private static final int MESSAGE_HANDLE_EDITOR_BINDINGS_RECEIVED = 6;
    private static final int MESSAGE_SEND_EVENT_TRACKED = 7;
    private static final int MESSAGE_HANDLE_EDITOR_CLOSED = 8;
    private static final int MESSAGE_VARIANTS_RECEIVED = 9;
    private static final int MESSAGE_HANDLE_EDITOR_CHANGES_CLEARED = 10;
    private static final int MESSAGE_HANDLE_EDITOR_TWEAKS_RECEIVED = 11;
    private static final int MESSAGE_SEND_LAYOUT_ERROR = 12;
    private static final int MESSAGE_EVENT_UPDATE_TIME = 13;
    private static final String LOGTAG = "ZhugeSDK.ViewCrawler";

    public ViewCrawler(Context context, String appkey, String appVersion, Tweaks tweaks) {
        this.mConfig = CodeLessConfig.getInstance(context);
        this.mAppKey = appkey;
        this.mAppVersion = appVersion;
        this.mEditState = new EditState();
        this.mTweaks = tweaks;
        this.mDeviceInfo = this.mConfig.getDeviceInfo();
        this.mScaledDensity = Resources.getSystem().getDisplayMetrics().scaledDensity;
        Application app = (Application)context.getApplicationContext();
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new LifecycleCallbacks());
        HandlerThread thread = new HandlerThread(ViewCrawler.class.getCanonicalName());
        thread.setPriority(10);
        thread.start();
        this.mMessageThreadHandler = new ViewCrawlerHandler(context, thread.getLooper(), this);
        this.mDynamicEventTracker = new DynamicEventTracker(this.mConfig, this.mMessageThreadHandler);
        this.mTweaks.addOnTweakDeclaredListener(new Tweaks.OnTweakDeclaredListener(){

            @Override
            public void onTweakDeclared() {
                Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(4);
                ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
            }
        });
    }

    @Override
    public void startUpdates() {
        this.mMessageThreadHandler.start();
        this.mMessageThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (!ViewCrawler.this.updateEventFromZhuge()) {
                    ViewCrawler.this.mMessageThreadHandler.sendEmptyMessage(0);
                }
            }
        });
    }

    @Override
    public Tweaks getTweaks() {
        return this.mTweaks;
    }

    @Override
    public void setEventBindings(JSONArray bindings) {
        Message msg = this.mMessageThreadHandler.obtainMessage(5);
        msg.obj = bindings;
        this.mMessageThreadHandler.sendMessage(msg);
    }

    @Override
    public void setVariants(JSONArray variants) {
        Message msg = this.mMessageThreadHandler.obtainMessage(9);
        msg.obj = variants;
        this.mMessageThreadHandler.sendMessage(msg);
    }

    @Override
    public void reportTrack(String eventName) {
        if (!this.inConnect) {
            return;
        }
        Message m = this.mMessageThreadHandler.obtainMessage();
        m.what = 7;
        m.obj = eventName;
        this.mMessageThreadHandler.sendMessage(m);
    }

    @Override
    public void onLayoutError(ViewVisitor.LayoutErrorMessage e) {
        Message m = this.mMessageThreadHandler.obtainMessage();
        m.what = 12;
        m.obj = e;
        this.mMessageThreadHandler.sendMessage(m);
    }

    public boolean updateEventFromZhuge() {
        long preTime = this.mMessageThreadHandler.getSharedPreferences().getLong(EVENT_TIME, 0L);
        String path = CodeLessConfig.getEventUrl() + this.mAppKey + "/platform/1?app_version=" + this.mAppVersion + "&updateTimeId=" + preTime;
        HttpServices httpService = new HttpServices();
        try {
            byte[] bytes = httpService.requestApi(path, null, true);
            if (null == bytes) {
                return false;
            }
            String event = new String(bytes, "utf-8").replace("\n", "").replace("\r", "");
            this.mConfig.debug("\u53ef\u89c6\u5316\u4e8b\u4ef6\uff1a\n" + event);
            return this.updateEvent(event);
        }
        catch (Exception e) {
            Log.e((String)"ZhugeSDK", (String)("update message error:" + e.getMessage()));
            return false;
        }
    }

    private boolean updateEvent(String updateEvent) throws Exception {
        long preTime;
        JSONObject responseDict = new JSONObject(updateEvent);
        if (null == responseDict.get("event_infos") || !responseDict.has("updateTimeId")) {
            return false;
        }
        JSONArray event_infos = responseDict.getJSONArray("event_infos");
        if (event_infos.length() < 1) {
            return false;
        }
        JSONArray toBinding = new JSONArray();
        for (int i = 0; i < event_infos.length(); ++i) {
            JSONObject event = event_infos.getJSONObject(i);
            String eventJson = event.getString("eventJson");
            toBinding.put((Object)new JSONObject(eventJson.replace("\\", "")));
        }
        long uptimeId = responseDict.getLong("updateTimeId");
        if (uptimeId != (preTime = this.mMessageThreadHandler.getSharedPreferences().getLong(EVENT_TIME, -1L))) {
            Log.e((String)LOGTAG, (String)("\u66f4\u65b0\u65e0\u7801\u4e8b\u4ef6" + toBinding.toString()));
            this.setEventBindings(toBinding);
            Message eventUpdate = this.mMessageThreadHandler.obtainMessage(13);
            eventUpdate.obj = uptimeId;
            this.mMessageThreadHandler.sendMessage(eventUpdate);
            return true;
        }
        return false;
    }

    private static class VariantTweak {
        public final JSONObject tweak;
        public final Pair<Integer, Integer> variantId;

        public VariantTweak(JSONObject aTweak, Pair<Integer, Integer> aVariantId) {
            this.tweak = aTweak;
            this.variantId = aVariantId;
        }
    }

    private static class VariantChange {
        public final String activityName;
        public final JSONObject change;
        public final Pair<Integer, Integer> variantId;

        public VariantChange(String anActivityName, JSONObject someChange, Pair<Integer, Integer> aVariantId) {
            this.activityName = anActivityName;
            this.change = someChange;
            this.variantId = aVariantId;
        }
    }

    private class Editor
    implements EditorConnection.Editor {
        private Editor() {
        }

        @Override
        public void sendSnapshot(JSONObject message) {
            if (ViewCrawler.this.inSnapShot) {
                return;
            }
            ViewCrawler.this.inSnapShot = true;
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(2);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void performEdit(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(3);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void clearEdits(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(10);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void setTweaks(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(11);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void bindEvents(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(6);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void sendDeviceInfo() {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(4);
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void cleanup() {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(8);
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }
    }

    private class ViewCrawlerHandler
    extends Handler {
        private EditorConnection mEditorConnection;
        private ViewSnapshot mSnapshot;
        private final Context mContext;
        private final Lock mStartLock;
        private final EditProtocol mProtocol;
        private final ImageStore mImageStore;
        private final Map<String, Pair<String, JSONObject>> mEditorChanges;
        private final List<JSONObject> mEditorTweaks;
        private final List<String> mEditorAssetUrls;
        private final List<Pair<String, JSONObject>> mEditorEventBindings;
        private final List<VariantChange> mPersistentChanges;
        private final List<VariantTweak> mPersistentTweaks;
        private final List<Pair<String, JSONObject>> mPersistentEventBindings;
        private final Set<Pair<Integer, Integer>> mSeenExperiments;

        public ViewCrawlerHandler(Context context, Looper looper, ViewVisitor.OnLayoutErrorListener layoutErrorListener) {
            super(looper);
            this.mContext = context.getApplicationContext();
            this.mSnapshot = null;
            String resourcePackage = context.getPackageName();
            ResourceReader.Ids resourceIds = new ResourceReader.Ids(resourcePackage, context);
            this.mImageStore = new ImageStore(context);
            this.mProtocol = new EditProtocol(resourceIds, this.mImageStore, layoutErrorListener);
            this.mEditorChanges = new HashMap<String, Pair<String, JSONObject>>();
            this.mEditorTweaks = new ArrayList<JSONObject>();
            this.mEditorAssetUrls = new ArrayList<String>();
            this.mEditorEventBindings = new ArrayList<Pair<String, JSONObject>>();
            this.mPersistentChanges = new ArrayList<VariantChange>();
            this.mPersistentTweaks = new ArrayList<VariantTweak>();
            this.mPersistentEventBindings = new ArrayList<Pair<String, JSONObject>>();
            this.mSeenExperiments = new HashSet<Pair<Integer, Integer>>();
            this.mStartLock = new ReentrantLock();
            this.mStartLock.lock();
        }

        public void start() {
            this.mStartLock.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Message msg) {
            this.mStartLock.lock();
            try {
                int what = msg.what;
                switch (what) {
                    case 0: {
                        this.loadKnownChanges();
                        this.initializeChanges();
                        return;
                    }
                    case 1: {
                        this.connectToEditor();
                        return;
                    }
                    case 4: {
                        this.sendDeviceInfo();
                        return;
                    }
                    case 2: {
                        this.sendSnapshot((JSONObject)msg.obj);
                        return;
                    }
                    case 7: {
                        this.sendReportTrackToEditor((String)msg.obj);
                        return;
                    }
                    case 12: {
                        this.sendLayoutError((ViewVisitor.LayoutErrorMessage)msg.obj);
                        return;
                    }
                    case 9: {
                        this.handleVariantsReceived((JSONArray)msg.obj);
                        return;
                    }
                    case 3: {
                        this.handleEditorChangeReceived((JSONObject)msg.obj);
                        return;
                    }
                    case 5: {
                        this.handleEventBindingsReceived((JSONArray)msg.obj);
                        return;
                    }
                    case 6: {
                        this.handleEditorBindingsReceived((JSONObject)msg.obj);
                        return;
                    }
                    case 10: {
                        this.handleEditorBindingsCleared((JSONObject)msg.obj);
                        return;
                    }
                    case 11: {
                        this.handleEditorTweaksReceived((JSONObject)msg.obj);
                        return;
                    }
                    case 8: {
                        this.handleEditorClosed();
                        return;
                    }
                    case 13: {
                        this.updateEventTime((Long)msg.obj);
                        return;
                    }
                }
                return;
            }
            finally {
                this.mStartLock.unlock();
            }
        }

        private void loadKnownChanges() {
            SharedPreferences preferences = this.getSharedPreferences();
            String storedChanges = preferences.getString(ViewCrawler.SHARED_PREF_CHANGES_KEY, null);
            if (null != storedChanges) {
                try {
                    JSONArray variants = new JSONArray(storedChanges);
                    int variantsLength = variants.length();
                    for (int i = 0; i < variantsLength; ++i) {
                        JSONObject variant = variants.getJSONObject(i);
                        int variantId = variant.getInt("id");
                        int experimentId = variant.getInt("experiment_id");
                        Pair sight = new Pair((Object)experimentId, (Object)variantId);
                        this.mSeenExperiments.add((Pair<Integer, Integer>)sight);
                    }
                }
                catch (JSONException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Malformed variants found in persistent storage, clearing all variants", (Throwable)e);
                    SharedPreferences.Editor editor = preferences.edit();
                    editor.remove(ViewCrawler.SHARED_PREF_CHANGES_KEY);
                    editor.remove(ViewCrawler.SHARED_PREF_BINDINGS_KEY);
                    editor.apply();
                }
            }
        }

        private void initializeChanges() {
            SharedPreferences preferences = this.getSharedPreferences();
            String storedChanges = preferences.getString(ViewCrawler.SHARED_PREF_CHANGES_KEY, null);
            String storedBindings = preferences.getString(ViewCrawler.SHARED_PREF_BINDINGS_KEY, null);
            try {
                if (null != storedChanges) {
                    this.mPersistentChanges.clear();
                    this.mPersistentTweaks.clear();
                    JSONArray variants = new JSONArray(storedChanges);
                    int variantsLength = variants.length();
                    for (int variantIx = 0; variantIx < variantsLength; ++variantIx) {
                        JSONObject nextVariant = variants.getJSONObject(variantIx);
                        int variantIdPart = nextVariant.getInt("id");
                        int experimentIdPart = nextVariant.getInt("experiment_id");
                        Pair variantId = new Pair((Object)experimentIdPart, (Object)variantIdPart);
                        JSONArray actions = nextVariant.getJSONArray("actions");
                        for (int i = 0; i < actions.length(); ++i) {
                            JSONObject change = actions.getJSONObject(i);
                            String targetActivity = JSONUtils.optionalStringKey(change, "target_activity");
                            VariantChange variantChange = new VariantChange(targetActivity, change, (Pair<Integer, Integer>)variantId);
                            this.mPersistentChanges.add(variantChange);
                        }
                        JSONArray tweaks = nextVariant.getJSONArray("tweaks");
                        int length = tweaks.length();
                        for (int i = 0; i < length; ++i) {
                            JSONObject tweakDesc = tweaks.getJSONObject(i);
                            VariantTweak variantTweak = new VariantTweak(tweakDesc, (Pair<Integer, Integer>)variantId);
                            this.mPersistentTweaks.add(variantTweak);
                        }
                    }
                }
                if (null != storedBindings) {
                    JSONArray bindings = new JSONArray(storedBindings);
                    this.mPersistentEventBindings.clear();
                    for (int i = 0; i < bindings.length(); ++i) {
                        JSONObject event = bindings.getJSONObject(i);
                        String targetActivity = JSONUtils.optionalStringKey(event, "target_activity");
                        this.mPersistentEventBindings.add((Pair<String, JSONObject>)new Pair((Object)targetActivity, (Object)event));
                    }
                }
            }
            catch (JSONException e) {
                Log.i((String)ViewCrawler.LOGTAG, (String)"JSON error when initializing saved changes, clearing persistent memory", (Throwable)e);
                SharedPreferences.Editor editor = preferences.edit();
                editor.remove(ViewCrawler.SHARED_PREF_CHANGES_KEY);
                editor.remove(ViewCrawler.SHARED_PREF_BINDINGS_KEY);
                editor.apply();
            }
            this.applyVariantsAndEventBindings();
        }

        private void connectToEditor() {
            if (CodeLessConfig.isDEBUG()) {
                Log.v((String)ViewCrawler.LOGTAG, (String)"connecting to editor");
            }
            if (this.mEditorConnection != null && this.mEditorConnection.isValid()) {
                if (CodeLessConfig.isDEBUG()) {
                    Log.v((String)ViewCrawler.LOGTAG, (String)"There is already a valid connection to an events editor.");
                }
                return;
            }
            ViewCrawler.this.inConnect = true;
            String url = CodeLessConfig.getEditorUrl() + ViewCrawler.this.mAppKey;
            if (CodeLessConfig.isDEBUG()) {
                Log.v((String)ViewCrawler.LOGTAG, (String)("\u53ef\u89c6\u5316\u5730\u5740\uff1a" + url));
            }
            try {
                Socket sslSocket = null;
                this.mEditorConnection = new EditorConnection(new URI(url), new Editor(), sslSocket);
            }
            catch (URISyntaxException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)("Error parsing URI " + url + " for editor websocket"), (Throwable)e);
            }
            catch (EditorConnection.EditorConnectionException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)("Error connecting to URI " + url), (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendError(String errorMessage) {
            if (this.mEditorConnection == null) {
                return;
            }
            JSONObject errorObject = new JSONObject();
            try {
                errorObject.put("error_message", (Object)errorMessage);
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Apparently impossible JSONException", (Throwable)e);
            }
            OutputStreamWriter writer = new OutputStreamWriter(this.mEditorConnection.getBufferedOutputStream());
            try {
                writer.write("{\"type\": \"error\", ");
                writer.write("\"payload\": ");
                writer.write(errorObject.toString());
                writer.write("}");
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write error message to editor", (Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Could not close output writer to editor", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendDeviceInfo() {
            if (this.mEditorConnection == null) {
                return;
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            JsonWriter j = new JsonWriter((Writer)new OutputStreamWriter(out));
            try {
                j.beginObject();
                j.name("type").value("device_info_response");
                j.name("payload").beginObject();
                j.name("device_type").value("Android");
                j.name("device_name").value(Build.BRAND + "/" + Build.MODEL);
                j.name("scaled_density").value((double)ViewCrawler.this.mScaledDensity);
                for (Map.Entry entry : ViewCrawler.this.mDeviceInfo.entrySet()) {
                    j.name((String)entry.getKey()).value((String)entry.getValue());
                }
                Map<String, Tweaks.TweakValue> tweakDescs = ViewCrawler.this.mTweaks.getAllValues();
                j.name("tweaks").beginArray();
                for (Map.Entry<String, Tweaks.TweakValue> tweak : tweakDescs.entrySet()) {
                    Tweaks.TweakValue desc = tweak.getValue();
                    String tweakName = tweak.getKey();
                    j.beginObject();
                    j.name("name").value(tweakName);
                    j.name("minimum").value((Number)null);
                    j.name("maximum").value((Number)null);
                    switch (desc.type) {
                        case 1: {
                            j.name("type").value("boolean");
                            j.name("value").value(desc.getBooleanValue().booleanValue());
                            break;
                        }
                        case 2: {
                            j.name("type").value("number");
                            j.name("encoding").value("d");
                            j.name("value").value(desc.getNumberValue().doubleValue());
                            break;
                        }
                        case 3: {
                            j.name("type").value("number");
                            j.name("encoding").value("l");
                            j.name("value").value(desc.getNumberValue().longValue());
                            break;
                        }
                        case 4: {
                            j.name("type").value("string");
                            j.name("value").value(desc.getStringValue());
                            break;
                        }
                        default: {
                            Log.wtf((String)ViewCrawler.LOGTAG, (String)("Unrecognized Tweak Type " + desc.type + " encountered."));
                        }
                    }
                    j.endObject();
                }
                j.endArray();
                j.endObject();
                j.endObject();
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write device_info to server", (Throwable)e);
            }
            finally {
                try {
                    j.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Can't close websocket writer", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendSnapshot(JSONObject message) {
            long startSnapshot = System.currentTimeMillis();
            try {
                if (null == this.mSnapshot) {
                    this.mSnapshot = this.mProtocol.readSnapshotConfig(ViewSnapConfig.getViewSnapConfig());
                }
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Payload with snapshot config required with snapshot request", (Throwable)e);
                this.sendError("Payload with snapshot config required with snapshot request");
                return;
            }
            catch (EditProtocol.BadInstructionsException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Editor sent malformed message with snapshot request", (Throwable)e);
                this.sendError(e.getMessage());
                return;
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            try {
                writer.write("{");
                writer.write("\"type\": \"snapshot_response\",");
                writer.write("\"payload\": {");
                writer.write("\"activities\":");
                writer.flush();
                this.mSnapshot.snapshots(ViewCrawler.this.mEditState, out);
                long snapshotTime = System.currentTimeMillis() - startSnapshot;
                writer.write(",\"snapshot_time_millis\": ");
                writer.write(Long.toString(snapshotTime));
                writer.write("}");
                writer.write("}");
                ViewCrawler.this.inSnapShot = false;
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write snapshot request to server", (Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Can't close writer.", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendReportTrackToEditor(String eventName) {
            if (this.mEditorConnection == null) {
                return;
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            JsonWriter j = new JsonWriter((Writer)writer);
            try {
                j.beginObject();
                j.name("type").value("track_message");
                j.name("event_name").value(eventName);
                j.endObject();
                j.flush();
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)("Can't write track_message to server eventName = " + eventName), (Throwable)e);
            }
            finally {
                try {
                    j.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Can't close writer.", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendLayoutError(ViewVisitor.LayoutErrorMessage exception) {
            if (this.mEditorConnection == null) {
                return;
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            JsonWriter j = new JsonWriter((Writer)writer);
            try {
                j.beginObject();
                j.name("type").value("layout_error");
                j.name("exception_type").value(exception.getErrorType());
                j.name("cid").value(exception.getName());
                j.endObject();
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write track_message to server", (Throwable)e);
            }
            finally {
                try {
                    j.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Can't close writer.", (Throwable)e);
                }
            }
        }

        private void handleEditorChangeReceived(JSONObject changeMessage) {
            try {
                JSONObject payload = changeMessage.getJSONObject("payload");
                JSONArray actions = payload.getJSONArray("actions");
                for (int i = 0; i < actions.length(); ++i) {
                    JSONObject change = actions.getJSONObject(i);
                    String targetActivity = JSONUtils.optionalStringKey(change, "target_activity");
                    String name = change.getString("name");
                    this.mEditorChanges.put(name, (Pair<String, JSONObject>)new Pair((Object)targetActivity, (Object)change));
                }
                this.applyVariantsAndEventBindings();
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Bad change request received", (Throwable)e);
            }
        }

        private void handleEditorBindingsCleared(JSONObject clearMessage) {
            try {
                JSONObject payload = clearMessage.getJSONObject("payload");
                JSONArray actions = payload.getJSONArray("actions");
                for (int i = 0; i < actions.length(); ++i) {
                    String changeId = actions.getString(i);
                    this.mEditorChanges.remove(changeId);
                }
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Bad clear request received", (Throwable)e);
            }
            this.applyVariantsAndEventBindings();
        }

        private void handleEditorTweaksReceived(JSONObject tweaksMessage) {
            try {
                this.mEditorTweaks.clear();
                JSONObject payload = tweaksMessage.getJSONObject("payload");
                JSONArray tweaks = payload.getJSONArray("tweaks");
                int length = tweaks.length();
                for (int i = 0; i < length; ++i) {
                    JSONObject tweakDesc = tweaks.getJSONObject(i);
                    this.mEditorTweaks.add(tweakDesc);
                }
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Bad tweaks received", (Throwable)e);
            }
            this.applyVariantsAndEventBindings();
        }

        private void handleVariantsReceived(JSONArray variants) {
            SharedPreferences preferences = this.getSharedPreferences();
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(ViewCrawler.SHARED_PREF_CHANGES_KEY, variants.toString());
            editor.apply();
            this.initializeChanges();
        }

        private void handleEventBindingsReceived(JSONArray eventBindings) {
            SharedPreferences preferences = this.getSharedPreferences();
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(ViewCrawler.SHARED_PREF_BINDINGS_KEY, eventBindings.toString());
            editor.apply();
            this.initializeChanges();
        }

        private void handleEditorBindingsReceived(JSONObject message) {
            JSONArray eventBindings;
            try {
                JSONObject payload = message.getJSONObject("payload");
                eventBindings = payload.getJSONArray("events");
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Bad event bindings received", (Throwable)e);
                return;
            }
            int eventCount = eventBindings.length();
            this.mEditorEventBindings.clear();
            for (int i = 0; i < eventCount; ++i) {
                try {
                    JSONObject event = eventBindings.getJSONObject(i);
                    String targetActivity = JSONUtils.optionalStringKey(event, "target_activity");
                    this.mEditorEventBindings.add((Pair<String, JSONObject>)new Pair((Object)targetActivity, (Object)event));
                    continue;
                }
                catch (JSONException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)("Bad event binding received from editor in " + eventBindings.toString()), (Throwable)e);
                }
            }
            this.applyVariantsAndEventBindings();
        }

        private void handleEditorClosed() {
            this.mEditorChanges.clear();
            this.mEditorEventBindings.clear();
            this.mSnapshot = null;
            ViewCrawler.this.inConnect = false;
            if (CodeLessConfig.isDEBUG()) {
                Log.v((String)ViewCrawler.LOGTAG, (String)"Editor closed- freeing snapshot");
            }
            this.applyVariantsAndEventBindings();
            for (String assetUrl : this.mEditorAssetUrls) {
                this.mImageStore.deleteStorage(assetUrl);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void applyVariantsAndEventBindings() {
            ViewVisitor visitor;
            Pair<String, Object> tweakValue;
            Pair<String, JSONObject> changeInfo;
            int i;
            ArrayList<Pair> newVisitors = new ArrayList<Pair>();
            HashSet<Pair<Integer, Integer>> toTrack = new HashSet<Pair<Integer, Integer>>();
            int size = this.mPersistentChanges.size();
            for (i = 0; i < size; ++i) {
                changeInfo = this.mPersistentChanges.get(i);
                try {
                    EditProtocol.Edit edit = this.mProtocol.readEdit(changeInfo.change);
                    newVisitors.add(new Pair((Object)changeInfo.activityName, (Object)edit.visitor));
                    if (this.mSeenExperiments.contains(changeInfo.variantId)) continue;
                    toTrack.add(changeInfo.variantId);
                    continue;
                }
                catch (EditProtocol.CantGetEditAssetsException e) {
                    Log.v((String)ViewCrawler.LOGTAG, (String)"Can't load assets for an edit, won't apply the change now", (Throwable)e);
                    continue;
                }
                catch (EditProtocol.InapplicableInstructionsException e) {
                    Log.i((String)ViewCrawler.LOGTAG, (String)e.getMessage());
                    continue;
                }
                catch (EditProtocol.BadInstructionsException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Bad persistent change request cannot be applied.", (Throwable)e);
                }
            }
            size = this.mPersistentTweaks.size();
            for (i = 0; i < size; ++i) {
                VariantTweak tweakInfo = this.mPersistentTweaks.get(i);
                try {
                    tweakValue = this.mProtocol.readTweak(tweakInfo.tweak);
                    ViewCrawler.this.mTweaks.set((String)tweakValue.first, tweakValue.second);
                    if (this.mSeenExperiments.contains(tweakInfo.variantId)) continue;
                    toTrack.add(tweakInfo.variantId);
                    continue;
                }
                catch (EditProtocol.BadInstructionsException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Bad editor tweak cannot be applied.", (Throwable)e);
                }
            }
            for (Pair<String, JSONObject> changeInfo2 : this.mEditorChanges.values()) {
                try {
                    EditProtocol.Edit edit = this.mProtocol.readEdit((JSONObject)changeInfo2.second);
                    newVisitors.add(new Pair(changeInfo2.first, (Object)edit.visitor));
                    this.mEditorAssetUrls.addAll(edit.imageUrls);
                }
                catch (EditProtocol.CantGetEditAssetsException e) {
                    Log.v((String)ViewCrawler.LOGTAG, (String)"Can't load assets for an edit, won't apply the change now", (Throwable)e);
                }
                catch (EditProtocol.InapplicableInstructionsException e) {
                    Log.i((String)ViewCrawler.LOGTAG, (String)e.getMessage());
                }
                catch (EditProtocol.BadInstructionsException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Bad editor change request cannot be applied.", (Throwable)e);
                }
            }
            size = this.mEditorTweaks.size();
            for (i = 0; i < size; ++i) {
                JSONObject tweakDesc = this.mEditorTweaks.get(i);
                try {
                    tweakValue = this.mProtocol.readTweak(tweakDesc);
                    ViewCrawler.this.mTweaks.set((String)tweakValue.first, tweakValue.second);
                    continue;
                }
                catch (EditProtocol.BadInstructionsException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Strange tweaks received", (Throwable)e);
                }
            }
            size = this.mPersistentEventBindings.size();
            for (i = 0; i < size; ++i) {
                changeInfo = this.mPersistentEventBindings.get(i);
                try {
                    visitor = this.mProtocol.readEventBinding((JSONObject)changeInfo.second, ViewCrawler.this.mDynamicEventTracker);
                    newVisitors.add(new Pair(changeInfo.first, (Object)visitor));
                    continue;
                }
                catch (EditProtocol.InapplicableInstructionsException e) {
                    Log.i((String)ViewCrawler.LOGTAG, (String)e.getMessage());
                    continue;
                }
                catch (EditProtocol.BadInstructionsException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Bad persistent event binding cannot be applied.", (Throwable)e);
                }
            }
            size = this.mEditorEventBindings.size();
            for (i = 0; i < size; ++i) {
                changeInfo = this.mEditorEventBindings.get(i);
                try {
                    visitor = this.mProtocol.readEventBinding((JSONObject)changeInfo.second, ViewCrawler.this.mDynamicEventTracker);
                    newVisitors.add(new Pair(changeInfo.first, (Object)visitor));
                    continue;
                }
                catch (EditProtocol.InapplicableInstructionsException e) {
                    Log.i((String)ViewCrawler.LOGTAG, (String)e.getMessage());
                    continue;
                }
                catch (EditProtocol.BadInstructionsException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Bad editor event binding cannot be applied.", (Throwable)e);
                }
            }
            HashMap<String, List<ViewVisitor>> editMap = new HashMap<String, List<ViewVisitor>>();
            int totalEdits = newVisitors.size();
            for (int i2 = 0; i2 < totalEdits; ++i2) {
                void var7_26;
                Pair next = (Pair)newVisitors.get(i2);
                if (editMap.containsKey(next.first)) {
                    List list = (List)editMap.get(next.first);
                } else {
                    ArrayList arrayList = new ArrayList();
                    editMap.put((String)next.first, arrayList);
                }
                var7_26.add(next.second);
            }
            ViewCrawler.this.mEditState.setEdits(editMap);
            this.mSeenExperiments.addAll(toTrack);
            if (toTrack.size() > 0) {
                JSONObject variantObject = new JSONObject();
                try {
                    for (Pair pair : toTrack) {
                        int experimentId = (Integer)pair.first;
                        int variantId = (Integer)pair.second;
                        variantObject.put(Integer.toString(experimentId), variantId);
                    }
                }
                catch (JSONException e) {
                    Log.wtf((String)ViewCrawler.LOGTAG, (String)"Could not build JSON for reporting experiment start", (Throwable)e);
                }
            }
        }

        private void updateEventTime(long obj) {
            this.getSharedPreferences().edit().putLong(ViewCrawler.EVENT_TIME, obj).apply();
        }

        private SharedPreferences getSharedPreferences() {
            String sharedPrefsName = ViewCrawler.SHARED_PREF_EDITS_FILE + ViewCrawler.this.mAppKey;
            return this.mContext.getSharedPreferences(sharedPrefsName, 0);
        }
    }

    private class LifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks,
    ShakeGesture.OnShakeGestureListener {
        private final ShakeGesture mShakeGesture = new ShakeGesture(this);

        @Override
        public void onShakeGesture() {
            Message message = ViewCrawler.this.mMessageThreadHandler.obtainMessage(1);
            ViewCrawler.this.mMessageThreadHandler.sendMessage(message);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
            this.installConnectionSensor(activity);
            ViewCrawler.this.mEditState.add(activity);
            ZhugeSDK.getInstance().init((Context)activity);
        }

        public void onActivityPaused(Activity activity) {
            ViewCrawler.this.mEditState.remove(activity);
            if (ViewCrawler.this.mEditState.isEmpty()) {
                this.uninstallConnectionSensor(activity);
            }
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        private void installConnectionSensor(Activity activity) {
            if (!CodeLessConfig.getDisableGestureBindingUI()) {
                this.mShakeGesture.register((Context)activity);
            }
        }

        private void uninstallConnectionSensor(Activity activity) {
            if (!CodeLessConfig.getDisableGestureBindingUI()) {
                this.mShakeGesture.unRegister();
            }
        }
    }
}

