/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.stat;

import android.content.Context;
import android.os.Build;
import com.zhuge.analysis.metrics.Tweaks;
import com.zhuge.analysis.stat.CodeLessConfig;
import com.zhuge.analysis.stat.EventStore;
import com.zhuge.analysis.stat.ZhugeConfig;
import com.zhuge.analysis.util.ZGJSONObject;
import com.zhuge.analysis.viewSpider.TrackingDebug;
import com.zhuge.analysis.viewSpider.UpdatesFromZhuge;
import com.zhuge.analysis.viewSpider.ViewCrawler;
import java.util.HashMap;
import org.json.JSONObject;

public class ZhugeSDK {
    private ZhugeConfig config = new ZhugeConfig();
    private EventStore eventStore;
    private UpdatesFromZhuge viewCrawler;
    private TrackingDebug trackingDebug;

    private ZhugeSDK() {
    }

    public static ZhugeSDK getInstance() {
        return SingletonHolder.instance;
    }

    public void openLog() {
        this.config.logEnable = true;
        CodeLessConfig.openDebug();
    }

    public void openDebug() {
        ZhugeConfig.debug = true;
    }

    public void disableAccounts() {
        this.config.disableAccounts();
    }

    public void disablePhoneNumber() {
        this.config.disablePhonenum();
    }

    public void disableAppList() {
        this.config.disableAppList();
    }

    public void init(Context context) {
        this.config.initDevInfo(context);
        this.init(context, this.config.getAppkey(), this.config.getAppChannel());
    }

    public void init(Context context, String appKey, String appChannel) {
        if (this.config.checkSelf(appKey, appChannel)) {
            this.config.debug("appKey: " + appKey + " ,appChannel: " + appChannel + "\n" + "\u6216\u8bb8\u662f\u91cd\u65b0\u8fdb\u5165");
            return;
        }
        this.config.preSessionEnd = System.currentTimeMillis();
        this.config.initGlobalSettingFile(context.getApplicationContext());
        this.config.setAppkey(appKey);
        this.config.setAppChannel(appChannel);
        this.config.initDeviceInfo(context);
        if (this.config.getDid() == null) {
            return;
        }
        this.config.initAppinfo(context);
        this.config.debugInitInfo(context);
        this.config.debug("\u4f1a\u8bdd\u5f00\u59cb");
        this.eventStore = EventStore.getInstance(context, this.config);
        this.completeLastSession(1);
        this.startSession();
        this.initInfo(context.getApplicationContext());
        this.initAccont(context.getApplicationContext());
        this.initApplist(context.getApplicationContext());
    }

    public void codelessInit(Context mContext, boolean openGestureBindingUI) {
        if (openGestureBindingUI) {
            CodeLessConfig.openGestureBindingUI();
        }
        this.init(mContext);
        this.viewCrawler = this.constructUpdatesFromZhuge(mContext);
        if (null == this.viewCrawler) {
            return;
        }
        this.viewCrawler.startUpdates();
        this.trackingDebug = this.constructTrackingDebug();
    }

    @Deprecated
    public void onEvent(Context context, String event_name, JSONObject kv) {
        this.track(context, event_name, kv);
    }

    @Deprecated
    public void onEvent(Context context, String event_name, HashMap<String, Object> kv) {
        this.track(context, event_name, kv);
    }

    @Deprecated
    public void onEvent(Context context, String event_name) {
        this.track(context, event_name);
    }

    public void track(Context context, String event_name, JSONObject kv) {
        if (this.config.getDid() == null) {
            return;
        }
        this.config.debug("\u6dfb\u52a0\u4e8b\u4ef6\uff1a\n" + event_name + "\n" + kv.toString());
        ZGJSONObject info = this.config.customEvent(event_name, kv);
        this.eventStore.addEventToHandler(info, 6);
    }

    public void track(Context context, String event_name, HashMap<String, Object> kv) {
        this.track(context, event_name, new JSONObject(kv));
    }

    public void track(Context context, String event_name) {
        if (this.config.getDid() == null) {
            return;
        }
        if (null != this.trackingDebug) {
            this.trackingDebug.reportTrack(event_name);
        }
        this.config.debug("\u6dfb\u52a0\u4e8b\u4ef6\uff1a\n" + event_name);
        ZGJSONObject info = this.config.customEvent(event_name, null);
        this.eventStore.addEventToHandler(info, 6);
    }

    public void identify(Context context, String uid, HashMap<String, Object> kv) {
        this.identify(context, uid, new JSONObject(kv));
    }

    public void identify(Context context, String uid, JSONObject kv) {
        if (this.config.getDid() == null) {
            return;
        }
        this.config.debug("\u6807\u8bb0\u7528\u6237\uff1a\n" + uid + "\n" + kv.toString());
        ZGJSONObject info = this.config.identifyPerson(uid, kv);
        this.eventStore.addEventToHandler(info, 7);
    }

    public void flush(Context context) {
        if (this.config.getDid() == null) {
            return;
        }
        ZGJSONObject info = this.config.completeLastSession(2, this.eventStore.getEventCount());
        if (null == info) {
            return;
        }
        this.eventStore.addEventToHandler(info, 2);
    }

    public String getDid() {
        return this.config.getDid();
    }

    public void setThirdPartyPushUserId(PushChannel channel, String userId) {
        if (null == channel || null == userId) {
            return;
        }
        String chan = channel.toString();
        ZGJSONObject info = this.config.channelData(chan, userId);
        if (null != info) {
            this.eventStore.addEventToHandler(info, 8);
        }
    }

    public void onMsgReaded(PushChannel channel, Object t) {
        ZGJSONObject info = this.config.parseMid(1, channel, t);
        if (null != info) {
            this.eventStore.addEventToHandler(info, 8);
        }
    }

    public void onMsgRecved(PushChannel channel, Object t) {
        ZGJSONObject info = this.config.parseMid(0, channel, t);
        if (null != info) {
            this.eventStore.addEventToHandler(info, 8);
        }
    }

    private void initApplist(Context context) {
        ZGJSONObject info = this.config.initApplist(context);
        if (null == info) {
            return;
        }
        this.eventStore.addEventToHandler(info, 5);
    }

    private void initAccont(Context context) {
        ZGJSONObject info = this.config.initAcs(context);
        if (null == info) {
            return;
        }
        this.eventStore.addEventToHandler(info, 4);
    }

    private void initInfo(Context context) {
        ZGJSONObject info = this.config.initInfo(context);
        if (null == info) {
            return;
        }
        this.eventStore.addEventToHandler(info, 3);
    }

    private void startSession() {
        ZGJSONObject info = this.config.startSession();
        this.eventStore.addEventToHandler(info, 0);
    }

    private void completeLastSession(int state) {
        ZGJSONObject info = this.config.completeLastSession(state, this.eventStore.getEventCount());
        if (null == info) {
            return;
        }
        this.eventStore.addEventToHandler(info, 1);
    }

    private TrackingDebug constructTrackingDebug() {
        if (this.viewCrawler instanceof ViewCrawler) {
            return (TrackingDebug)((Object)this.viewCrawler);
        }
        return null;
    }

    private UpdatesFromZhuge constructUpdatesFromZhuge(Context mContext) {
        if (Build.VERSION.SDK_INT < 16) {
            this.config.debug("\u5f53\u524d\u7684\u5b89\u5353\u7248\u672c\u4e0d\u652f\u6301\u52a8\u6001\u6253\u70b9");
            return null;
        }
        return new ViewCrawler(mContext, this.config.getAppkey(), this.config.getAppVersion(), new Tweaks());
    }

    public static enum PushChannel {
        JPUSH("jpush"),
        UMENG("umeng"),
        XIAOMI("xiaomi"),
        BAIDU("baidu"),
        XINGE("xinge"),
        GETUI("getui");

        private String value;

        private PushChannel(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SingletonHolder {
        private static final ZhugeSDK instance = new ZhugeSDK();

        private SingletonHolder() {
        }
    }
}

