/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.stat;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Base64;
import com.zhuge.analysis.stat.ZhugeConfig;
import com.zhuge.analysis.stat.ZhugeDbAdapter;
import com.zhuge.analysis.util.ActivityServicesUtils;
import com.zhuge.analysis.util.HttpServices;
import com.zhuge.analysis.util.ZGJSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import org.json.JSONException;
import org.json.JSONObject;

class EventStore {
    private static final Map<Context, EventStore> sInstances = new HashMap<Context, EventStore>();
    static final int MESSAGE_START_SESSION = 0;
    static final int MESSAGE_COMPLETE_SESSION = 1;
    static final int MESSAGE_FLUSH = 2;
    static final int MESSAGE_INIT_INFO = 3;
    static final int MESSAGE_INIT_ACCOUNTS = 4;
    static final int MESSAGE_INIT_APPLIST = 5;
    static final int MESSAGE_CUSTOM_EVENT = 6;
    static final int MESSAGE_IDENTIFY_EVENT = 7;
    static final int MESSAGE_PUSH_MSG = 8;
    static final int MESSAGE_CHECK_ACTIVE = 9;
    static final int MESSAGE_WILL_EXIT = 10;
    private EventHandler eventHandler;
    private ZhugeConfig config;
    private static final String sessionEventCount = "session_event_count";
    private final Context mContext;

    private EventStore(Context context, ZhugeConfig zhugeConfig) {
        HandlerThread thread = new HandlerThread(EventStore.class.getCanonicalName());
        thread.setPriority(10);
        thread.start();
        this.mContext = context;
        this.config = zhugeConfig;
        this.eventHandler = new EventHandler(thread.getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EventStore getInstance(Context context, ZhugeConfig zhugeConfig) {
        Map<Context, EventStore> map = sInstances;
        synchronized (map) {
            EventStore ret;
            Context appContext = context.getApplicationContext();
            if (!sInstances.containsKey(appContext)) {
                ret = new EventStore(appContext, zhugeConfig);
                sInstances.put(appContext, ret);
            } else {
                ret = sInstances.get(appContext);
            }
            return ret;
        }
    }

    void addEventToHandler(ZGJSONObject info, int message_state) {
        Message message = this.eventHandler.obtainMessage(message_state);
        message.obj = info;
        message.sendToTarget();
    }

    int getEventCount() {
        return this.config.getGlobalSP().getInt(sessionEventCount, 0);
    }

    private class EventHandler
    extends Handler {
        private final int mFlushInterval;
        private final String myPackageName;
        private boolean inCheck;
        private int todayTotal;
        private int localSize;
        private int sessionCount;
        private ZhugeDbAdapter mDb;
        private ActivityServicesUtils asUtils;
        private HttpServices httpServices;

        public EventHandler(Looper looper) {
            super(looper);
            this.inCheck = false;
            this.todayTotal = 0;
            this.localSize = 0;
            this.sessionCount = 0;
            this.mFlushInterval = ZhugeConfig.getPeriod_time() * 1000;
            this.asUtils = new ActivityServicesUtils(EventStore.this.mContext);
            this.myPackageName = EventStore.this.mContext.getPackageName();
            String todayInfo = EventStore.this.config.getGlobalSP().getString(EventStore.this.config.getTotaldayKey(), "");
            if (!"".equals(todayInfo)) {
                String[] toInfo = todayInfo.split("\\|");
                this.todayTotal = System.currentTimeMillis() / 1000L / 86400L - (long)Integer.parseInt(toInfo[0]) != 0L ? 0 : Integer.parseInt(toInfo[1]);
            }
            this.mDb = null;
        }

        public void handleMessage(Message msg) {
            if (this.inCheck && this.hasMessages(10)) {
                this.removeMessages(10);
                this.inCheck = false;
                EventStore.this.config.debug("\u91cd\u65b0\u6d3b\u8dc3\uff0c\u79fb\u9664\u9000\u51fa\u68c0\u6d4b");
            }
            if (null == this.mDb) {
                this.mDb = new ZhugeDbAdapter(EventStore.this.mContext);
            }
            switch (msg.what) {
                case 1: {
                    ZGJSONObject info = (ZGJSONObject)((Object)msg.obj);
                    this.addEvent(info);
                    break;
                }
                case 0: {
                    ZGJSONObject seStart = (ZGJSONObject)((Object)msg.obj);
                    this.addEvent(seStart);
                    this.updateSessionTime(false);
                    break;
                }
                case 2: {
                    ZGJSONObject flush = (ZGJSONObject)((Object)msg.obj);
                    this.updateSessionTime(true);
                    this.addEvent(flush);
                    this.flushEvent(true);
                    if (this.hasMessages(9)) {
                        this.removeMessages(9);
                    }
                    EventStore.this.config.debug("flush\uff0c\u9000\u51fa\u4f1a\u8bdd");
                    return;
                }
                case 3: {
                    ZGJSONObject initInfo = (ZGJSONObject)((Object)msg.obj);
                    this.addEvent(initInfo);
                    this.updateInitInfo();
                    break;
                }
                case 4: {
                    ZGJSONObject init_acc = (ZGJSONObject)((Object)msg.obj);
                    this.addEvent(init_acc);
                    this.updateInitAccount();
                    break;
                }
                case 5: {
                    ZGJSONObject init_app = (ZGJSONObject)((Object)msg.obj);
                    this.addEvent(init_app);
                    this.updateInitPkg();
                    break;
                }
                case 6: {
                    ZGJSONObject customEvent = (ZGJSONObject)((Object)msg.obj);
                    this.addEvent(customEvent);
                    this.updateSessionTime(false);
                    break;
                }
                case 7: {
                    ZGJSONObject identify = (ZGJSONObject)((Object)msg.obj);
                    this.addEvent(identify);
                    this.flushEvent(true);
                    this.updateCid(identify);
                    break;
                }
                case 8: {
                    ZGJSONObject channel = (ZGJSONObject)((Object)msg.obj);
                    this.addEvent(channel);
                    this.flushEvent(true);
                    break;
                }
                case 9: {
                    this.updateSessionTime(false);
                    if (!this.checkActive()) {
                        this.inCheck = true;
                        EventStore.this.config.debug("\u4e0d\u5728\u6d3b\u8dc3\u72b6\u6001\uff0c\u53d1\u9001\u9000\u51fa\u68c0\u6d4b\uff0c30\u79d2\u540e\u8fdb\u884c\u9000\u51fa\u68c0\u6d4b");
                        this.sendEmptyMessageDelayed(10, 30000L);
                        return;
                    }
                    this.flushEvent(false);
                    break;
                }
                case 10: {
                    this.inCheck = false;
                    if (this.checkActive()) {
                        EventStore.this.config.debug("\u9000\u51fa\u68c0\u6d4b\u4e0d\u6210\u7acb");
                        break;
                    }
                    if (this.hasMessages(9)) {
                        this.removeMessages(9);
                    }
                    ZGJSONObject json = EventStore.this.config.completeLastSession(0, EventStore.this.getEventCount());
                    this.updateSessionTime(true);
                    this.addEvent(json);
                    this.flushEvent(true);
                    EventStore.this.config.debug("\u9000\u51fa\u68c0\u6d4b\u6210\u7acb\uff0c\u9000\u51fa\u4f1a\u8bdd");
                    return;
                }
            }
            if (!this.inCheck && !this.hasMessages(9)) {
                this.sendEmptyMessageDelayed(9, this.mFlushInterval);
            }
        }

        private boolean checkActive() {
            String presentPackage = this.asUtils.getForegroundPackage();
            return presentPackage.contains(this.myPackageName);
        }

        private void updateInitInfo() {
            EventStore.this.config.getGlobalSP().edit().putLong(EventStore.this.config.getConfig_info(), System.currentTimeMillis()).apply();
        }

        private void updateInitAccount() {
            EventStore.this.config.getGlobalSP().edit().putLong(EventStore.this.config.getConfig_account(), System.currentTimeMillis()).apply();
        }

        private void updateInitPkg() {
            EventStore.this.config.getGlobalSP().edit().putLong(EventStore.this.config.getConfig_pkg(), System.currentTimeMillis()).apply();
        }

        private void updateCid(ZGJSONObject identify) {
            try {
                String uid = identify.getString("cuid");
                EventStore.this.config.getGlobalSP().edit().putString(EventStore.this.config.getConfig_Cuid(), uid).apply();
            }
            catch (JSONException e) {
                EventStore.this.config.debug("\u66f4\u65b0\u7528\u6237ID\u51fa\u9519\uff1a" + identify.toString() + "\n" + e.getMessage());
            }
        }

        private void updateSessionTime(boolean exit) {
            long now;
            if (exit) {
                ((EventStore)EventStore.this).config.preSessionEnd = -1L;
                EventStore.this.config.getGlobalSP().edit().putString(EventStore.this.config.getLastSession(), "").apply();
                return;
            }
            ((EventStore)EventStore.this).config.preSessionEnd = now = System.currentTimeMillis();
            String updateSession = EventStore.this.config.getSessionTime() + "|" + now;
            EventStore.this.config.getGlobalSP().edit().putString(EventStore.this.config.getLastSession(), updateSession).apply();
        }

        private void addEvent(ZGJSONObject info) {
            if (this.localSize >= 400) {
                return;
            }
            EventStore.this.config.getGlobalSP().edit().putInt(EventStore.sessionEventCount, ++this.sessionCount).apply();
            this.localSize = this.mDb.addEvent(info);
        }

        private void flushEvent(boolean flush) {
            String[] mDbData;
            if (!ZhugeConfig.debug) {
                if (!flush && this.localSize < 5) {
                    return;
                }
                if (!HttpServices.isOnline(EventStore.this.mContext)) {
                    EventStore.this.config.debug("\u7f51\u7edc\u94fe\u63a5\u4e0d\u53ef\u7528\uff0c\u9000\u51fa\u53d1\u9001\u3002");
                    return;
                }
                if (this.todayTotal > EventStore.this.config.getUpload_per_day()) {
                    EventStore.this.config.debug("\u6570\u636e\u8d85\u8fc7\u6bcf\u65e5\u4e0a\u4f20\u9650\u5236\u3002");
                }
            }
            if (this.httpServices == null) {
                this.httpServices = new HttpServices();
            }
            if (null == (mDbData = this.mDb.getData())) {
                return;
            }
            HashMap<String, Object> postMap = new HashMap<String, Object>();
            JSONObject postData = EventStore.this.config.wrapData(mDbData[1]);
            String data = Base64.encodeToString((byte[])this.compress(postData.toString().getBytes()), (int)0).replace("\r", "").replace("\n", "");
            postMap.put("method", "event_statis_srv.upload");
            postMap.put("compress", "1");
            postMap.put("event", data);
            byte[] returnByte = this.httpServices.requestApi("https://apipool.zhugeio.com/APIPOOL/", postMap, true);
            JSONObject responseDict = null;
            try {
                responseDict = new JSONObject(new String(returnByte, "UTF-8"));
            }
            catch (Exception e) {
                EventStore.this.config.debug("\u8fd4\u56de\u6570\u636e\u65e0\u6cd5\u6b63\u786e\u5904\u7406.");
            }
            if (null != responseDict) {
                if (responseDict.optInt("return_code") == 0) {
                    EventStore.this.config.debug("\u53d1\u9001\u6210\u529f:" + responseDict.toString());
                    this.todayTotal += Integer.parseInt(mDbData[2]);
                    if (!ZhugeConfig.debug) {
                        this.updateEventCount();
                    }
                    this.localSize -= Integer.parseInt(mDbData[2]);
                    this.mDb.removeEvent(mDbData[0]);
                } else {
                    EventStore.this.config.debug("\u53d1\u9001\u5931\u8d25\uff0c\u8fd4\u56de\u7801\uff1a" + responseDict.optInt("return_code"));
                }
            }
        }

        private void updateEventCount() {
            int day = (int)(System.currentTimeMillis() / 1000L / 86400L);
            EventStore.this.config.getGlobalSP().edit().putString(EventStore.this.config.getTotaldayKey(), day + "|" + this.todayTotal).commit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] compress(byte[] data) {
            byte[] output = new byte[]{};
            Deflater deflater = new Deflater();
            deflater.reset();
            deflater.setInput(data);
            deflater.finish();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
            try {
                int dataLen = data.length;
                byte[] buf = new byte[dataLen + 1];
                while (!deflater.finished()) {
                    int i = deflater.deflate(buf);
                    bos.write(buf, 0, i);
                }
                output = bos.toByteArray();
            }
            catch (Exception e) {
                output = data;
                e.printStackTrace();
            }
            finally {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            deflater.end();
            return output;
        }
    }
}

