/*
 * Decompiled with CFR 0.152.
 */
package com.zhuge.analysis.metrics;

import android.R;
import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import com.zhuge.analysis.metrics.ResourceIds;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public abstract class ResourceReader
implements ResourceIds {
    private final Context mContext;
    private final Map<String, Integer> mIdNameToId;
    private final SparseArray<String> mIdToIdName;
    private static final String LOGTAG = "Zhuge.RsrcReader";

    protected ResourceReader(Context context) {
        this.mContext = context;
        this.mIdNameToId = new HashMap<String, Integer>();
        this.mIdToIdName = new SparseArray();
    }

    @Override
    public boolean knownIdName(String name) {
        return this.mIdNameToId.containsKey(name);
    }

    @Override
    public int idFromName(String name) {
        return this.mIdNameToId.get(name);
    }

    @Override
    public String nameForId(int id2) {
        return (String)this.mIdToIdName.get(id2);
    }

    private static void readClassIds(Class<?> platformIdClass, String namespace, Map<String, Integer> namesToIds) {
        try {
            Field[] fields = platformIdClass.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Class<?> fieldType;
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || (fieldType = field.getType()) != Integer.TYPE) continue;
                String name = field.getName();
                int value = field.getInt(null);
                String namespacedName = null == namespace ? name : namespace + ":" + name;
                namesToIds.put(namespacedName, value);
            }
        }
        catch (IllegalAccessException e) {
            Log.e((String)LOGTAG, (String)("Can't read built-in id names from " + platformIdClass.getName()), (Throwable)e);
        }
    }

    protected abstract Class<?> getSystemClass();

    protected abstract String getLocalClassName(Context var1);

    protected void initialize() {
        this.mIdNameToId.clear();
        this.mIdToIdName.clear();
        Class<?> sysIdClass = this.getSystemClass();
        ResourceReader.readClassIds(sysIdClass, "android", this.mIdNameToId);
        String localClassName = this.getLocalClassName(this.mContext);
        try {
            Class<?> rIdClass = Class.forName(localClassName);
            ResourceReader.readClassIds(rIdClass, null, this.mIdNameToId);
        }
        catch (ClassNotFoundException e) {
            Log.w((String)LOGTAG, (String)("Can't load names for Android view ids from '" + localClassName + "', ids by name will not be available in the events editor."));
        }
        for (Map.Entry<String, Integer> idMapping : this.mIdNameToId.entrySet()) {
            this.mIdToIdName.put(idMapping.getValue().intValue(), (Object)idMapping.getKey());
        }
    }

    public static class Drawables
    extends ResourceReader {
        private final String mResourcePackageName;

        protected Drawables(String resourcePackageName, Context context) {
            super(context);
            this.mResourcePackageName = resourcePackageName;
            this.initialize();
        }

        @Override
        protected Class<?> getSystemClass() {
            return R.drawable.class;
        }

        @Override
        protected String getLocalClassName(Context context) {
            return this.mResourcePackageName + ".R$drawable";
        }
    }

    public static class Ids
    extends ResourceReader {
        private final String mResourcePackageName;

        public Ids(String resourcePackageName, Context context) {
            super(context);
            this.mResourcePackageName = resourcePackageName;
            this.initialize();
        }

        @Override
        protected Class<?> getSystemClass() {
            return R.id.class;
        }

        @Override
        protected String getLocalClassName(Context context) {
            return this.mResourcePackageName + ".R$id";
        }
    }
}

