/*
 * Decompiled with CFR 0.152.
 */
package com.zhuazhu.image;

import android.app.Dialog;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.zhuazhu.image.R;
import java.util.ArrayList;
import java.util.List;
import me.relex.photodraweeview.OnPhotoTapListener;
import me.relex.photodraweeview.PhotoDraweeView;

public class ImageDialog
extends Dialog
implements View.OnClickListener,
OnPhotoTapListener,
ViewPager.OnPageChangeListener {
    private String imgurl;
    private List<String> mUrls = new ArrayList<String>();
    private int url_length;
    private String host = "";
    private ViewPager mViewPager;
    private TextView mIndex;

    public ImageDialog(Context context, String url) {
        super(context, R.style.imagedialog_dialog);
        this.imgurl = url;
    }

    public ImageDialog(Context context, List<String> urls) {
        super(context, R.style.imagedialog_dialog);
        this.mUrls = urls;
        this.url_length = this.mUrls.size();
    }

    public void setHost(String host) {
        if (this.isNotEmpty(host)) {
            this.host = host;
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog_image);
        Window dialogWindow = this.getWindow();
        WindowManager.LayoutParams lp = dialogWindow.getAttributes();
        lp.width = -1;
        lp.height = -1;
        PhotoDraweeView draweeView = (PhotoDraweeView)this.findViewById(R.id.img);
        ImageView close = (ImageView)this.findViewById(R.id.close);
        FrameLayout frameLayout = (FrameLayout)this.findViewById(R.id.frame);
        this.mViewPager = (ViewPager)this.findViewById(R.id.viewPager);
        this.mIndex = (TextView)this.findViewById(R.id.index);
        close.setOnClickListener((View.OnClickListener)this);
        if (this.mUrls.size() > 0) {
            frameLayout.setVisibility(0);
            draweeView.setVisibility(8);
            this.initViewPage();
        } else {
            frameLayout.setVisibility(8);
            draweeView.setVisibility(0);
            if (this.isNotEmpty(this.host)) {
                this.imgurl = this.host + this.imgurl;
            }
            Uri URI = Uri.parse((String)this.imgurl);
            draweeView.setPhotoUri(URI);
            draweeView.setOnPhotoTapListener((OnPhotoTapListener)this);
        }
    }

    private void initViewPage() {
        this.mViewPager.setAdapter(new PagerAdapter(){

            public int getCount() {
                return ImageDialog.this.mUrls.size();
            }

            public boolean isViewFromObject(View view, Object object) {
                return view == object;
            }

            public Object instantiateItem(ViewGroup container, int position) {
                PhotoDraweeView v = new PhotoDraweeView(ImageDialog.this.getContext());
                String url = (String)ImageDialog.this.mUrls.get(position);
                if (ImageDialog.this.isNotEmpty(ImageDialog.this.host)) {
                    url = ImageDialog.this.host + url;
                }
                Uri URI = Uri.parse((String)url);
                v.setPhotoUri(URI);
                ViewParent vp = v.getParent();
                if (vp != null) {
                    ViewGroup parent = (ViewGroup)vp;
                    parent.removeView((View)v);
                }
                container.addView((View)v);
                v.setOnPhotoTapListener(new OnPhotoTapListener(){

                    public void onPhotoTap(View view, float x, float y) {
                        ImageDialog.this.cancel();
                    }
                });
                return v;
            }

            public void destroyItem(ViewGroup container, int position, Object object) {
            }
        });
        this.mViewPager.setCurrentItem(0);
        this.mIndex.setText((CharSequence)("1/" + this.url_length));
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
    }

    public void setIndex(int index) {
        this.mViewPager.setCurrentItem(index);
    }

    public boolean isEmpty(String str) {
        boolean flag = true;
        flag = str == null || "".equals(str.trim());
        return flag;
    }

    public boolean isNotEmpty(String str) {
        return !this.isEmpty(str);
    }

    public void onClick(View v) {
        this.cancel();
    }

    public void onPhotoTap(View view, float x, float y) {
        this.cancel();
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        this.mIndex.setText((CharSequence)(position + 1 + "/" + this.url_length));
    }

    public void onPageScrollStateChanged(int state) {
    }
}

