/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.indicator;

import android.content.Context;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import com.zhpan.bannerview.indicator.IIndicator;
import com.zhpan.bannerview.manager.IndicatorOptions;

public class BaseIndicatorView
extends View
implements IIndicator {
    private IndicatorOptions mIndicatorOptions;
    protected Paint mPaint;
    private ViewPager mViewPager;

    public BaseIndicatorView(Context context) {
        super(context);
    }

    public BaseIndicatorView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BaseIndicatorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mIndicatorOptions = new IndicatorOptions();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
    }

    public void onPageSelected(int position) {
        if (this.getSlideMode() == 0) {
            this.setCurrentPosition(position);
            this.setSlideProgress(0.0f);
            this.invalidate();
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.getSlideMode() != 0 && this.getPageSize() > 1) {
            this.scrollSlider(position, positionOffset);
            this.invalidate();
        }
    }

    private void scrollSlider(int position, float positionOffset) {
        if (position % this.getPageSize() == this.getPageSize() - 1) {
            if ((double)positionOffset < 0.5) {
                this.setCurrentPosition(position);
                this.setSlideProgress(0.0f);
            } else {
                this.setCurrentPosition(0);
                this.setSlideProgress(0.0f);
            }
        } else {
            this.setCurrentPosition(position);
            this.setSlideProgress(positionOffset);
        }
    }

    @Override
    public void notifyDataChanged() {
        this.setupViewPager();
        this.requestLayout();
        this.invalidate();
    }

    private void setupViewPager() {
        if (this.mViewPager != null) {
            this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            if (this.mViewPager.getAdapter() != null) {
                this.setPageSize(this.mViewPager.getAdapter().getCount());
            }
        }
    }

    private void setPageSize(int pageSize) {
        this.mIndicatorOptions.setPageSize(pageSize);
    }

    public BaseIndicatorView setSliderColor(@ColorInt int normalColor, @ColorInt int selectedColor) {
        this.mIndicatorOptions.setSliderColor(normalColor, selectedColor);
        return this;
    }

    public BaseIndicatorView setSliderWidth(float sliderWidth) {
        this.mIndicatorOptions.setSliderWidth(sliderWidth);
        return this;
    }

    public BaseIndicatorView setSliderWidth(float normalSliderWidth, float selectedSliderWidth) {
        this.mIndicatorOptions.setSliderWidth(normalSliderWidth, selectedSliderWidth);
        return this;
    }

    public BaseIndicatorView setSliderGap(float sliderGap) {
        this.mIndicatorOptions.setSliderGap(sliderGap);
        return this;
    }

    public BaseIndicatorView setSlideMode(int slideMode) {
        this.mIndicatorOptions.setSlideMode(slideMode);
        return this;
    }

    public BaseIndicatorView setIndicatorStyle(int indicatorStyle) {
        this.mIndicatorOptions.setIndicatorStyle(indicatorStyle);
        return this;
    }

    public BaseIndicatorView setSliderHeight(float sliderHeight) {
        this.mIndicatorOptions.setSliderHeight(sliderHeight);
        return this;
    }

    public int getPageSize() {
        return this.mIndicatorOptions.getPageSize();
    }

    public int getNormalColor() {
        return this.mIndicatorOptions.getNormalSliderColor();
    }

    public int getCheckedColor() {
        return this.mIndicatorOptions.getCheckedSliderColor();
    }

    public float getIndicatorGap() {
        return this.mIndicatorOptions.getSliderGap();
    }

    public float getSlideProgress() {
        return this.mIndicatorOptions.getSlideProgress();
    }

    public int getCurrentPosition() {
        return this.mIndicatorOptions.getCurrentPosition();
    }

    public int getSlideMode() {
        return this.mIndicatorOptions.getSlideMode();
    }

    public float getNormalSliderWidth() {
        return this.mIndicatorOptions.getNormalSliderWidth();
    }

    public float getCheckedSliderWidth() {
        return this.mIndicatorOptions.getCheckedSliderWidth();
    }

    private void setSlideProgress(float slideProgress) {
        this.mIndicatorOptions.setSlideProgress(slideProgress);
    }

    private void setCurrentPosition(int currentPosition) {
        this.mIndicatorOptions.setCurrentPosition(currentPosition);
    }

    public void setupWithViewPager(ViewPager viewPager) {
        this.mViewPager = viewPager;
        this.notifyDataChanged();
    }

    public IndicatorOptions getIndicatorOptions() {
        return this.mIndicatorOptions;
    }

    public void onPageScrollStateChanged(int state) {
    }

    @Override
    public void setIndicatorOptions(IndicatorOptions indicatorOptions) {
        this.mIndicatorOptions = indicatorOptions;
    }
}

