/*
 * Decompiled with CFR 0.152.
 */
package com.zhouyou.audio.util;

public class Tools {
    public static float calculateValue(int highData, int lowData) {
        return (float)((highData << 8) + lowData) / 100.0f;
    }

    public static String byte2Hex(byte[] data) {
        if (data != null && data.length > 0) {
            StringBuilder sb = new StringBuilder(data.length);
            for (byte tmp : data) {
                sb.append(String.format("%02X ", tmp));
            }
            return sb.toString();
        }
        return "no data";
    }

    public static String byte2Hex(byte data) {
        return String.format("%02X ", data);
    }

    public static byte[] getBooleanArray(byte b) {
        byte[] array = new byte[8];
        for (int i = 7; i >= 0; --i) {
            array[i] = (byte)(b & 1);
            b = (byte)(b >> 1);
        }
        return array;
    }

    public static byte getByteFromBooleanArray(byte[] array) {
        byte bit = 0;
        for (int i = 0; i < array.length; ++i) {
            array[i] = (byte)(array[i] & 1);
            bit = (byte)(bit + (array[i] << array.length - i - 1));
        }
        return bit;
    }

    public static String byteToBit(byte b) {
        return "" + (byte)(b >> 7 & 1) + (byte)(b >> 6 & 1) + " " + (byte)(b >> 5 & 1) + (byte)(b >> 4 & 1) + " " + (byte)(b >> 3 & 1) + (byte)(b >> 2 & 1) + " " + (byte)(b >> 1 & 1) + (byte)(b >> 0 & 1);
    }

    public static String byteToBit(byte b, int length) {
        String bitString = null;
        for (int i = length - 1; i >= 0; --i) {
            bitString = bitString + ((byte)(b >> i) & 1);
            b = (byte)(b >> 1);
        }
        return bitString;
    }

    public static byte[] shortToByte(short number) {
        int temp = number;
        byte[] b = new byte[2];
        for (int i = 0; i < b.length; ++i) {
            b[b.length - 1 - i] = new Integer(temp & 0xFF).byteValue();
            temp >>= 8;
        }
        return b;
    }

    public static short encryptCRC16(byte[] data, long length) {
        int j = 0;
        int crc16 = 65535;
        int i = 0;
        while ((long)i < length) {
            crc16 ^= data[i] & 0xFF;
            for (j = 0; j < 8; ++j) {
                int flags = crc16 & 1;
                if (flags != 0) {
                    crc16 = crc16 >> 1 ^ 0x8408;
                    continue;
                }
                crc16 >>= 1;
            }
            ++i;
        }
        return (short)(~crc16 & 0xFFFF);
    }

    public static short encryptCRC8(byte[] data, long length) {
        int j = 0;
        int crc8 = 65535;
        int i = 0;
        while ((long)i < length) {
            crc8 ^= data[i] & 0xFF;
            for (j = 0; j < 8; ++j) {
                int flags = crc8 & 1;
                if (flags != 0) {
                    crc8 = crc8 >> 1 ^ 0x8408;
                    continue;
                }
                crc8 >>= 1;
            }
            ++i;
        }
        return (short)(~crc8 & 0xFFFF);
    }

    public static long bytes8long(byte[] byteVal) {
        long result = 0L;
        for (int i = 0; i < byteVal.length; ++i) {
            long tmpVal = (long)byteVal[i] << 8 * (7 - i);
            switch (i) {
                case 0: {
                    tmpVal &= 0xFF00000000000000L;
                    break;
                }
                case 1: {
                    tmpVal &= 0xFF000000000000L;
                    break;
                }
                case 2: {
                    tmpVal &= 0xFF0000000000L;
                    break;
                }
                case 3: {
                    tmpVal &= 0xFF00000000L;
                    break;
                }
                case 4: {
                    tmpVal &= 0xFF000000L;
                    break;
                }
                case 5: {
                    tmpVal &= 0xFF0000L;
                    break;
                }
                case 6: {
                    tmpVal &= 0xFF00L;
                    break;
                }
                case 7: {
                    tmpVal &= 0xFFL;
                }
            }
            result |= tmpVal;
        }
        return result;
    }

    public static byte[] long8Bytes(long intValue) {
        byte[] result = new byte[]{(byte)((intValue & 0xFF00000000000000L) >> 56), (byte)((intValue & 0xFF000000000000L) >> 48), (byte)((intValue & 0xFF0000000000L) >> 40), (byte)((intValue & 0xFF00000000L) >> 32), (byte)((intValue & 0xFF000000L) >> 24), (byte)((intValue & 0xFF0000L) >> 16), (byte)((intValue & 0xFF00L) >> 8), (byte)(intValue & 0xFFL)};
        return result;
    }

    public static byte[] integer4Bytes(int intValue) {
        byte[] result = new byte[]{(byte)((intValue & 0xFF000000) >> 24), (byte)((intValue & 0xFF0000) >> 16), (byte)((intValue & 0xFF00) >> 8), (byte)(intValue & 0xFF)};
        return result;
    }

    public static int bytes4Integer(byte[] byteVal) throws Exception {
        int result = 0;
        try {
            for (int i = 0; i < byteVal.length; ++i) {
                int tmpVal = byteVal[i] << 8 * (3 - i);
                switch (i) {
                    case 0: {
                        tmpVal &= 0xFF000000;
                        break;
                    }
                    case 1: {
                        tmpVal &= 0xFF0000;
                        break;
                    }
                    case 2: {
                        tmpVal &= 0xFF00;
                        break;
                    }
                    case 3: {
                        tmpVal &= 0xFF;
                    }
                }
                result |= tmpVal;
            }
        }
        catch (Exception e) {
            throw new Exception("[AnalysisMessage.byte4Integer()->" + e.toString() + "]");
        }
        return result;
    }
}

