/*
 * Decompiled with CFR 0.152.
 */
package com.zhouyou.audio.record;

import android.media.AudioRecord;
import android.os.Process;
import com.zhouyou.audio.base.BaseAudio;
import com.zhouyou.audio.exception.RecorderException;
import com.zhouyou.audio.util.AudioLog;
import com.zhouyou.audio.util.Utils;
import rx.Observable;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action1;

public final class AudioRecorder
extends BaseAudio {
    private AudioRecord mAudioRecord = null;
    public static final int DEFAULT_AUDIOSOURCE = 1;
    public static final int DEFAULT_RATE = 8000;
    public static final int DEFAULT_CHANNELCONFIGURATION = 16;
    public static final int DEFAULT_AUDIOENCODING = 2;
    private int audioSource = 1;
    private int reate = 8000;
    private int channelConfiguration = 16;
    private int audioEncoding = 2;
    private int minBufferSize;
    private int bufferReadResult;
    private int readBufferSzie = 1024;
    private IConnectListener mConnectListener;
    private IAudioDecoder mAudioDecoder;
    private boolean isLog = true;
    private static volatile AudioRecorder singleton = null;
    private boolean mPause;

    private AudioRecorder(Builder builder) {
        this.config(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AudioRecorder getInstance() {
        if (singleton != null) return singleton;
        Class<AudioRecorder> clazz = AudioRecorder.class;
        synchronized (AudioRecorder.class) {
            if (singleton != null) return singleton;
            singleton = new Builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public void newBulder(Builder builder) {
        this.config(builder);
    }

    private void config(Builder builder) {
        this.reate = builder.reate;
        this.channelConfiguration = builder.channelConfiguration;
        this.audioSource = builder.audioSource;
        this.audioEncoding = builder.audioEncoding;
        this.readBufferSzie = builder.readBufferSzie;
        this.mConnectListener = builder.connectListener;
        this.isLog = builder.isLog;
    }

    @Override
    public void doStart() {
        this.print("recorder doStart !!!!!!!!!!!!!");
    }

    private void initAudioRecorder() {
        block11: {
            try {
                this.minBufferSize = AudioRecord.getMinBufferSize((int)this.reate, (int)this.channelConfiguration, (int)this.audioEncoding);
                if (this.minBufferSize == -2 || this.minBufferSize == -1) {
                    if (this.mConnectListener != null) {
                        Observable.just((Object)this.minBufferSize).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Integer>(){

                            public void call(Integer o) {
                                AudioRecorder.this.mConnectListener.onFailure(new RecorderException(o, "initialization err"), o);
                            }
                        });
                    }
                    return;
                }
                this.mAudioRecord = new AudioRecord(this.audioSource, this.reate, this.channelConfiguration, this.audioEncoding, this.minBufferSize * 10);
                int nState = this.mAudioRecord.getState();
                if (nState != 1) {
                    this.mAudioRecord.release();
                    this.mAudioRecord = null;
                    if (this.mConnectListener != null) {
                        Observable.just((Object)nState).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Integer>(){

                            public void call(Integer o) {
                                AudioRecorder.this.mConnectListener.onFailure(new RecorderException(o, "initialization err"), o);
                            }
                        });
                    }
                    return;
                }
                if (this.readBufferSzie <= 0 || this.readBufferSzie > this.minBufferSize) {
                    this.readBufferSzie = this.minBufferSize;
                }
                if ((nState = this.mAudioRecord.getRecordingState()) != 1) {
                    this.mAudioRecord.release();
                    this.mAudioRecord = null;
                    if (this.mConnectListener != null) {
                        Observable.just((Object)nState).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Integer>(){

                            public void call(Integer o) {
                                AudioRecorder.this.mConnectListener.onFailure(new RecorderException(o, "initialization err"), o);
                            }
                        });
                    }
                    return;
                }
                this.mAudioRecord.startRecording();
                while (this.mAudioRecord.getRecordingState() != 3) {
                }
                if (this.mConnectListener != null) {
                    Observable.just((Object)"SUCCESS").observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<String>(){

                        public void call(String o) {
                            AudioRecorder.this.mConnectListener.onSuccess();
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.mConnectListener == null) break block11;
                Observable.just((Object)e).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Exception>(){

                    public void call(Exception e) {
                        AudioRecorder.this.mConnectListener.onFailure(e, -1);
                    }
                });
            }
        }
    }

    @Override
    public void doRun() {
        try {
            Process.setThreadPriority((int)-19);
            this.initAudioRecorder();
            if (this.mAudioDecoder != null) {
                this.mAudioDecoder.startDecoder(this.reate);
            }
            short[] audio_data = new short[this.readBufferSzie];
            while (this.isRuning()) {
                if (this.mPause) {
                    if (this.mAudioDecoder != null) {
                        this.mAudioDecoder.recoderState(this.mPause);
                    }
                    Thread.sleep(100L);
                    continue;
                }
                this.bufferReadResult = this.mAudioRecord.read(audio_data, 0, audio_data.length);
                if (this.bufferReadResult == -3 || this.bufferReadResult == -2) {
                    this.print("bufferReadResult err !!!!!!!!!!!!!");
                    continue;
                }
                if (this.bufferReadResult > 0) {
                    if (this.mAudioDecoder == null) continue;
                    this.mAudioDecoder.decoderData(audio_data, this.bufferReadResult);
                    continue;
                }
                this.print("error: " + this.bufferReadResult);
            }
            if (this.mAudioDecoder != null) {
                this.mAudioDecoder.finishDecoder();
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            this.print("err!!:" + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (this.mAudioRecord != null) {
                try {
                    this.mAudioRecord.stop();
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
                this.mAudioRecord.release();
                this.mAudioRecord = null;
            }
        }
    }

    @Override
    public void doStop() {
        this.print("recorder doStop !!!!!!!!!!!!!");
    }

    public void setAudioDecoder(IAudioDecoder audioDecoder) {
        this.mAudioDecoder = audioDecoder;
    }

    @Override
    public void print(String msg) {
        if (this.isLog) {
            AudioLog.i(msg);
        }
    }

    public void pause() {
        this.mPause = true;
    }

    public void resume() {
        this.mPause = false;
    }

    public static interface IConnectListener {
        public void onSuccess();

        public void onFailure(Exception var1, int var2);
    }

    public static interface IAudioDecoder {
        public void startDecoder(int var1);

        public void decoderData(short[] var1, int var2) throws Exception;

        public void finishDecoder();

        public void recoderState(boolean var1);
    }

    public static final class Builder {
        private int reate = 8000;
        private int channelConfiguration = 16;
        private int audioEncoding = 2;
        private int audioSource = 1;
        private int readBufferSzie;
        private boolean isLog = true;
        private IConnectListener connectListener;

        public Builder isLog(boolean val) {
            this.isLog = val;
            return this;
        }

        public Builder connectListener(IConnectListener connectListener) {
            Utils.checkNotNull(connectListener, "connectListener==null");
            this.connectListener = connectListener;
            return this;
        }

        public Builder audioSource(int val) {
            this.audioSource = val;
            return this;
        }

        public Builder reate(int val) {
            this.reate = val;
            return this;
        }

        public Builder channelConfiguration(int val) {
            this.channelConfiguration = val;
            return this;
        }

        public Builder audioEncoding(int val) {
            this.audioEncoding = val;
            return this;
        }

        public Builder readBufferSzie(int val) {
            this.readBufferSzie = val;
            return this;
        }

        public AudioRecorder build() {
            return new AudioRecorder(this);
        }
    }
}

