/*
 * Decompiled with CFR 0.152.
 */
package com.zhouyou.audio.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import java.lang.ref.WeakReference;

public class HeadsetPlugReceiver
extends BroadcastReceiver {
    private static HeadsetPlugReceiver headPlugReceiver;
    private WeakReference<Context> contextWeakReference;
    private HeadsetJackStateLisentener headsetJackStateLisentener;
    private boolean isLinked;

    public static HeadsetPlugReceiver getInstance(Context context) {
        if (headPlugReceiver == null) {
            headPlugReceiver = new HeadsetPlugReceiver(context);
        }
        return headPlugReceiver;
    }

    private HeadsetPlugReceiver(Context context) {
        this.contextWeakReference = new WeakReference<Context>(context);
    }

    public boolean isLinked() {
        return this.isLinked;
    }

    public void onReceive(Context context, Intent intent) {
        if (intent.hasExtra("state") && intent.getIntExtra("state", 0) == 1) {
            this.isLinked = true;
            if (this.headsetJackStateLisentener != null) {
                this.headsetJackStateLisentener.haveDevice();
            }
        }
        if ("android.media.AUDIO_BECOMING_NOISY".equals(intent.getAction())) {
            this.isLinked = false;
            if (this.headsetJackStateLisentener != null) {
                this.headsetJackStateLisentener.haveNoDevice();
            }
        }
    }

    public void registerHeadSetReceiver() {
        if (this.contextWeakReference.get() == null) {
            return;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.HEADSET_PLUG");
        intentFilter.addAction("android.media.AUDIO_BECOMING_NOISY");
        ((Context)this.contextWeakReference.get()).registerReceiver((BroadcastReceiver)headPlugReceiver, intentFilter);
    }

    public void unregisterHeadSetReceiver() {
        if (this.contextWeakReference.get() == null) {
            return;
        }
        ((Context)this.contextWeakReference.get()).unregisterReceiver((BroadcastReceiver)headPlugReceiver);
    }

    public void setHeadsetJackStateLisentener(HeadsetJackStateLisentener headsetJackStateLisentener) {
        this.headsetJackStateLisentener = headsetJackStateLisentener;
    }

    public static interface HeadsetJackStateLisentener {
        public void haveDevice();

        public void haveNoDevice();
    }
}

