/*
 * Decompiled with CFR 0.152.
 */
package com.zhouyou.audio.power;

import android.media.AudioTrack;
import com.zhouyou.audio.base.BaseAudio;
import com.zhouyou.audio.record.AudioRecorder;
import com.zhouyou.audio.util.AudioLog;
import com.zhouyou.audio.util.Channel;
import com.zhouyou.audio.util.SinWave;

public final class PowerSupply
extends BaseAudio {
    public static final int DEFAULT_SAMPLERATEINHZ = 44100;
    public static final int DEFAULT_CHANNELCONFIG = 4;
    public static final int DEFAULT_AUDIOFORMAT = 2;
    public static final int DEFAULT_STREAMTYPE = 3;
    public static final int DEFAULT_MODE = 0;
    private AudioTrack audioTrack = null;
    private int minBufferSize;
    private int streamType = 3;
    private int sampleRate = 44100;
    private int channelConfig = 4;
    private int audioFormat = 2;
    private int sin_rate;
    private Channel channel = Channel.RIGHT;
    private boolean isLog = true;
    private static volatile PowerSupply singleton = null;

    private PowerSupply(Builder builder) {
        this.config(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PowerSupply getInstance() {
        if (singleton != null) return singleton;
        Class<AudioRecorder> clazz = AudioRecorder.class;
        synchronized (AudioRecorder.class) {
            if (singleton != null) return singleton;
            singleton = new Builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public void newBulder(Builder builder) {
        this.config(builder);
    }

    private void config(Builder builder) {
        this.isLog = builder.isLog;
        this.streamType = builder.streamType;
        this.sampleRate = builder.sampleRate;
        this.channelConfig = builder.channelConfig;
        this.audioFormat = builder.audioFormat;
        this.sin_rate = builder.sin_rate;
        this.channel = builder.channel;
    }

    public void setpowerRate(int sin_rate) {
        this.sin_rate = sin_rate;
    }

    @Override
    protected void doStart() {
        this.print("PowerSupply doStart!!!!!!!!!!!!!");
        this.trackStop();
        if (this.sin_rate < 0) {
            throw new IllegalStateException("please Set positive wave frequency!!! sin_rate<0");
        }
        this.minBufferSize = AudioTrack.getMinBufferSize((int)this.sampleRate, (int)this.channelConfig, (int)this.audioFormat);
        if (this.minBufferSize == -2 || this.minBufferSize == -1) {
            return;
        }
        int numSamples = this.sampleRate;
        this.audioTrack = new AudioTrack(this.streamType, this.sampleRate, this.channelConfig, this.audioFormat, numSamples, 0);
        int state = this.audioTrack.getPlayState();
        if (state != 1) {
            this.audioTrack.release();
            this.audioTrack = null;
            return;
        }
        try {
            byte[] wave = SinWave.sin(this.sin_rate, this.sampleRate, numSamples);
            this.audioTrack.write(wave, 0, numSamples * 2);
            this.audioTrack.flush();
            this.setChannel(this.channel);
            this.audioTrack.setLoopPoints(0, numSamples / 2, -1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void doStop() {
        this.print("PowerSupply doStop!!!!!!!!!!!!!");
        this.trackStop();
    }

    private void trackStop() {
        if (this.audioTrack != null) {
            try {
                this.audioTrack.stop();
                this.audioTrack.release();
                this.audioTrack = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void doRun() {
        try {
            if (this.audioTrack != null) {
                this.audioTrack.play();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setChannel(Channel channel) {
        if (this.audioTrack != null) {
            switch (channel) {
                case LEFT: {
                    this.audioTrack.setStereoVolume(AudioTrack.getMaxVolume(), AudioTrack.getMinVolume());
                    break;
                }
                case RIGHT: {
                    this.audioTrack.setStereoVolume(AudioTrack.getMinVolume(), AudioTrack.getMaxVolume());
                    break;
                }
                case DOUBLE: {
                    this.audioTrack.setStereoVolume(AudioTrack.getMaxVolume(), AudioTrack.getMaxVolume());
                }
            }
        }
    }

    @Override
    public void print(String msg) {
        if (this.isLog) {
            AudioLog.i(msg);
        }
    }

    public static final class Builder {
        private boolean isLog = true;
        private int streamType = 3;
        private int sampleRate = 44100;
        private int channelConfig = 4;
        private int audioFormat = 2;
        private int sin_rate;
        private Channel channel = Channel.RIGHT;

        public Builder isLog(boolean isLog) {
            this.isLog = isLog;
            return this;
        }

        public Builder streamType(int streamType) {
            this.streamType = streamType;
            return this;
        }

        public Builder sampleRate(int rate) {
            this.sampleRate = rate;
            return this;
        }

        public Builder channelConfig(int channelConfig) {
            this.channelConfig = channelConfig;
            return this;
        }

        public Builder audioFormat(int audioFormat) {
            this.audioFormat = audioFormat;
            return this;
        }

        public Builder powerRate(int sin_rate) {
            this.sin_rate = sin_rate;
            return this;
        }

        public Builder channel(Channel val) {
            this.channel = val;
            return this;
        }

        public PowerSupply build() {
            return new PowerSupply(this);
        }
    }
}

