/*
 * Decompiled with CFR 0.152.
 */
package com.zhouyou.audio.exception;

import com.zhouyou.audio.exception.PlayException;
import com.zhouyou.audio.exception.ReceiveException;
import com.zhouyou.audio.util.AudioLog;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public class RetryWhenProcess
implements Func1<Observable<? extends Throwable>, Observable<?>> {
    private int count = 3;
    private long delay = 500L;

    public RetryWhenProcess() {
    }

    public RetryWhenProcess(int count, long delay) {
        this.count = count;
        this.delay = delay;
    }

    public Observable<?> call(Observable<? extends Throwable> observable) {
        return observable.zipWith(Observable.range((int)1, (int)this.count), (Func2)new Func2<Throwable, Integer, Wrapper>(){

            public Wrapper call(Throwable throwable, Integer integer) {
                return new Wrapper(throwable, integer);
            }
        }).flatMap((Func1)new Func1<Wrapper, Observable<Long>>(){

            public Observable<Long> call(Wrapper wrapper) {
                AudioLog.i("#######\u91cd\u8bd5\u6b21\u6570\uff1a" + wrapper.index + " err:" + wrapper.throwable.getMessage());
                if ((wrapper.throwable instanceof PlayException || wrapper.throwable instanceof ReceiveException || wrapper.throwable instanceof TimeoutException) && wrapper.index < RetryWhenProcess.this.count) {
                    return Observable.timer((long)RetryWhenProcess.this.delay, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                return Observable.error((Throwable)wrapper.throwable);
            }
        });
    }

    private class Wrapper {
        private int index;
        private Throwable throwable;

        public Wrapper(Throwable throwable, int index) {
            this.index = index;
            this.throwable = throwable;
        }
    }
}

