/*
 * Decompiled with CFR 0.152.
 */
package com.zhouyou.audio.base;

import com.zhouyou.audio.base.IAudio;
import com.zhouyou.audio.util.AudioLog;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class BaseAudio
implements Runnable,
IAudio {
    private boolean isRun = false;
    private boolean isLog = true;
    private final ReadWriteLock mLock = new ReentrantReadWriteLock();
    private Thread mThread;

    @Override
    public final void start() {
        this.mLock.readLock().lock();
        try {
            if (this.isRun) {
                this.print("Already running!!!!!!!!!!!");
                return;
            }
            this.doStart();
            this.mThread = new Thread(this);
            this.mThread.start();
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    @Override
    public final void stop() {
        this.mLock.readLock().lock();
        try {
            if (!this.isRun) {
                this.print("Already stop!!!!!!!!!!!");
                return;
            }
            this.isRun = false;
            this.doStop();
            this.mThread.join(150L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    @Override
    public final boolean isRuning() {
        return this.isRun;
    }

    public void print(String msg) {
        if (this.isLog) {
            AudioLog.i(msg);
        }
    }

    @Override
    public final void run() {
        this.isRun = true;
        this.doRun();
    }

    protected abstract void doStart();

    protected abstract void doStop();

    protected abstract void doRun();
}

