/*
 * Decompiled with CFR 0.152.
 */
package com.zhouyou.audio;

import com.zhouyou.audio.base.ICallBack;
import com.zhouyou.audio.decoder.AbstractDecoder;
import com.zhouyou.audio.decoder.DecoderResult;
import com.zhouyou.audio.decoder.IDecoderCallBack;
import com.zhouyou.audio.exception.ReceiveException;
import com.zhouyou.audio.exception.RetryWhenProcess;
import com.zhouyou.audio.power.PowerSupply;
import com.zhouyou.audio.record.AudioRecorder;
import com.zhouyou.audio.track.RxAudioPlayer;
import com.zhouyou.audio.util.AudioLog;
import com.zhouyou.audio.util.Channel;
import com.zhouyou.audio.util.RxSchedulers;
import com.zhouyou.audio.util.SimpleSubscribe;
import com.zhouyou.audio.util.Utils;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;

public final class RxAudio {
    private static AudioRecorder.Builder mRecorderBuilder;
    private static PowerSupply.Builder mPowerBuilder;
    private static RxAudioPlayer.Builder mAudioPlayerBuilder;
    private static AudioRecorder mAudioRecorder;
    private static PowerSupply mPowerSupply;
    private static RxAudioPlayer mAudioPlayer;
    private static volatile RxAudio singleton;
    private static int retryCount;
    private static int retryDelay;
    private static int receiveTimeOut;
    private static boolean isLog;
    private static RxAudioPlayer.IAudioEncoder audioEncoder;
    private static AbstractDecoder abstractDecoder;
    private static AudioRecorder.IConnectListener recorderConnectListener;
    private boolean isGetRes = false;
    private boolean isSending = false;
    private DecoderResult mReceiveResult;
    private Subscription mSubscription;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RxAudio getInstance() {
        if (singleton != null) return singleton;
        Class<RxAudio> clazz = RxAudio.class;
        synchronized (RxAudio.class) {
            if (singleton != null) return singleton;
            singleton = new RxAudio();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private RxAudio() {
        mRecorderBuilder = new AudioRecorder.Builder().reate(44100).audioEncoding(2).audioSource(1).channelConfiguration(2);
        mPowerBuilder = new PowerSupply.Builder().sampleRate(48000).channelConfig(4).audioFormat(2).channel(Channel.RIGHT).powerRate(20050);
        mAudioPlayerBuilder = new RxAudioPlayer.Builder().streamType(3).rate(8000).channelConfig(4).audioFormat(2).channel(Channel.LEFT).mode(0);
        mRecorderBuilder.connectListener(recorderConnectListener);
        mRecorderBuilder.isLog(isLog);
        mPowerBuilder.isLog(isLog);
        mAudioPlayerBuilder.isLog(isLog);
        mAudioRecorder = mRecorderBuilder.build();
        mPowerSupply = mPowerBuilder.build();
        mAudioPlayer = mAudioPlayerBuilder.build();
        if (abstractDecoder != null) {
            IDecoderCallBack callBack = abstractDecoder.getReceiveCallBack();
            if (callBack != null) {
                abstractDecoder.setReceiveCallBack(new BaseReceiveCallBack(callBack));
            }
            mAudioRecorder.setAudioDecoder(abstractDecoder);
        }
        if (audioEncoder != null) {
            mAudioPlayer.setIAudioEncoder(audioEncoder);
        }
    }

    public static void init(AudioConfig config) {
        Utils.checkIllegalArgument(config, "config ==null");
        if (config.receiveTimeOut < 0) {
            throw new IllegalArgumentException("receiveTimeOut<0");
        }
        if (config.retryCount < 1) {
            throw new IllegalArgumentException("retryCount<1");
        }
        if (config.retryDelay < 0) {
            throw new IllegalArgumentException("retryDelay<0");
        }
        abstractDecoder = config.abstractDecoder;
        receiveTimeOut = config.receiveTimeOut;
        retryCount = config.retryCount;
        retryDelay = config.retryDelay;
        isLog = config.isLog;
        audioEncoder = config.audioEncoder;
        recorderConnectListener = config.recorderConnectListener;
    }

    public RxAudio setAbstractDecoder(AbstractDecoder abstractDecoder) {
        Utils.checkIllegalArgument(abstractDecoder, "abstractDecoder ==null");
        IDecoderCallBack callBack = abstractDecoder.getReceiveCallBack();
        if (callBack != null) {
            abstractDecoder.setReceiveCallBack(new BaseReceiveCallBack(callBack));
        }
        mAudioRecorder.setAudioDecoder(abstractDecoder);
        return this;
    }

    public RxAudio setAudioEncoder(RxAudioPlayer.IAudioEncoder audioEncoder) {
        Utils.checkIllegalArgument(audioEncoder, "audioEncoder ==null");
        mAudioPlayer.setIAudioEncoder(audioEncoder);
        return this;
    }

    public RxAudio setReceiveCallBack(IDecoderCallBack callBack) {
        abstractDecoder.setReceiveCallBack(new BaseReceiveCallBack(callBack));
        return this;
    }

    public void startRecord() {
        mAudioRecorder.start();
        abstractDecoder.start();
    }

    public void pasuseRecord() {
        mAudioRecorder.pause();
    }

    public void resumeRecord() {
        mAudioRecorder.resume();
    }

    public void stopRecord() {
        abstractDecoder.stop();
        mAudioRecorder.stop();
    }

    public void startPower() {
        mPowerSupply.start();
    }

    public void stopPower() {
        mPowerSupply.stop();
    }

    public void setPowerRate(int sin_rate) {
        mPowerSupply.setpowerRate(sin_rate);
    }

    public void send(byte[] datas) {
        mAudioPlayer.rxSend(datas).subscribe((Action1)new Action1<Boolean>(){

            public void call(Boolean aBoolean) {
                RxAudio.this.print("send success!!!");
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                RxAudio.this.print("send err!!!" + throwable.getMessage());
            }
        });
    }

    public void send(byte[] datas, final ICallBack callBack) {
        if (this.isSending) {
            this.print("Already sending!!!!!!!!!!!");
            return;
        }
        this.isSending = true;
        this.mSubscription = this.rxSend(datas).doOnTerminate(new Action0(){

            public void call() {
                mAudioPlayer.stop();
                RxAudio.this.isSending = false;
            }
        }).subscribe((Action1)new Action1<DecoderResult>(){

            public void call(DecoderResult receiveResult) {
                if (receiveResult.code == 0) {
                    callBack.onSuccess(receiveResult.data);
                } else {
                    callBack.onFailure(new Throwable(receiveResult.errMsg));
                }
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                callBack.onFailure(throwable);
            }
        });
    }

    public void cancleSend() {
        this.isSending = false;
        if (this.mSubscription != null && !this.mSubscription.isUnsubscribed()) {
            this.mSubscription.unsubscribe();
        }
    }

    private Observable<DecoderResult> rxSend(final byte[] datas) {
        this.isGetRes = false;
        return Observable.create((Observable.OnSubscribe)new SimpleSubscribe<DecoderResult>(){

            @Override
            public DecoderResult execute() throws Throwable {
                boolean result = mAudioPlayer.send(datas);
                RxAudio.this.print("send result:" + result);
                int timeIndex = 0;
                while (!RxAudio.this.isGetRes && timeIndex * 50 < receiveTimeOut) {
                    Thread.sleep(50L);
                    ++timeIndex;
                }
                if (RxAudio.this.mReceiveResult != null && ((RxAudio)RxAudio.this).mReceiveResult.code != 0) {
                    throw new ReceiveException(((RxAudio)RxAudio.this).mReceiveResult.code, ((RxAudio)RxAudio.this).mReceiveResult.errMsg);
                }
                return RxAudio.this.mReceiveResult;
            }
        }).timeout((long)receiveTimeOut, TimeUnit.MILLISECONDS).retryWhen((Func1)new RetryWhenProcess(retryCount, retryDelay)).compose(RxSchedulers._io_main());
    }

    public void exitAudio() {
        this.stopRecord();
        this.stopPower();
        System.gc();
    }

    public void print(String msg) {
        if (isLog) {
            AudioLog.i(msg);
        }
    }

    static {
        singleton = null;
        retryCount = 1;
        retryDelay = 100;
        receiveTimeOut = 2000;
    }

    public static final class AudioConfig {
        private int retryCount = 0;
        private int retryDelay = 100;
        private int receiveTimeOut = 500;
        private boolean isLog;
        private RxAudioPlayer.IAudioEncoder audioEncoder;
        private AbstractDecoder abstractDecoder;
        private AudioRecorder.IConnectListener recorderConnectListener;

        public AudioConfig recordBuilder(AudioRecorder.Builder builder) {
            mRecorderBuilder = builder;
            return this;
        }

        public AudioConfig trackBuilder(RxAudioPlayer.Builder builder) {
            mAudioPlayerBuilder = builder;
            return this;
        }

        public AudioConfig powerBuilder(PowerSupply.Builder builder) {
            mPowerBuilder = builder;
            return this;
        }

        public AudioConfig retryCount(int retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public AudioConfig retryDelay(int retryDelay) {
            this.retryDelay = retryDelay;
            return this;
        }

        public AudioConfig receiveTimeOut(int timeOut) {
            this.receiveTimeOut = timeOut;
            return this;
        }

        public AudioConfig isLog(boolean log) {
            this.isLog = log;
            return this;
        }

        public AudioConfig audioEncoder(RxAudioPlayer.IAudioEncoder audioEncoder) {
            this.audioEncoder = audioEncoder;
            return this;
        }

        public AudioConfig audioDecoder(AbstractDecoder audioDecoder) {
            this.abstractDecoder = audioDecoder;
            return this;
        }

        public AudioConfig recorderConnectListener(AudioRecorder.IConnectListener recorderConnectListener) {
            this.recorderConnectListener = recorderConnectListener;
            return this;
        }
    }

    private class BaseReceiveCallBack
    implements IDecoderCallBack {
        private IDecoderCallBack callBack;

        public BaseReceiveCallBack(IDecoderCallBack callBack) {
            this.callBack = callBack;
        }

        @Override
        public void callResult(DecoderResult result) {
            RxAudio.this.isGetRes = true;
            RxAudio.this.mReceiveResult = result;
            if (this.callBack != null) {
                this.callBack.callResult(result);
            }
        }
    }
}

