package com.zhouyou.audio.util;

public class Tools {

    public static float calculateValue(int highData, int lowData) {
        return ((highData << 8) + lowData) / 100.0f;
    }
    
    /**
     * 字节转十六进制 为相应的字符串显示
     *
     * @param data
     * @return
     */
    public static String byte2Hex(byte data[]) {
        if (data != null && data.length > 0) {
            StringBuilder sb = new StringBuilder(data.length);
            for (byte tmp : data) {
                sb.append(String.format("%02X ", tmp));
            }
            return sb.toString();
        }
        return "no data";
    }

    /**
     * 字节转十六进制 为相应的字符串显示
     *
     * @param data
     * @return
     */
    public static String byte2Hex(byte data) {
        return String.format("%02X ", data);
    }

    /**
     * 将byte转换为一个长度为8的byte数组，数组每个值代表bit
     */
    public static byte[] getBooleanArray(byte b) {
        byte[] array = new byte[8];
        for (int i = 7; i >= 0; i--) {
            array[i] = (byte) (b & 1);
            b = (byte) (b >> 1);
        }
        return array;
    }

    /**
     * 把byte转为bit
     *
     * @param array
     * @return
     */
    public static byte getByteFromBooleanArray(byte[] array) {
        byte bit = 0;
        for (int i = 0; i < array.length; i++) {
            array[i] = (byte) (array[i] & 0x1);
            bit += (array[i] << (array.length - i - 1));
        }
        // bit = (byte) (bit + 127);
        return bit;
    }

    /**
     * 把byte转为字符串的bit
     */
    public static String byteToBit(byte b) {
        return "" + (byte) ((b >> 7) & 0x1) + (byte) ((b >> 6) & 0x1) + " "
                + (byte) ((b >> 5) & 0x1) + (byte) ((b >> 4) & 0x1) + " "
                + (byte) ((b >> 3) & 0x1) + (byte) ((b >> 2) & 0x1) + " "
                + (byte) ((b >> 1) & 0x1) + (byte) ((b >> 0) & 0x1);
    }

    /**
     * 把byte转为字符串的bit
     *
     * @param b
     * @param length
     * @return
     */
    public static String byteToBit(byte b, int length) {

        String bitString = null;
        for (int i = (length - 1); i >= 0; i--) {
            bitString += (byte) (b >> i) & 0x1;
            b = (byte) (b >> 1);
        }
        return bitString;
    }


    /**
     * 短整形转化为2字节 test ok
     */
    public static byte[] shortToByte(short number) {
        int temp = number;
        byte[] b = new byte[2];
        for (int i = 0; i < b.length; i++) {
            b[b.length - 1 - i] = new Integer(temp & 0xff).byteValue();//

            temp = temp >> 8;
        }
        return b;
    }

    /**
     * CRC16/X25校验
     *
     * @param data
     * @param length
     * @return
     */
    public static short encryptCRC16(byte[] data, long length) {
        int j = 0;
        int crc16 = 0x0000FFFF;
        for (int i = 0; i < length; i++) {
            crc16 ^= data[i] & 0x000000FF;
            for (j = 0; j < 8; j++) {
                int flags = crc16 & 0x00000001;
                if (flags != 0) {
                    crc16 = (crc16 >> 1) ^ 0x8408;
                } else {
                    crc16 >>= 0x01;
                }
            }
        }
        return (short) (~crc16 & 0x0000FFFF);
    }
    
    /**
     * CRC8/X25校验
     *
     * @param data
     * @param length
     * @return
     */
    public static short encryptCRC8(byte[] data, long length) {
        int j = 0;
        int crc8 = 0x0000FFFF;
        for (int i = 0; i < length; i++) {
            crc8 ^= data[i] & 0x000000FF;
            for (j = 0; j < 8; j++) {
                int flags = crc8 & 0x00000001;
                if (flags != 0) {
                    crc8 = (crc8 >> 1) ^ 0x8408;
                } else {
                    crc8 >>= 0x01;
                }
            }
        }
        return (short) (~crc8 & 0x0000FFFF);
    }


    /**
     * 8个byte转化成一个长整型
     * test ok
     */
    public static long bytes8long(byte[] byteVal) {
        long result = 0;
        for (int i = 0; i < byteVal.length; i++) {
            long tmpVal = ((long) byteVal[i] << (8 * (7 - i))); //这里必须对每个字节内容进行强转，否则系统会自己当INT来计算

            switch (i) {
                case 0:
                    tmpVal = tmpVal & 0xFF00000000000000l;
                    break;
                case 1:
                    tmpVal = tmpVal & 0x00FF000000000000l;
                    break;
                case 2:
                    tmpVal = tmpVal & 0x0000FF0000000000l;
                    break;
                case 3:
                    tmpVal = tmpVal & 0x000000FF00000000l;
                    break;
                case 4:
                    tmpVal = tmpVal & 0x00000000FF000000l;
                    break;
                case 5:
                    tmpVal = tmpVal & 0x0000000000FF0000l;
                    break;
                case 6:
                    tmpVal = tmpVal & 0x000000000000FF00l;
                    break;
                case 7:
                    tmpVal = tmpVal & 0x00000000000000FFl;
                    break;

            }
            result = result | tmpVal;
        }
        return result;
    }


    /**
     * 长整形转化为8个byte
     * test ok
     */
    public static byte[] long8Bytes(long intValue) {
        byte[] result = new byte[8];
        result[0] = (byte) ((intValue & 0xFF00000000000000l) >> 56);
        result[1] = (byte) ((intValue & 0x00FF000000000000l) >> 48);
        result[2] = (byte) ((intValue & 0x0000FF0000000000l) >> 40);
        result[3] = (byte) ((intValue & 0x000000FF00000000l) >> 32);
        result[4] = (byte) ((intValue & 0x00000000FF000000l) >> 24);
        result[5] = (byte) ((intValue & 0x0000000000FF0000l) >> 16);
        result[6] = (byte) ((intValue & 0x000000000000FF00l) >> 8);
        result[7] = (byte) ((intValue & 0x00000000000000FFl));
        return result;
    }

    /**
     * 一个整型转化成4个byte
     */
    public static byte[] integer4Bytes(int intValue) {
        byte[] result = new byte[4];

        result[0] = (byte) ((intValue & 0xFF000000) >> 24);
        result[1] = (byte) ((intValue & 0x00FF0000) >> 16);
        result[2] = (byte) ((intValue & 0x0000FF00) >> 8);
        result[3] = (byte) ((intValue & 0x000000FF));

        return result;
    }

    /**
     * 4个byte转化成一个整型
     */
    public static int bytes4Integer(byte[] byteVal) throws Exception {
        int result = 0;
        try {
            for (int i = 0; i < byteVal.length; i++) {
                int tmpVal = (byteVal[i] << (8 * (3 - i)));
                switch (i) {
                    case 0:
                        tmpVal = tmpVal & 0xFF000000;
                        break;
                    case 1:
                        tmpVal = tmpVal & 0x00FF0000;
                        break;
                    case 2:
                        tmpVal = tmpVal & 0x0000FF00;
                        break;
                    case 3:
                        tmpVal = tmpVal & 0x000000FF;
                        break;
                }
                result = result | tmpVal;
            }
        } catch (Exception e) {
            throw new Exception("[AnalysisMessage.byte4Integer()->" + e.toString() + "]");
        }
        return result;
    }
}
