/*
 * Decompiled with CFR 0.152.
 */
package com.zhouyou.audio.util;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import com.zhouyou.audio.util.AudioLog;

public class AudioVolume {
    private static AudioVolume instance;
    private AudioManager mAudioManager;
    private Context mContext;
    private int max;
    private int current;

    private AudioVolume(Context context) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.current = this.mAudioManager.getStreamVolume(3);
    }

    public static AudioVolume getInstance(Context context) {
        if (instance == null) {
            instance = new AudioVolume(context);
        }
        return instance;
    }

    public void volumeNormal() {
        this.mAudioManager.setRingerMode(2);
    }

    public void volumeVibrate() {
        this.mAudioManager.setRingerMode(1);
    }

    public void volumeSilent() {
        this.mAudioManager.setRingerMode(0);
    }

    public void volumeUp() {
        this.mAudioManager.adjustVolume(1, 0);
    }

    public void volumeDown() {
        this.mAudioManager.adjustVolume(-1, 0);
    }

    public void volumeMax() {
        this.max = this.mAudioManager.getStreamMaxVolume(3);
        this.current = this.mAudioManager.getStreamVolume(3);
        AudioLog.i("max : " + this.max + " current : " + this.current);
        this.mAudioManager.setStreamVolume(3, this.max, 0);
        if (Build.VERSION.SDK_INT >= 18 && this.mAudioManager.getStreamVolume(3) < this.max) {
            this.mAudioManager.setStreamVolume(3, this.max, 1);
        }
    }

    public void volumeRecover() {
        this.mAudioManager.setStreamVolume(3, this.current, 0);
    }
}

