/*
 * Decompiled with CFR 0.152.
 */
package com.zhouyou.audio.track;

import android.media.AudioTrack;
import com.zhouyou.audio.exception.PlayException;
import com.zhouyou.audio.exception.RetryWhenProcess;
import com.zhouyou.audio.record.AudioRecorder;
import com.zhouyou.audio.util.AudioLog;
import com.zhouyou.audio.util.Channel;
import com.zhouyou.audio.util.RxSchedulers;
import com.zhouyou.audio.util.SimpleSubscribe;
import com.zhouyou.audio.util.Utils;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import rx.Observable;
import rx.functions.Func1;

public final class RxAudioPlayer {
    public static final int DEFAULT_SAMPLERATEINHZ = 8000;
    public static final int DEFAULT_CHANNELCONFIG = 4;
    public static final int DEFAULT_AUDIOFORMAT = 2;
    public static final int DEFAULT_STREAMTYPE = 3;
    public static final int DEFAULT_MODE = 0;
    private AudioTrack audioTrack = null;
    private int minBufferSize;
    private int mode = 0;
    private int streamType = 3;
    private int rate = 8000;
    private int channelConfig = 4;
    private int audioFormat = 2;
    private int blocksize_buf;
    private IAudioEncoder mIAudioEncoder;
    private boolean isLog = true;
    private boolean isPlay;
    private final ReadWriteLock mLock = new ReentrantReadWriteLock();
    private Channel channel = Channel.LEFT;
    private static volatile RxAudioPlayer singleton = null;

    private RxAudioPlayer(Builder builder) {
        this.config(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RxAudioPlayer getInstance() {
        if (singleton != null) return singleton;
        Class<AudioRecorder> clazz = AudioRecorder.class;
        synchronized (AudioRecorder.class) {
            if (singleton != null) return singleton;
            singleton = new Builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public void newBulder(Builder builder) {
        this.config(builder);
    }

    private void config(Builder builder) {
        this.streamType = builder.streamType;
        this.rate = builder.rate;
        this.channelConfig = builder.channelConfig;
        this.audioFormat = builder.audioFormat;
        this.blocksize_buf = builder.blocksize_buf;
        this.channel = builder.channel;
        this.mode = builder.mode;
        this.isLog = builder.isLog;
    }

    private void iniAudioTrack() {
        try {
            this.minBufferSize = AudioTrack.getMinBufferSize((int)this.rate, (int)this.channelConfig, (int)this.audioFormat);
            if (this.minBufferSize == -2 || this.minBufferSize == -1) {
                throw new PlayException(this.minBufferSize, "initialization failed!!!");
            }
            int blocksize_size = (this.blocksize_buf > this.minBufferSize ? this.blocksize_buf : this.minBufferSize) * 2;
            this.audioTrack = new AudioTrack(this.streamType, this.rate, this.channelConfig, this.audioFormat, blocksize_size, this.mode);
            this.print("blocksize_size:" + blocksize_size);
            if (this.audioTrack.getPlayState() != 1) {
                this.audioTrack.release();
                this.audioTrack = null;
                throw new PlayException(this.audioTrack.getPlayState(), "initialization failed!!!");
            }
        }
        catch (Exception e) {
            throw new PlayException(-1, "initialization failed!!!");
        }
    }

    public Observable<Boolean> rxSend(final byte[] datas) {
        return Observable.create((Observable.OnSubscribe)new SimpleSubscribe<Boolean>(){

            @Override
            public Boolean execute() throws Throwable {
                return RxAudioPlayer.this.send(datas);
            }
        }).compose(RxSchedulers._io_main());
    }

    public Observable<Boolean> rxSend(byte[] datas, int retryCount, long retryDelay) {
        if (retryCount < 1) {
            throw new IllegalArgumentException("retryCount<1");
        }
        if (retryDelay < 0L) {
            throw new IllegalArgumentException("retryDelay<0");
        }
        return this.rxSend(datas).retryWhen((Func1)new RetryWhenProcess(retryCount, 0x10101CCL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(byte[] data) {
        this.mLock.readLock().lock();
        try {
            this.print("Thread name:" + Thread.currentThread().getName());
            if (this.isPlay) {
                this.print("send Already running!!!!!!!!!!!");
                boolean bl = false;
                return bl;
            }
            this.isPlay = true;
            this.stop();
            boolean isSend = this.play(data);
            this.mIAudioEncoder.finishEncoder();
            boolean bl = isSend;
            return bl;
        }
        finally {
            this.isPlay = false;
            this.mLock.readLock().unlock();
        }
    }

    private boolean play(byte[] datas) {
        if (this.mIAudioEncoder == null) {
            Utils.checkNotNull(this.mIAudioEncoder, "mIAudioEncoder == null");
        }
        byte[] sendData = datas;
        this.mIAudioEncoder.startEncoder(this.rate);
        byte[] encoderData = this.mIAudioEncoder.encoderData(sendData);
        if (encoderData == null || encoderData.length == 0) {
            Utils.checkNotNull(encoderData, "encoderData == null or encoderData len == 0");
        }
        this.print("encodeData len :" + encoderData.length + "," + Arrays.toString(encoderData));
        if (this.mode == 0) {
            int resert_buf = this.blocksize_buf;
            if (encoderData.length > this.blocksize_buf) {
                this.blocksize_buf = encoderData.length;
            }
            this.iniAudioTrack();
            int writeReslut = this.audioTrack.write(encoderData, 0, encoderData.length);
            this.audioTrack.flush();
            this.setChannel(this.channel);
            this.audioTrack.play();
            this.blocksize_buf = resert_buf;
            if (writeReslut == encoderData.length) {
                this.print("write success!!!!" + writeReslut);
                return true;
            }
            throw new PlayException(-1, "Play failed !!!" + writeReslut);
        }
        if (this.mode == 1) {
            this.iniAudioTrack();
            this.audioTrack.play();
            int length = encoderData.length / datas.length;
            if (this.minBufferSize < length && this.blocksize_buf < length) {
                throw new IllegalStateException("blocksize_buf is too small!!!");
            }
            boolean isSend = false;
            for (int i = 0; i < datas.length; ++i) {
                int writeReslut = this.audioTrack.write(encoderData, i * length, length);
                if (writeReslut != length) {
                    throw new PlayException(-1, "Play failed !!!" + writeReslut);
                }
                isSend = true;
                this.print("writeReslut :" + writeReslut);
            }
            this.print("write success!!!!");
            return isSend;
        }
        return false;
    }

    public void setIAudioEncoder(IAudioEncoder IAudioEncoder2) {
        this.mIAudioEncoder = IAudioEncoder2;
    }

    public boolean isPlay() {
        return this.isPlay;
    }

    public void print(String msg) {
        if (this.isLog) {
            AudioLog.i(msg);
        }
    }

    public void stop() {
        try {
            if (this.audioTrack != null) {
                this.audioTrack.stop();
                this.audioTrack.release();
                this.audioTrack = null;
            }
        }
        catch (Exception e) {
            this.print("Exception:" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setChannel(Channel channel) {
        if (this.audioTrack != null) {
            switch (channel) {
                case LEFT: {
                    this.audioTrack.setStereoVolume(AudioTrack.getMaxVolume(), AudioTrack.getMinVolume());
                    break;
                }
                case RIGHT: {
                    this.audioTrack.setStereoVolume(AudioTrack.getMinVolume(), AudioTrack.getMaxVolume());
                    break;
                }
                case DOUBLE: {
                    this.audioTrack.setStereoVolume(AudioTrack.getMaxVolume(), AudioTrack.getMaxVolume());
                }
            }
        }
    }

    public static interface IAudioEncoder {
        public void startEncoder(int var1);

        public byte[] encoderData(byte[] var1);

        public void finishEncoder();
    }

    public static final class Builder {
        private int streamType = 3;
        private int rate = 8000;
        private int channelConfig = 4;
        private int audioFormat = 2;
        private int blocksize_buf = 1024;
        private int mode = 0;
        private Channel channel = Channel.LEFT;
        private boolean isLog = true;

        public Builder streamType(int val) {
            this.streamType = val;
            return this;
        }

        public Builder isLog(boolean val) {
            this.isLog = val;
            return this;
        }

        public Builder mode(int val) {
            this.mode = val;
            return this;
        }

        public Builder rate(int val) {
            this.rate = val;
            return this;
        }

        public Builder channelConfig(int val) {
            this.channelConfig = val;
            return this;
        }

        public Builder audioFormat(int val) {
            this.audioFormat = val;
            return this;
        }

        public Builder blocksizeBuf(int val) {
            this.blocksize_buf = val;
            return this;
        }

        public Builder channel(Channel val) {
            this.channel = val;
            return this;
        }

        public RxAudioPlayer build() {
            return new RxAudioPlayer(this);
        }
    }
}

