/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.util.Log;
import android.util.SparseArray;
import com.okhttplib.HttpInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Call;

public class BaseActivityLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private static boolean showLifecycleLog;
    private static Map<Class<?>, SparseArray<Call>> callsMap;

    public static void putCall(HttpInfo info, Call call) {
        if (null != info.getTag()) {
            SparseArray callList = callsMap.get(info.getTag());
            if (null == callList) {
                callList = new SparseArray();
                callList.put(call.hashCode(), (Object)call);
                callsMap.put(info.getTag(), (SparseArray<Call>)callList);
            } else {
                callList.put(call.hashCode(), (Object)call);
            }
        }
        BaseActivityLifecycleCallbacks.showLog(false);
    }

    public static void cancelCall(Class<?> clazz) {
        SparseArray<Call> callList = callsMap.get(clazz);
        if (null != callList) {
            for (int i = 0; i < callList.size(); ++i) {
                Call call = (Call)callList.valueAt(i);
                if (call.isCanceled()) continue;
                call.cancel();
            }
            callList.clear();
            callsMap.remove(clazz);
        }
        BaseActivityLifecycleCallbacks.showLog(true);
    }

    public static void cancelCall(HttpInfo info, Call call) {
        SparseArray<Call> callList;
        if (null != call && null != (callList = callsMap.get(info.getTag()))) {
            Call c = (Call)callList.get(call.hashCode());
            if (!c.isCanceled()) {
                c.cancel();
            }
            callList.delete(call.hashCode());
            if (callList.size() == 0) {
                callsMap.remove(info.getTag());
            }
        }
        BaseActivityLifecycleCallbacks.showLog(true);
    }

    public static void showLog(boolean isCancel) {
        String callDetail = "\u589e\u52a0\u8bf7\u6c42";
        if (isCancel) {
            callDetail = "\u53d6\u6d88\u8bf7\u6c42";
        }
        if (showLifecycleLog) {
            if (callsMap.size() > 0) {
                for (Map.Entry<Class<?>, SparseArray<Call>> entry : callsMap.entrySet()) {
                    Log.d((String)BaseActivityLifecycleCallbacks.class.getSimpleName(), (String)("###" + callDetail + ": size = " + entry.getValue().size() + " [" + entry.getKey().getName() + "]"));
                }
            } else {
                Log.d((String)BaseActivityLifecycleCallbacks.class.getSimpleName(), (String)("###" + callDetail + ": size = 0 "));
            }
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        BaseActivityLifecycleCallbacks.cancelCall(activity.getClass());
    }

    public static void setShowLifecycleLog(boolean showLifecycle) {
        showLifecycleLog = showLifecycle;
    }

    static {
        callsMap = new ConcurrentHashMap();
    }
}

