/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.util;

import android.text.TextUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class EncryptUtil {
    public static String MD5StringTo16Bit(String originString, boolean isUpperCase) throws Exception {
        String result = EncryptUtil.MD5StringTo32Bit(originString, isUpperCase);
        if (result.length() == 32) {
            return result.substring(8, 24);
        }
        return "";
    }

    public static String MD5StringTo32Bit(String originString, boolean isUpperCase) throws Exception {
        StringBuilder result = new StringBuilder("");
        if (originString != null) {
            byte[] bytes;
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (byte b : bytes = md.digest(originString.getBytes())) {
                String str = Integer.toHexString(b & 0xFF);
                if (str.length() == 1) {
                    str = str + "F";
                }
                result.append(str);
            }
        }
        if (isUpperCase) {
            return result.toString().toUpperCase();
        }
        return result.toString().toLowerCase();
    }

    public static String getFileMd5(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return "";
        }
        return EncryptUtil.getFileMd5(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMd5(File file) {
        RandomAccessFile randomAccessFile = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            if (file == null) {
                String string = "";
                return string;
            }
            if (!file.exists()) {
                String string = "";
                return string;
            }
            randomAccessFile = new RandomAccessFile(file, "r");
            byte[] bytes = new byte[0xA00000];
            int len = 0;
            while ((len = randomAccessFile.read(bytes)) != -1) {
                messageDigest.update(bytes, 0, len);
            }
            BigInteger bigInt = new BigInteger(1, messageDigest.digest());
            String md5 = bigInt.toString(16);
            while (md5.length() < 32) {
                md5 = "0" + md5;
            }
            String string = md5;
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }
}

