/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.callback;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Call;

public class BaseActivityLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "ActivityLifecycle";
    private static boolean showLifecycleLog;
    private static Map<String, SparseArray<Call>> callsMap;

    public static void putCall(String tag, Call call) {
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            SparseArray callList = callsMap.get(tag);
            if (null == callList) {
                callList = new SparseArray();
            }
            callList.put(call.hashCode(), (Object)call);
            callsMap.put(tag, (SparseArray<Call>)callList);
            BaseActivityLifecycleCallbacks.showLog(false, tag);
        }
    }

    private void cancelCallByActivityDestroy(Activity activity) {
        String tag = activity.getClass().getName();
        if (null == tag) {
            return;
        }
        this.destroy(tag, callsMap.get(tag));
        this.destroy(tag, callsMap.get(String.valueOf(activity.hashCode())));
    }

    private void destroy(String tag, SparseArray<Call> callList) {
        if (null != callList) {
            int len = callList.size();
            for (int i = 0; i < len; ++i) {
                Call call = (Call)callList.valueAt(i);
                if (null == call || call.isCanceled()) continue;
                call.cancel();
            }
            callList.clear();
            callsMap.remove(tag);
            BaseActivityLifecycleCallbacks.showLog(true, tag);
        }
    }

    public static boolean isActivityDestroyed(Activity activity) {
        String tag = activity.getClass().getName();
        return callsMap.get(tag) == null;
    }

    public static boolean isActivityDestroyed(String tag) {
        return !TextUtils.isEmpty((CharSequence)tag) && callsMap.get(tag) == null;
    }

    public static void cancel(String tag) {
        BaseActivityLifecycleCallbacks.cancel(tag, null);
    }

    public static void cancel(String tag, Call originalCall) {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            return;
        }
        if (null != originalCall) {
            SparseArray<Call> callList = callsMap.get(tag);
            if (null != callList) {
                Call c = (Call)callList.get(originalCall.hashCode());
                if (null != c && !c.isCanceled()) {
                    c.cancel();
                }
                callList.delete(originalCall.hashCode());
                if (callList.size() == 0) {
                    callsMap.remove(tag);
                }
                BaseActivityLifecycleCallbacks.showLog(true, tag);
            }
        } else {
            SparseArray<Call> callList = callsMap.get(tag);
            if (null != callList) {
                for (int i = 0; i < callList.size(); ++i) {
                    Call call = (Call)callList.valueAt(i);
                    if (null != call && !call.isCanceled()) {
                        call.cancel();
                        callList.delete(call.hashCode());
                    }
                    if (callList.size() == 0) {
                        callsMap.remove(tag);
                    }
                    BaseActivityLifecycleCallbacks.showLog(true, tag);
                }
            }
        }
    }

    private static void showLog(boolean isCancel, String tag) {
        if (!showLifecycleLog) {
            return;
        }
        String callDetail = isCancel ? "\u53d6\u6d88\u8bf7\u6c42" : "\u589e\u52a0\u8bf7\u6c42";
        Log.d((String)TAG, (String)(callDetail + ": " + tag));
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.cancelCallByActivityDestroy(activity);
    }

    public static void setShowLifecycleLog(boolean showLifecycle) {
        showLifecycleLog = showLifecycle;
    }

    static {
        callsMap = new ConcurrentHashMap<String, SparseArray<Call>>();
    }
}

