/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.helper;

import android.annotation.SuppressLint;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.okhttplib.HttpInfo;
import com.okhttplib.bean.DownloadMessage;
import com.okhttplib.bean.UploadFileInfo;
import com.okhttplib.bean.UploadMessage;
import com.okhttplib.callback.BaseActivityLifecycleCallbacks;
import com.okhttplib.callback.ProgressCallback;
import com.okhttplib.handler.OkMainHandler;
import com.okhttplib.helper.HelperInfo;
import com.okhttplib.interceptor.ExceptionInterceptor;
import com.okhttplib.interceptor.ResultInterceptor;
import com.okhttplib.util.MediaTypeUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;

abstract class BaseHelper {
    private int cacheSurvivalTime;
    private int cacheType;
    OkHttpClient httpClient;
    private String TAG;
    String timeStamp;
    private boolean showHttpLog;
    public String requestTag;
    HelperInfo helperInfo;
    HttpInfo httpInfo;
    private List<ResultInterceptor> resultInterceptors;
    private List<ExceptionInterceptor> exceptionInterceptors;
    private final Interceptor NETWORK_INTERCEPTOR = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            Response originalResponse = chain.proceed(originalRequest);
            if (BaseHelper.this.httpInfo != null) {
                BaseHelper.this.httpInfo.setFromCache(false);
            }
            if (BaseHelper.this.cacheSurvivalTime == 0) {
                BaseHelper.this.cacheSurvivalTime = 31536000;
            }
            return originalResponse.newBuilder().header("Cache-Control", String.format(Locale.getDefault(), "max-age=%d", BaseHelper.this.cacheSurvivalTime)).build();
        }
    };
    private Interceptor NO_NETWORK_INTERCEPTOR = new Interceptor(){
        int count = 0;

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            Response originalResponse = null;
            switch (BaseHelper.this.cacheType) {
                case 2: {
                    originalRequest = originalRequest.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                    BaseHelper.this.httpInfo.setFromCache(true);
                    originalResponse = chain.proceed(originalRequest);
                    break;
                }
                case 1: {
                    originalRequest = originalRequest.newBuilder().cacheControl(CacheControl.FORCE_NETWORK).build();
                    originalResponse = chain.proceed(originalRequest);
                    break;
                }
                case 3: {
                    if (!BaseHelper.this.helperInfo.getOkHttpUtil().isNetworkAvailable()) {
                        BaseHelper.this.httpInfo.setFromCache(true);
                        originalRequest = originalRequest.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                        originalResponse = chain.proceed(originalRequest);
                        break;
                    }
                    originalResponse = chain.proceed(originalRequest);
                    originalResponse.newBuilder().removeHeader("Pragma").header("Cache-Control", "public, only-if-cached, max-stale=31536000").build();
                    break;
                }
                case 4: {
                    if (!BaseHelper.this.helperInfo.getOkHttpUtil().isNetworkAvailable()) {
                        BaseHelper.this.httpInfo.setFromCache(true);
                        originalRequest = originalRequest.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                        originalResponse = chain.proceed(originalRequest);
                        break;
                    }
                    originalResponse = chain.proceed(originalRequest);
                    break;
                }
                default: {
                    originalResponse = chain.proceed(originalRequest);
                }
            }
            return originalResponse;
        }

        private Response aopChain(Interceptor.Chain chain, Request request, CacheControl cacheControl, boolean readCache) {
            Response originalResponse;
            block3: {
                originalResponse = null;
                ++this.count;
                try {
                    originalResponse = chain.proceed(request);
                    if (this.count >= 4) {
                        return originalResponse;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    request = request.newBuilder().cacheControl(cacheControl).build();
                    originalResponse = this.aopChain(chain, request, cacheControl, readCache);
                    if (!readCache) break block3;
                    BaseHelper.this.httpInfo.setFromCache(true);
                }
            }
            return originalResponse;
        }
    };
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private static final X509TrustManager TRUST_MANAGER = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };

    BaseHelper(HelperInfo helperInfo) {
        this.helperInfo = helperInfo;
        this.httpInfo = helperInfo.getHttpInfo();
        if (this.httpInfo != null) {
            this.httpInfo.setFromCache(true);
        }
        this.cacheSurvivalTime = helperInfo.getCacheSurvivalTime();
        this.cacheType = helperInfo.getCacheType();
        this.TAG = helperInfo.getLogTAG();
        this.timeStamp = helperInfo.getTimeStamp();
        this.showHttpLog = helperInfo.isShowHttpLog();
        this.requestTag = helperInfo.getRequestTag();
        if (helperInfo.isDefault()) {
            OkHttpClient defaultClient = helperInfo.getOkHttpUtil().getDefaultClient();
            if (null == defaultClient) {
                this.httpClient = this.initHttpClient(helperInfo);
                helperInfo.getOkHttpUtil().setDefaultClient(this.httpClient);
            } else {
                this.httpClient = defaultClient;
            }
        } else {
            this.httpClient = this.initHttpClient(helperInfo);
        }
        this.resultInterceptors = helperInfo.getResultInterceptors();
        this.exceptionInterceptors = helperInfo.getExceptionInterceptors();
    }

    private OkHttpClient initHttpClient(HelperInfo helperInfo) {
        OkHttpClient.Builder clientBuilder = helperInfo.getClientBuilder();
        clientBuilder.protocols(Arrays.asList(Protocol.SPDY_3, Protocol.HTTP_1_1));
        clientBuilder.addInterceptor(this.NO_NETWORK_INTERCEPTOR);
        clientBuilder.addNetworkInterceptor(this.NETWORK_INTERCEPTOR);
        if (helperInfo.isGzip()) {
            clientBuilder.addInterceptor((Interceptor)new GzipRequestInterceptor());
        }
        if (this.httpInfo == null || this.httpInfo.getUrl() == null) {
            return clientBuilder.build();
        }
        try {
            URI uri = new URL(this.httpInfo.getUrl()).toURI();
            if ("https".equals(uri.getScheme())) {
                if (helperInfo.getHttpsCertificateStream() == null) {
                    this.setDefaultSslSocketFactory(clientBuilder);
                } else {
                    this.setSslSocketFactory(clientBuilder);
                }
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return clientBuilder.build();
    }

    private void setDefaultSslSocketFactory(OkHttpClient.Builder clientBuilder) {
        clientBuilder.hostnameVerifier(DO_NOT_VERIFY);
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{TRUST_MANAGER}, new SecureRandom());
            clientBuilder.sslSocketFactory(sc.getSocketFactory(), TRUST_MANAGER);
        }
        catch (Exception e) {
            this.showLog("Https\u8ba4\u8bc1\u5f02\u5e38: " + e.getMessage());
        }
    }

    private void setSslSocketFactory(OkHttpClient.Builder clientBuilder) {
        SSLContext sslContext = this.getSSLContext();
        if (sslContext != null) {
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), TRUST_MANAGER);
        }
    }

    @SuppressLint(value={"TrulyRandom"})
    private SSLContext getSSLContext() {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            InputStream inputStream = this.helperInfo.getHttpsCertificateStream();
            CertificateFactory cerFactory = CertificateFactory.getInstance("X.509");
            Certificate cer = cerFactory.generateCertificate(inputStream);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(null, null);
            keyStore.setCertificateEntry("trust", cer);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, null);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sslContext;
    }

    void addHeadsToRequest(HttpInfo info, Request.Builder requestBuilder) {
        if (null != info.getHeads() && !info.getHeads().isEmpty()) {
            StringBuilder log = new StringBuilder("Heads: ");
            for (String key : info.getHeads().keySet()) {
                requestBuilder.addHeader(key, info.getHeads().get(key));
                log.append(key).append("=").append(info.getHeads().get(key)).append(" | ");
            }
            int point = log.lastIndexOf("|");
            if (point != -1) {
                log.deleteCharAt(point);
            }
            this.showLog(log.toString());
        }
    }

    HttpInfo retInfo(HttpInfo info, int code) {
        return this.retInfo(info, code, code, null);
    }

    HttpInfo retInfo(HttpInfo info, int netCode, int code) {
        return this.retInfo(info, netCode, code, null);
    }

    HttpInfo retInfo(HttpInfo info, int code, String resDetail) {
        return this.retInfo(info, code, code, resDetail);
    }

    HttpInfo retInfo(HttpInfo info, int netCode, int code, String resDetail) {
        info.packInfo(netCode, code, this.unicodeToString(resDetail));
        this.dealInterceptor(info);
        this.showLog("Response: " + info.getRetDetail());
        return info;
    }

    private String unicodeToString(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            char ch = (char)Integer.parseInt(matcher.group(2), 16);
            str = str.replace(matcher.group(1), ch + "");
        }
        return str;
    }

    private void dealInterceptor(HttpInfo info) {
        try {
            if (BaseActivityLifecycleCallbacks.isActivityDestroyed(this.requestTag)) {
                return;
            }
            if (info.isSuccessful() && null != this.resultInterceptors) {
                for (ResultInterceptor interceptor : this.resultInterceptors) {
                    interceptor.intercept(info);
                }
            } else if (null != this.exceptionInterceptors) {
                for (ExceptionInterceptor interceptor : this.exceptionInterceptors) {
                    interceptor.intercept(info);
                }
            }
        }
        catch (Exception e) {
            this.showLog("\u62e6\u622a\u5668\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    void responseCallback(HttpInfo info, ProgressCallback progressCallback, int code, String requestTag) {
        if (null != progressCallback) {
            progressCallback.onResponseSync(info.getUrl(), info);
        }
        if (4 == code) {
            Message msg = new DownloadMessage(code, info.getUrl(), info, progressCallback, requestTag).build();
            OkMainHandler.getInstance().sendMessage(msg);
        } else if (3 == code) {
            Message msg = new UploadMessage(code, info.getUrl(), info, progressCallback, requestTag).build();
            OkMainHandler.getInstance().sendMessage(msg);
        }
    }

    void showLog(String msg) {
        if (this.showHttpLog) {
            Log.d((String)(this.TAG + "[" + this.timeStamp + "]"), (String)msg);
        }
    }

    protected RequestBody matchContentType(HttpInfo info, UploadFileInfo fileInfo) {
        RequestBody requestBody;
        String requestEncoding = info.getRequestEncoding();
        requestEncoding = TextUtils.isEmpty((CharSequence)requestEncoding) ? ";charset=" + this.helperInfo.getRequestEncoding().toLowerCase() : ";charset=" + requestEncoding.toLowerCase();
        if (fileInfo != null) {
            String contentType = fileInfo.getContentType();
            contentType = TextUtils.isEmpty((CharSequence)contentType) ? info.getContentType() : contentType;
            MediaType mediaType = MediaType.parse((String)(contentType + requestEncoding));
            String filePath = fileInfo.getFilePathWithName();
            RequestBody requestBody2 = fileInfo.getFile() != null ? (TextUtils.isEmpty((CharSequence)filePath) ? RequestBody.create((MediaType)mediaType, (File)fileInfo.getFile()) : RequestBody.create((MediaType)MediaTypeUtil.fetchFileMediaType(filePath, requestEncoding), (File)fileInfo.getFile())) : (fileInfo.getFileByte() != null ? RequestBody.create((MediaType)mediaType, (byte[])fileInfo.getFileByte()) : RequestBody.create((MediaType)mediaType, (File)fileInfo.getFile()));
            return requestBody2;
        }
        if (!TextUtils.isEmpty((CharSequence)info.getContentType())) {
            MediaType mediaType = MediaType.parse((String)(info.getContentType() + requestEncoding));
            if (info.getParamBytes() != null) {
                requestBody = RequestBody.create((MediaType)mediaType, (byte[])info.getParamBytes());
            } else if (info.getParamFile() != null) {
                requestBody = RequestBody.create((MediaType)mediaType, (File)info.getParamFile());
            } else if (info.getParamJson() != null) {
                this.showLog("Params: " + info.getParamJson());
                requestBody = RequestBody.create((MediaType)mediaType, (String)info.getParamJson());
            } else if (info.getParamForm() != null) {
                this.showLog("Params: " + info.getParamForm());
                requestBody = RequestBody.create((MediaType)mediaType, (String)info.getParamForm());
            } else {
                requestBody = this.packageRequestBody(info, mediaType);
            }
        } else if (info.getParamBytes() != null) {
            requestBody = RequestBody.create((MediaType)MediaType.parse((String)("application/octet-stream" + requestEncoding)), (byte[])info.getParamBytes());
        } else if (info.getParamFile() != null) {
            requestBody = RequestBody.create((MediaType)MediaType.parse((String)("text/x-markdown" + requestEncoding)), (File)info.getParamFile());
        } else if (info.getParamJson() != null) {
            this.showLog("Params: " + info.getParamJson());
            requestBody = RequestBody.create((MediaType)MediaType.parse((String)("application/json" + requestEncoding)), (String)info.getParamJson());
        } else if (info.getParamForm() != null) {
            this.showLog("Params: " + info.getParamForm());
            requestBody = RequestBody.create((MediaType)MediaType.parse((String)("application/x-www-form-urlencoded" + requestEncoding)), (String)info.getParamForm());
        } else {
            requestBody = this.packageRequestBody(info, MediaType.parse((String)("application/x-www-form-urlencoded" + requestEncoding)));
        }
        return requestBody;
    }

    private RequestBody packageRequestBody(HttpInfo info, MediaType contentType) {
        StringBuilder param = new StringBuilder();
        StringBuilder log = new StringBuilder();
        boolean isFirst = true;
        if (info.getParams() != null) {
            for (String key : info.getParams().keySet()) {
                String value = info.getParams().get(key);
                String string = value = value == null ? "" : value;
                if (isFirst) {
                    isFirst = false;
                    param.append(key).append("=").append(value);
                    log.append(key).append("=").append(value);
                    continue;
                }
                param.append("&").append(key).append("=").append(value);
                log.append(" | ").append(key).append("=").append(value);
            }
        }
        this.showLog("Params: " + log.toString());
        return RequestBody.create((MediaType)contentType, (String)param.toString());
    }

    private final class GzipRequestInterceptor
    implements Interceptor {
        private GzipRequestInterceptor() {
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            if (originalRequest.body() == null || originalRequest.header("Content-Encoding") != null) {
                return chain.proceed(originalRequest);
            }
            Request compressedRequest = originalRequest.newBuilder().header("Content-Encoding", "gzip").method(originalRequest.method(), this.gzip(originalRequest.body())).build();
            return chain.proceed(compressedRequest);
        }

        private RequestBody gzip(final RequestBody body) {
            return new RequestBody(){

                public MediaType contentType() {
                    return body.contentType();
                }

                public long contentLength() {
                    return -1L;
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)sink));
                    body.writeTo(gzipSink);
                    gzipSink.close();
                }
            };
        }
    }
}

