/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.helper;

import android.text.TextUtils;
import com.okhttplib.HttpInfo;
import com.okhttplib.bean.DownloadFileInfo;
import com.okhttplib.bean.UploadFileInfo;
import com.okhttplib.callback.BaseCallback;
import com.okhttplib.callback.ProgressCallback;
import com.okhttplib.helper.DownUpLoadHelper;
import com.okhttplib.helper.HelperInfo;
import com.okhttplib.helper.HttpHelper;
import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class OkHttpHelper {
    private HttpInfo httpInfo;
    private HttpHelper httpHelper;
    private DownUpLoadHelper downUpLoadHelper;
    private DownloadFileInfo downloadFileInfo;
    private List<UploadFileInfo> uploadFileInfoList = new ArrayList<UploadFileInfo>();
    private OkHttpClient.Builder clientBuilder;
    private int requestType;
    private BaseCallback callback;
    private ProgressCallback progressCallback;
    private Request request;
    private OkHttpClient httpClient;
    private int businessType;
    private String responseEncoding;
    private String requestEncoding;

    private OkHttpHelper(Builder builder) {
        this.httpInfo = builder.httpInfo;
        this.downloadFileInfo = builder.downloadFileInfo;
        this.uploadFileInfoList = builder.uploadFileInfoList;
        this.clientBuilder = builder.clientBuilder;
        this.requestType = builder.requestType;
        this.callback = builder.callback;
        this.progressCallback = builder.progressCallback;
        this.businessType = builder.businessType;
        this.responseEncoding = builder.helperInfo.getResponseEncoding();
        this.requestEncoding = builder.helperInfo.getRequestEncoding();
        builder.helperInfo.setHttpInfo(this.httpInfo);
        this.httpHelper = new HttpHelper(builder.helperInfo);
        if (null != this.downloadFileInfo || !this.uploadFileInfoList.isEmpty()) {
            this.downUpLoadHelper = new DownUpLoadHelper(builder.helperInfo);
        }
    }

    public HttpInfo doRequestSync() {
        return this.httpHelper.doRequestSync(this);
    }

    public void doRequestAsync() {
        this.httpHelper.doRequestAsync(this);
    }

    public void downloadFile() {
        this.downUpLoadHelper.downloadFile(this);
    }

    public void uploadFile() {
        this.downUpLoadHelper.uploadFile(this);
    }

    public static Builder Builder() {
        return new Builder();
    }

    HttpInfo getHttpInfo() {
        return this.httpInfo;
    }

    HttpHelper getHttpHelper() {
        return this.httpHelper;
    }

    DownUpLoadHelper getDownUpLoadHelper() {
        return this.downUpLoadHelper;
    }

    int getBusinessType() {
        return this.businessType;
    }

    String getResponseEncoding() {
        return this.responseEncoding;
    }

    String getRequestEncoding() {
        return this.requestEncoding;
    }

    DownloadFileInfo getDownloadFileInfo() {
        return this.downloadFileInfo;
    }

    List<UploadFileInfo> getUploadFileInfoList() {
        return this.uploadFileInfoList;
    }

    OkHttpClient.Builder getClientBuilder() {
        return this.clientBuilder;
    }

    int getRequestType() {
        return this.requestType;
    }

    BaseCallback getCallback() {
        return this.callback;
    }

    ProgressCallback getProgressCallback() {
        return this.progressCallback;
    }

    Request getRequest() {
        return this.request;
    }

    void setRequest(Request request) {
        this.request = request;
    }

    OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static final class Builder {
        private HttpInfo httpInfo;
        private HelperInfo helperInfo;
        private DownloadFileInfo downloadFileInfo;
        private List<UploadFileInfo> uploadFileInfoList = new ArrayList<UploadFileInfo>();
        private OkHttpClient.Builder clientBuilder;
        private int requestType;
        private BaseCallback callback;
        private ProgressCallback progressCallback;
        private int businessType;

        public OkHttpHelper build() {
            if (!this.uploadFileInfoList.isEmpty()) {
                this.businessType = 2;
                UploadFileInfo uploadFileInfo = this.uploadFileInfoList.get(0);
                if (!TextUtils.isEmpty((CharSequence)uploadFileInfo.getUrl())) {
                    this.httpInfo.setUrl(uploadFileInfo.getUrl());
                }
            } else if (this.downloadFileInfo != null) {
                this.businessType = 3;
                if (!TextUtils.isEmpty((CharSequence)this.downloadFileInfo.getUrl())) {
                    this.httpInfo.setUrl(this.downloadFileInfo.getUrl());
                }
            } else {
                this.businessType = 1;
            }
            return new OkHttpHelper(this);
        }

        public Builder httpInfo(HttpInfo httpInfo) {
            this.httpInfo = httpInfo;
            return this;
        }

        public Builder helperInfo(HelperInfo helperInfo) {
            this.helperInfo = helperInfo;
            return this;
        }

        public Builder downloadFileInfo(DownloadFileInfo downloadFileInfo) {
            this.downloadFileInfo = downloadFileInfo;
            return this;
        }

        public Builder uploadFileInfo(UploadFileInfo uploadFileInfo) {
            this.uploadFileInfoList.add(uploadFileInfo);
            return this;
        }

        public Builder uploadFileInfoList(List<UploadFileInfo> uploadFiles) {
            this.uploadFileInfoList.addAll(uploadFiles);
            return this;
        }

        public Builder clientBuilder(OkHttpClient.Builder clientBuilder) {
            this.clientBuilder = clientBuilder;
            return this;
        }

        public Builder requestType(int requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder callback(BaseCallback callback) {
            this.callback = callback;
            return this;
        }

        public Builder progressCallback(ProgressCallback progressCallback) {
            this.progressCallback = progressCallback;
            return this;
        }
    }
}

