/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.okhttplib.HttpInfo;
import com.okhttplib.OkApplication;
import com.okhttplib.OkHttpUtilInterface;
import com.okhttplib.bean.DownloadFileInfo;
import com.okhttplib.bean.UploadFileInfo;
import com.okhttplib.callback.BaseActivityLifecycleCallbacks;
import com.okhttplib.callback.BaseCallback;
import com.okhttplib.callback.ProgressCallback;
import com.okhttplib.helper.HelperInfo;
import com.okhttplib.helper.OkHttpHelper;
import com.okhttplib.interceptor.ExceptionInterceptor;
import com.okhttplib.interceptor.ResultInterceptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpUtil
implements OkHttpUtilInterface {
    private final String TAG = this.getClass().getSimpleName();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context context;
    private static Builder builderGlobal;
    private static OkHttpClient httpClient;
    private static ScheduledExecutorService executorService;
    private Builder builder;
    private int cacheSurvivalTime = 0;
    private int cacheType = 1;

    private Context getContext() {
        if (context == null) {
            context = OkApplication.get();
        }
        return context;
    }

    public static Builder init(Context context) {
        OkHttpUtil.context = context;
        if (Build.VERSION.SDK_INT > 13) {
            ((Application)OkHttpUtil.context).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new BaseActivityLifecycleCallbacks());
        }
        return OkHttpUtil.BuilderGlobal();
    }

    public static OkHttpUtilInterface getDefault() {
        return new Builder(false).isDefault(true).build();
    }

    public static OkHttpUtilInterface getDefault(Object requestTag) {
        return new Builder(false).isDefault(true).build(requestTag);
    }

    @Override
    public HttpInfo doSync(HttpInfo info) {
        return OkHttpHelper.Builder().httpInfo(info).requestType(info.getRequestType()).helperInfo(this.packageHelperInfo(info)).build().doRequestSync();
    }

    @Override
    public void doAsync(final HttpInfo info, final BaseCallback callback) {
        executorService.schedule(new Runnable(){

            @Override
            public void run() {
                OkHttpHelper.Builder().httpInfo(info).requestType(info.getRequestType()).callback(callback).helperInfo(OkHttpUtil.this.packageHelperInfo(info)).build().doRequestAsync();
            }
        }, info.getDelayExecTime(), info.getDelayExecUnit());
    }

    @Override
    public HttpInfo doPostSync(HttpInfo info) {
        return OkHttpHelper.Builder().httpInfo(info).requestType(1).helperInfo(this.packageHelperInfo(info)).build().doRequestSync();
    }

    @Override
    public HttpInfo doPostSync(HttpInfo info, ProgressCallback callback) {
        return OkHttpHelper.Builder().httpInfo(info).requestType(1).progressCallback(callback).helperInfo(this.packageHelperInfo(info)).build().doRequestSync();
    }

    @Override
    public void doPostAsync(final HttpInfo info, final BaseCallback callback) {
        executorService.schedule(new Runnable(){

            @Override
            public void run() {
                OkHttpHelper.Builder().httpInfo(info).requestType(1).callback(callback).helperInfo(OkHttpUtil.this.packageHelperInfo(info)).build().doRequestAsync();
            }
        }, info.getDelayExecTime(), info.getDelayExecUnit());
    }

    @Override
    public void doPostAsync(final HttpInfo info, final ProgressCallback callback) {
        executorService.schedule(new Runnable(){

            @Override
            public void run() {
                OkHttpHelper.Builder().httpInfo(info).requestType(1).progressCallback(callback).helperInfo(OkHttpUtil.this.packageHelperInfo(info)).build().doRequestAsync();
            }
        }, info.getDelayExecTime(), info.getDelayExecUnit());
    }

    @Override
    public HttpInfo doGetSync(HttpInfo info) {
        return OkHttpHelper.Builder().httpInfo(info).requestType(2).helperInfo(this.packageHelperInfo(info)).build().doRequestSync();
    }

    @Override
    public void doGetAsync(final HttpInfo info, final BaseCallback callback) {
        executorService.schedule(new Runnable(){

            @Override
            public void run() {
                OkHttpHelper.Builder().httpInfo(info).requestType(2).callback(callback).helperInfo(OkHttpUtil.this.packageHelperInfo(info)).build().doRequestAsync();
            }
        }, info.getDelayExecTime(), info.getDelayExecUnit());
    }

    @Override
    public void doUploadFileAsync(final HttpInfo info) {
        List<UploadFileInfo> uploadFiles = info.getUploadFiles();
        for (final UploadFileInfo fileInfo : uploadFiles) {
            executorService.schedule(new Runnable(){

                @Override
                public void run() {
                    OkHttpHelper.Builder().httpInfo(info).uploadFileInfo(fileInfo).requestType(1).helperInfo(OkHttpUtil.this.packageHelperInfo(info)).build().uploadFile();
                }
            }, info.getDelayExecTime(), info.getDelayExecUnit());
        }
    }

    @Override
    public void doUploadFileAsync(final HttpInfo info, final ProgressCallback callback) {
        final List<UploadFileInfo> uploadFiles = info.getUploadFiles();
        executorService.schedule(new Runnable(){

            @Override
            public void run() {
                OkHttpHelper.Builder().httpInfo(info).uploadFileInfoList(uploadFiles).requestType(1).progressCallback(callback).helperInfo(OkHttpUtil.this.packageHelperInfo(info)).build().uploadFile();
            }
        }, info.getDelayExecTime(), info.getDelayExecUnit());
    }

    @Override
    public void doUploadFileSync(HttpInfo info) {
        List<UploadFileInfo> uploadFiles = info.getUploadFiles();
        for (UploadFileInfo fileInfo : uploadFiles) {
            OkHttpHelper.Builder().httpInfo(info).uploadFileInfo(fileInfo).requestType(1).helperInfo(this.packageHelperInfo(info)).build().uploadFile();
        }
    }

    @Override
    public void doUploadFileSync(HttpInfo info, ProgressCallback callback) {
        List<UploadFileInfo> uploadFiles = info.getUploadFiles();
        OkHttpHelper.Builder().httpInfo(info).uploadFileInfoList(uploadFiles).requestType(1).progressCallback(callback).helperInfo(this.packageHelperInfo(info)).build().uploadFile();
    }

    @Override
    public void doDownloadFileAsync(final HttpInfo info) {
        List<DownloadFileInfo> downloadFiles = info.getDownloadFiles();
        for (final DownloadFileInfo fileInfo : downloadFiles) {
            executorService.schedule(new Runnable(){

                @Override
                public void run() {
                    OkHttpHelper.Builder().httpInfo(info).downloadFileInfo(fileInfo).requestType(2).clientBuilder(OkHttpUtil.this.newBuilderFromCopy()).helperInfo(OkHttpUtil.this.packageHelperInfo(info)).build().downloadFile();
                }
            }, info.getDelayExecTime(), info.getDelayExecUnit());
        }
    }

    @Override
    public void doDownloadFileSync(HttpInfo info) {
        List<DownloadFileInfo> downloadFiles = info.getDownloadFiles();
        for (DownloadFileInfo fileInfo : downloadFiles) {
            OkHttpHelper.Builder().httpInfo(info).downloadFileInfo(fileInfo).requestType(2).clientBuilder(this.newBuilderFromCopy()).helperInfo(this.packageHelperInfo(info)).build().downloadFile();
        }
    }

    @Override
    public HttpInfo doDeleteSync(HttpInfo info) {
        return OkHttpHelper.Builder().httpInfo(info).requestType(4).helperInfo(this.packageHelperInfo(info)).build().doRequestSync();
    }

    @Override
    public void doDeleteAsync(final HttpInfo info, final BaseCallback callback) {
        executorService.schedule(new Runnable(){

            @Override
            public void run() {
                OkHttpHelper.Builder().httpInfo(info).requestType(4).callback(callback).helperInfo(OkHttpUtil.this.packageHelperInfo(info)).build().doRequestAsync();
            }
        }, info.getDelayExecTime(), info.getDelayExecUnit());
    }

    @Override
    public HttpInfo doPutSync(HttpInfo info) {
        return OkHttpHelper.Builder().httpInfo(info).requestType(3).helperInfo(this.packageHelperInfo(info)).build().doRequestSync();
    }

    @Override
    public void doPutAsync(final HttpInfo info, final BaseCallback callback) {
        executorService.schedule(new Runnable(){

            @Override
            public void run() {
                OkHttpHelper.Builder().httpInfo(info).requestType(3).callback(callback).helperInfo(OkHttpUtil.this.packageHelperInfo(info)).build().doRequestAsync();
            }
        }, info.getDelayExecTime(), info.getDelayExecUnit());
    }

    @Override
    public void cancelRequest(Object requestTag) {
        BaseActivityLifecycleCallbacks.cancel(OkHttpUtil.parseRequestTag(requestTag));
    }

    @Override
    public OkHttpClient getDefaultClient() {
        return httpClient;
    }

    public void setDefaultClient(OkHttpClient client) {
        httpClient = client;
    }

    public boolean isNetworkAvailable() {
        if (this.getContext() == null) {
            return true;
        }
        ConnectivityManager cm = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo net = cm.getActiveNetworkInfo();
        return net != null && net.getState() == NetworkInfo.State.CONNECTED;
    }

    private OkHttpUtil(Builder builder) {
        this.builder = builder;
        this.cacheType = builder.cacheType;
        this.cacheSurvivalTime = builder.cacheSurvivalTime;
        if (null == this.getContext()) {
            this.cacheType = 1;
        }
        if (null == executorService) {
            executorService = new ScheduledThreadPoolExecutor(20);
        }
        BaseActivityLifecycleCallbacks.setShowLifecycleLog(builder.showLifecycleLog);
        if (builder.isGlobalConfig) {
            OkHttpHelper.Builder().helperInfo(this.packageHelperInfo(null)).build();
        }
        if (httpClient == null) {
            OkHttpHelper.Builder().helperInfo(this.packageHelperInfo(null)).build().doRequestAsync();
        }
    }

    private HelperInfo packageHelperInfo(HttpInfo info) {
        HelperInfo helperInfo = new HelperInfo();
        helperInfo.setShowHttpLog(this.builder.showHttpLog);
        helperInfo.setRequestTag(this.builder.requestTag);
        int random = 1000 + (int)(Math.random() * 999.0);
        String timeStamp = System.currentTimeMillis() + "_" + random;
        helperInfo.setTimeStamp(timeStamp);
        helperInfo.setExceptionInterceptors(this.builder.exceptionInterceptors);
        helperInfo.setResultInterceptors(this.builder.resultInterceptors);
        helperInfo.setDownloadFileDir(this.builder.downloadFileDir);
        helperInfo.setClientBuilder(this.newBuilderFromCopy());
        helperInfo.setOkHttpUtil(this);
        helperInfo.setDefault(this.builder.isDefault);
        helperInfo.setLogTAG(this.builder.httpLogTAG == null ? this.TAG : this.builder.httpLogTAG);
        helperInfo.setResponseEncoding(this.builder.responseEncoding);
        helperInfo.setRequestEncoding(this.builder.requestEncoding);
        helperInfo.setCacheSurvivalTime(this.cacheSurvivalTime);
        helperInfo.setCacheType(this.cacheType);
        helperInfo.setGzip(this.builder.isGzip);
        String httpsCertificate = null;
        InputStream httpsCertificateStream = null;
        if (this.builder.httpsCertificate != null) {
            httpsCertificate = this.builder.httpsCertificate;
        }
        if (this.builder.httpsCertificateStream != null) {
            httpsCertificateStream = this.builder.httpsCertificateStream;
        }
        if (info != null) {
            if (info.getHttpsCertificate() != null) {
                httpsCertificate = info.getHttpsCertificate();
            }
            if (info.getHttpsCertificateStream() != null) {
                httpsCertificateStream = info.getHttpsCertificateStream();
            }
        }
        if (httpsCertificate != null) {
            InputStream inputStream = null;
            try {
                inputStream = this.getContext().getAssets().open(httpsCertificate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (inputStream == null) {
                Log.e((String)this.builder.httpLogTAG, (String)("Https\u8bc1\u4e66\u4e0d\u5b58\u5728\uff1a" + httpsCertificate));
            }
            helperInfo.setHttpsCertificateStream(inputStream);
        }
        if (httpsCertificateStream != null) {
            helperInfo.setHttpsCertificateStream(httpsCertificateStream);
        }
        return helperInfo;
    }

    private OkHttpClient.Builder newBuilderFromCopy() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectTimeout((long)this.builder.connectTimeout, TimeUnit.SECONDS).readTimeout((long)this.builder.readTimeout, TimeUnit.SECONDS).writeTimeout((long)this.builder.writeTimeout, TimeUnit.SECONDS).retryOnConnectionFailure(this.builder.retryOnConnectionFailure);
        if (this.builder.cachedDir != null) {
            clientBuilder.cache(new Cache(this.builder.cachedDir, (long)this.builder.maxCacheSize));
        }
        if (null != this.builder.networkInterceptors && !this.builder.networkInterceptors.isEmpty()) {
            clientBuilder.networkInterceptors().addAll(this.builder.networkInterceptors);
        }
        if (null != this.builder.interceptors && !this.builder.interceptors.isEmpty()) {
            clientBuilder.interceptors().addAll(this.builder.interceptors);
        }
        if (null != this.builder.cookieJar) {
            clientBuilder.cookieJar(this.builder.cookieJar);
        }
        return clientBuilder;
    }

    public static Builder Builder() {
        return new Builder(false);
    }

    private static Builder BuilderGlobal() {
        return new Builder(true).isDefault(true);
    }

    private static String parseRequestTag(Object object) {
        String requestTag = null;
        if (null != object) {
            requestTag = object.getClass().getName();
            if (requestTag.contains("$")) {
                requestTag = requestTag.substring(0, requestTag.indexOf("$"));
            }
            if (object instanceof String || object instanceof Float || object instanceof Double || object instanceof Integer) {
                requestTag = String.valueOf(object);
            }
        }
        return requestTag;
    }

    @Override
    public boolean deleteCache() {
        try {
            if (httpClient != null && httpClient.cache() != null) {
                httpClient.cache().delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static final class Builder {
        private int maxCacheSize;
        private File cachedDir;
        private int connectTimeout;
        private int readTimeout;
        private int writeTimeout;
        private boolean retryOnConnectionFailure;
        private List<Interceptor> networkInterceptors;
        private List<Interceptor> interceptors;
        private List<ResultInterceptor> resultInterceptors;
        private List<ExceptionInterceptor> exceptionInterceptors;
        private int cacheSurvivalTime;
        private int cacheType;
        private boolean isGlobalConfig;
        private boolean showHttpLog;
        private String httpLogTAG;
        private boolean showLifecycleLog;
        private String downloadFileDir;
        private String requestTag;
        private CookieJar cookieJar;
        private boolean isDefault;
        private String responseEncoding;
        private String requestEncoding;
        private boolean isGzip = false;
        private String httpsCertificate;
        private InputStream httpsCertificateStream;

        public Builder() {
        }

        public Builder(boolean isGlobal) {
            this.isGlobalConfig = isGlobal;
            this.initDefaultConfig();
            if (!isGlobal && null != builderGlobal) {
                this.initGlobalConfig(builderGlobal);
            }
        }

        public OkHttpUtilInterface build() {
            return this.build(null);
        }

        public OkHttpUtilInterface build(Object requestTag) {
            if (this.isGlobalConfig && null == builderGlobal) {
                builderGlobal = this;
            }
            if (null != requestTag) {
                this.setRequestTag(requestTag);
            }
            return new OkHttpUtil(this);
        }

        private void initDefaultConfig() {
            this.setMaxCacheSize(0xA00000);
            this.setConnectTimeout(30);
            this.setReadTimeout(30);
            this.setWriteTimeout(30);
            this.setRetryOnConnectionFailure(true);
            this.setCacheSurvivalTime(0);
            this.setCacheType(1);
            this.setNetworkInterceptors(null);
            this.setInterceptors(null);
            this.setResultInterceptors(null);
            this.setExceptionInterceptors(null);
            this.setShowHttpLog(true);
            this.setShowLifecycleLog(false);
            this.setDownloadFileDir(Environment.getExternalStorageDirectory().getPath() + "/okHttp_download/");
            this.setCachedDir(new File(Environment.getExternalStorageDirectory().getPath() + "/okHttp_cache"));
            this.setIsGzip(false);
            this.setResponseEncoding("UTF-8");
            this.setRequestEncoding("UTF-8");
        }

        private void initGlobalConfig(Builder builder) {
            this.setMaxCacheSize(builder.maxCacheSize);
            this.setCachedDir(builder.cachedDir);
            this.setConnectTimeout(builder.connectTimeout);
            this.setReadTimeout(builder.readTimeout);
            this.setWriteTimeout(builder.writeTimeout);
            this.setRetryOnConnectionFailure(builder.retryOnConnectionFailure);
            this.setCacheSurvivalTime(builder.cacheSurvivalTime);
            this.setCacheType(builder.cacheType);
            this.setNetworkInterceptors(builder.networkInterceptors);
            this.setInterceptors(builder.interceptors);
            this.setResultInterceptors(builder.resultInterceptors);
            this.setExceptionInterceptors(builder.exceptionInterceptors);
            this.setShowHttpLog(builder.showHttpLog);
            this.setHttpLogTAG(builder.httpLogTAG);
            this.setShowLifecycleLog(builder.showLifecycleLog);
            if (!TextUtils.isEmpty((CharSequence)builder.downloadFileDir)) {
                this.setDownloadFileDir(builder.downloadFileDir);
            }
            this.setCookieJar(builder.cookieJar);
            this.setResponseEncoding(builder.responseEncoding);
            this.setRequestEncoding(builder.requestEncoding);
            this.setIsGzip(builder.isGzip);
            if (builder.httpsCertificate != null) {
                this.setHttpsCertificate(builder.httpsCertificate);
            }
            if (builder.httpsCertificateStream != null) {
                this.setHttpsCertificate(builder.httpsCertificateStream);
            }
        }

        private Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public Builder setMaxCacheSize(int maxCacheSize) {
            this.maxCacheSize = maxCacheSize;
            return this;
        }

        public Builder setCachedDir(File cachedDir) {
            if (null != cachedDir) {
                this.cachedDir = cachedDir;
            }
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            if (connectTimeout <= 0) {
                throw new IllegalArgumentException("connectTimeout must be > 0");
            }
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            if (readTimeout <= 0) {
                throw new IllegalArgumentException("readTimeout must be > 0");
            }
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setWriteTimeout(int writeTimeout) {
            if (writeTimeout <= 0) {
                throw new IllegalArgumentException("writeTimeout must be > 0");
            }
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder setRetryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }

        public Builder setNetworkInterceptors(List<Interceptor> networkInterceptors) {
            if (null != networkInterceptors) {
                this.networkInterceptors = networkInterceptors;
            }
            return this;
        }

        public Builder setInterceptors(List<Interceptor> interceptors) {
            if (null != interceptors) {
                this.interceptors = interceptors;
            }
            return this;
        }

        public Builder setResultInterceptors(List<ResultInterceptor> resultInterceptors) {
            if (null != resultInterceptors) {
                this.resultInterceptors = resultInterceptors;
            }
            return this;
        }

        public Builder addResultInterceptor(ResultInterceptor resultInterceptor) {
            if (null != resultInterceptor) {
                if (null == this.resultInterceptors) {
                    this.resultInterceptors = new ArrayList<ResultInterceptor>();
                }
                this.resultInterceptors.add(resultInterceptor);
            }
            return this;
        }

        public Builder setExceptionInterceptors(List<ExceptionInterceptor> exceptionInterceptors) {
            if (null != exceptionInterceptors) {
                this.exceptionInterceptors = exceptionInterceptors;
            }
            return this;
        }

        public Builder addExceptionInterceptor(ExceptionInterceptor exceptionInterceptor) {
            if (null != exceptionInterceptor) {
                if (null == this.exceptionInterceptors) {
                    this.exceptionInterceptors = new ArrayList<ExceptionInterceptor>();
                }
                this.exceptionInterceptors.add(exceptionInterceptor);
            }
            return this;
        }

        public Builder setCacheSurvivalTime(int cacheSurvivalTime) {
            if (cacheSurvivalTime < 0) {
                throw new IllegalArgumentException("cacheSurvivalTime must be >= 0");
            }
            this.cacheSurvivalTime = cacheSurvivalTime;
            return this;
        }

        public Builder setCacheType(int cacheType) {
            this.cacheType = cacheType;
            return this;
        }

        public Builder setShowHttpLog(boolean showHttpLog) {
            this.showHttpLog = showHttpLog;
            return this;
        }

        public Builder setHttpLogTAG(String logTAG) {
            this.httpLogTAG = logTAG;
            return this;
        }

        public Builder setShowLifecycleLog(boolean showLifecycleLog) {
            this.showLifecycleLog = showLifecycleLog;
            return this;
        }

        public Builder setRequestTag(Object requestTag) {
            this.requestTag = OkHttpUtil.parseRequestTag(requestTag);
            return this;
        }

        public Builder setDownloadFileDir(String downloadFileDir) {
            this.downloadFileDir = downloadFileDir;
            return this;
        }

        public Builder setCookieJar(CookieJar cookieJar) {
            if (null != cookieJar) {
                this.cookieJar = cookieJar;
            }
            return this;
        }

        public Builder setResponseEncoding(String responseEncoding) {
            this.responseEncoding = responseEncoding;
            return this;
        }

        public Builder setRequestEncoding(String requestEncoding) {
            this.requestEncoding = requestEncoding;
            return this;
        }

        public Builder setIsGzip(boolean isGzip) {
            this.isGzip = isGzip;
            return this;
        }

        public Builder setHttpsCertificate(String httpsCertificate) {
            this.httpsCertificate = httpsCertificate;
            return this;
        }

        public Builder setHttpsCertificate(InputStream httpsCertificate) {
            this.httpsCertificateStream = httpsCertificate;
            return this;
        }
    }
}

