/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.handler;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.okhttplib.HttpInfo;
import com.okhttplib.bean.CallbackMessage;
import com.okhttplib.bean.DownloadMessage;
import com.okhttplib.bean.ProgressMessage;
import com.okhttplib.bean.UploadMessage;
import com.okhttplib.callback.BaseActivityLifecycleCallbacks;
import com.okhttplib.callback.BaseCallback;
import com.okhttplib.callback.Callback;
import com.okhttplib.callback.CallbackOk;
import okhttp3.Call;
import okhttp3.Response;

public class OkMainHandler
extends Handler {
    private static OkMainHandler singleton;
    public static final int RESPONSE_CALLBACK = 1;
    public static final int PROGRESS_CALLBACK = 2;
    public static final int RESPONSE_UPLOAD_CALLBACK = 3;
    public static final int RESPONSE_DOWNLOAD_CALLBACK = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkMainHandler getInstance() {
        if (null != singleton) return singleton;
        Class<OkMainHandler> clazz = OkMainHandler.class;
        synchronized (OkMainHandler.class) {
            if (null != singleton) return singleton;
            singleton = new OkMainHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private OkMainHandler() {
        super(Looper.getMainLooper());
    }

    public void handleMessage(Message msg) {
        int what = msg.what;
        String requestTag = "";
        try {
            switch (what) {
                case 1: {
                    Call call;
                    CallbackMessage callMsg = (CallbackMessage)msg.obj;
                    if (null != callMsg.callback) {
                        requestTag = callMsg.requestTag;
                        if (!BaseActivityLifecycleCallbacks.isActivityDestroyed(callMsg.requestTag)) {
                            BaseCallback callback = callMsg.callback;
                            if (callback instanceof CallbackOk) {
                                ((CallbackOk)callback).onResponse(callMsg.info);
                            } else if (callback instanceof Callback) {
                                Response res;
                                HttpInfo info = callMsg.info;
                                if (info.isSuccessful()) {
                                    ((Callback)callback).onSuccess(info);
                                } else {
                                    ((Callback)callback).onFailure(info);
                                }
                                if (info.isNeedResponse() && null != (res = info.getResponse())) {
                                    res.close();
                                }
                            }
                        }
                    }
                    if ((call = callMsg.call) != null) {
                        if (!call.isCanceled()) {
                            call.cancel();
                        }
                        BaseActivityLifecycleCallbacks.cancel(requestTag, call);
                    }
                    break;
                }
                case 2: {
                    ProgressMessage proMsg = (ProgressMessage)msg.obj;
                    if (null != proMsg.progressCallback) {
                        requestTag = proMsg.requestTag;
                        if (!BaseActivityLifecycleCallbacks.isActivityDestroyed(proMsg.requestTag)) {
                            proMsg.progressCallback.onProgressMain(proMsg.percent, proMsg.bytesWritten, proMsg.contentLength, proMsg.done);
                        }
                    }
                    break;
                }
                case 3: {
                    UploadMessage uploadMsg = (UploadMessage)msg.obj;
                    if (null != uploadMsg.progressCallback && !BaseActivityLifecycleCallbacks.isActivityDestroyed(requestTag = uploadMsg.requestTag)) {
                        uploadMsg.progressCallback.onResponseMain(uploadMsg.filePath, uploadMsg.info);
                        BaseActivityLifecycleCallbacks.cancel(requestTag);
                    }
                    break;
                }
                case 4: {
                    DownloadMessage downloadMsg = (DownloadMessage)msg.obj;
                    if (null != downloadMsg && !BaseActivityLifecycleCallbacks.isActivityDestroyed(requestTag = downloadMsg.requestTag)) {
                        downloadMsg.progressCallback.onResponseMain(downloadMsg.filePath, downloadMsg.info);
                        BaseActivityLifecycleCallbacks.cancel(requestTag);
                    }
                    break;
                }
                default: {
                    super.handleMessage(msg);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseActivityLifecycleCallbacks.cancel(requestTag);
        }
    }
}

