/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.helper;

import android.os.Build;
import android.os.Message;
import android.os.NetworkOnMainThreadException;
import android.text.TextUtils;
import com.okhttplib.HttpInfo;
import com.okhttplib.bean.CallbackMessage;
import com.okhttplib.callback.BaseActivityLifecycleCallbacks;
import com.okhttplib.callback.BaseCallback;
import com.okhttplib.callback.ProgressCallback;
import com.okhttplib.handler.OkMainHandler;
import com.okhttplib.helper.BaseHelper;
import com.okhttplib.helper.HelperInfo;
import com.okhttplib.helper.OkHttpHelper;
import com.okhttplib.progress.ProgressRequestBody;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Locale;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

class HttpHelper
extends BaseHelper {
    private long startTime;

    HttpHelper(HelperInfo helperInfo) {
        super(helperInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpInfo doRequestSync(OkHttpHelper helper) {
        Call call = null;
        HttpInfo info = this.httpInfo;
        Request request = helper.getRequest();
        String url = info.getUrl();
        if (!this.checkUrl(url)) {
            return this.retInfo(info, 5);
        }
        request = request == null ? this.buildRequest(info, helper.getRequestType(), helper.getProgressCallback()) : request;
        this.showUrlLog(request);
        helper.setRequest(request);
        OkHttpClient httpClient = helper.getHttpClient();
        try {
            httpClient = httpClient == null ? this.httpClient : httpClient;
            call = httpClient.newCall(request);
            BaseActivityLifecycleCallbacks.putCall(this.requestTag, call);
            Response res = call.execute();
            HttpInfo httpInfo = this.dealResponse(helper, res);
            return httpInfo;
        }
        catch (IllegalArgumentException e) {
            HttpInfo httpInfo = this.retInfo(info, 3);
            return httpInfo;
        }
        catch (SocketTimeoutException e) {
            if (null != e.getMessage()) {
                if (e.getMessage().contains("failed to connect to")) {
                    HttpInfo httpInfo = this.retInfo(info, 7);
                    return httpInfo;
                }
                if (e.getMessage().equals("timeout")) {
                    HttpInfo httpInfo = this.retInfo(info, 8);
                    return httpInfo;
                }
            }
            HttpInfo httpInfo = this.retInfo(info, 8);
            return httpInfo;
        }
        catch (UnknownHostException e) {
            if (!this.helperInfo.getOkHttpUtil().isNetworkAvailable()) {
                HttpInfo httpInfo = this.retInfo(info, 6, "[" + e.getMessage() + "]");
                return httpInfo;
            }
            HttpInfo httpInfo = this.retInfo(info, 5, "[" + e.getMessage() + "]");
            return httpInfo;
        }
        catch (NetworkOnMainThreadException e) {
            HttpInfo httpInfo = this.retInfo(info, 10);
            return httpInfo;
        }
        catch (Exception e) {
            HttpInfo httpInfo = this.retInfo(info, 4, "[" + e.getMessage() + "]");
            return httpInfo;
        }
        finally {
            if (helper.getBusinessType() == 1) {
                BaseActivityLifecycleCallbacks.cancel(this.requestTag, call);
            }
        }
    }

    void doRequestAsync(final OkHttpHelper helper) {
        final HttpInfo info = this.httpInfo;
        final BaseCallback callback = helper.getCallback();
        Request request = helper.getRequest();
        String url = info.getUrl();
        if (!this.checkUrl(url)) {
            Message msg = new CallbackMessage(1, callback, this.retInfo(info, 5), this.requestTag, null).build();
            OkMainHandler.getInstance().sendMessage(msg);
            return;
        }
        request = request == null ? this.buildRequest(info, helper.getRequestType(), helper.getProgressCallback()) : request;
        this.showUrlLog(request);
        Call call = this.httpClient.newCall(request);
        BaseActivityLifecycleCallbacks.putCall(this.requestTag, call);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                int code = 6;
                if (e instanceof UnknownHostException) {
                    code = !HttpHelper.this.helperInfo.getOkHttpUtil().isNetworkAvailable() ? 6 : 5;
                } else if (e instanceof SocketTimeoutException && null != e.getMessage()) {
                    if (e.getMessage().contains("failed to connect to")) {
                        code = 7;
                    }
                    if (e.getMessage().equals("timeout")) {
                        code = 8;
                    }
                }
                Message msg = new CallbackMessage(1, callback, HttpHelper.this.retInfo(info, code, "[" + e.getMessage() + "]"), HttpHelper.this.requestTag, call).build();
                OkMainHandler.getInstance().sendMessage(msg);
            }

            public void onResponse(Call call, Response res) throws IOException {
                Message msg = new CallbackMessage(1, callback, HttpHelper.this.dealResponse(helper, res), HttpHelper.this.requestTag, call).build();
                OkMainHandler.getInstance().sendMessage(msg);
            }
        });
    }

    private boolean checkUrl(String url) {
        HttpUrl parsed = HttpUrl.parse((String)url);
        return parsed != null && !TextUtils.isEmpty((CharSequence)url);
    }

    private Request buildRequest(HttpInfo info, int method, ProgressCallback progressCallback) {
        Request.Builder requestBuilder = new Request.Builder();
        String url = info.getUrl();
        if (method == 2) {
            StringBuilder params = new StringBuilder();
            params.append(url);
            if (null != info.getParams() && !info.getParams().isEmpty()) {
                if (!url.contains("?") && !url.endsWith("?")) {
                    params.append("?");
                }
                boolean isFirst = params.toString().endsWith("?");
                for (String name : info.getParams().keySet()) {
                    String logInfo;
                    String value = info.getParams().get(name);
                    String string = value = value == null ? "" : value;
                    if (isFirst) {
                        logInfo = name + "=" + value;
                        isFirst = false;
                    } else {
                        logInfo = "&" + name + "=" + value;
                    }
                    params.append(logInfo);
                }
            }
            requestBuilder.url(params.toString()).get();
        } else {
            RequestBody requestBody = this.matchContentType(info);
            ProgressRequestBody progress = new ProgressRequestBody(requestBody, progressCallback, this.timeStamp, this.requestTag);
            if (method == 1) {
                requestBuilder.url(url).post((RequestBody)progress);
            } else if (method == 3) {
                requestBuilder.url(url).put((RequestBody)progress);
            } else if (method == 4) {
                requestBuilder.url(url).delete((RequestBody)progress);
            } else {
                requestBuilder.url(url).post((RequestBody)progress);
            }
        }
        if (Build.VERSION.SDK_INT > 13) {
            requestBuilder.addHeader("Connection", "close");
        }
        this.addHeadsToRequest(info, requestBuilder);
        Request request = requestBuilder.build();
        return request;
    }

    private RequestBody matchContentType(HttpInfo info) {
        RequestBody requestBody;
        String requestEncoding = info.getRequestEncoding();
        requestEncoding = TextUtils.isEmpty((CharSequence)requestEncoding) ? ";charset=" + this.helperInfo.getRequestEncoding().toLowerCase() : ";charset=" + requestEncoding.toLowerCase();
        if (!TextUtils.isEmpty((CharSequence)info.getContentType())) {
            MediaType contentType = MediaType.parse((String)(info.getContentType() + requestEncoding));
            if (info.getParamBytes() != null) {
                requestBody = RequestBody.create((MediaType)contentType, (byte[])info.getParamBytes());
            } else if (info.getParamFile() != null) {
                requestBody = RequestBody.create((MediaType)contentType, (File)info.getParamFile());
            } else if (info.getParamJson() != null) {
                this.showLog("Params: " + info.getParamJson());
                requestBody = RequestBody.create((MediaType)contentType, (String)info.getParamJson());
            } else if (info.getParamForm() != null) {
                this.showLog("Params: " + info.getParamForm());
                requestBody = RequestBody.create((MediaType)contentType, (String)info.getParamForm());
            } else {
                StringBuilder param = new StringBuilder();
                for (String key : info.getParams().keySet()) {
                    String value = info.getParams().get(key);
                    value = value == null ? "" : value;
                    param.append("&").append(key).append("=").append(value);
                }
                this.showLog("Params: " + param.toString());
                requestBody = RequestBody.create((MediaType)contentType, (String)param.toString());
            }
        } else if (info.getParamBytes() != null) {
            requestBody = RequestBody.create((MediaType)MediaType.parse((String)("application/octet-stream" + requestEncoding)), (byte[])info.getParamBytes());
        } else if (info.getParamFile() != null) {
            requestBody = RequestBody.create((MediaType)MediaType.parse((String)("text/x-markdown" + requestEncoding)), (File)info.getParamFile());
        } else if (info.getParamJson() != null) {
            this.showLog("Params: " + info.getParamJson());
            requestBody = RequestBody.create((MediaType)MediaType.parse((String)("application/json" + requestEncoding)), (String)info.getParamJson());
        } else if (info.getParamForm() != null) {
            this.showLog("Params: " + info.getParamForm());
            requestBody = RequestBody.create((MediaType)MediaType.parse((String)("application/x-www-form-urlencoded" + requestEncoding)), (String)info.getParamForm());
        } else {
            StringBuilder param = new StringBuilder();
            for (String key : info.getParams().keySet()) {
                String value = info.getParams().get(key);
                value = value == null ? "" : value;
                param.append("&").append(key).append("=").append(value);
            }
            this.showLog("Params: " + param.toString());
            requestBody = RequestBody.create((MediaType)MediaType.parse((String)("application/x-www-form-urlencoded" + requestEncoding)), (String)param.toString());
        }
        return requestBody;
    }

    private RequestBody packageFormBody(HttpInfo info) {
        FormBody.Builder builder = new FormBody.Builder();
        if (null != info.getParams() && !info.getParams().isEmpty()) {
            StringBuilder log = new StringBuilder("Params: ");
            for (String key : info.getParams().keySet()) {
                String value = info.getParams().get(key);
                value = value == null ? "" : value;
                builder.add(key, value);
                log.append(key).append("=").append(value).append(" | ");
            }
            int point = log.lastIndexOf("|");
            if (point != -1) {
                log.deleteCharAt(point);
            }
            this.showLog(log.toString());
        }
        return builder.build();
    }

    private void showUrlLog(Request request) {
        this.startTime = System.nanoTime();
        this.showLog(String.format("%s-URL: %s %n", request.method(), request.url()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpInfo dealResponse(OkHttpHelper helper, Response res) {
        this.showLog(String.format(Locale.getDefault(), "CostTime: %.3fs", (double)(System.nanoTime() - this.startTime) / 1.0E9));
        BufferedReader bufferedReader = null;
        StringBuilder result = new StringBuilder("");
        try {
            if (null != res) {
                int netCode = res.code();
                if (res.isSuccessful()) {
                    if (helper.getBusinessType() == 1 || helper.getBusinessType() == 2) {
                        ResponseBody body;
                        String encoding = this.httpInfo.getResponseEncoding();
                        if (TextUtils.isEmpty((CharSequence)encoding)) {
                            encoding = helper.getResponseEncoding();
                        }
                        if ((body = res.body()) != null) {
                            String line;
                            bufferedReader = new BufferedReader(new InputStreamReader(body.byteStream(), encoding));
                            while ((line = bufferedReader.readLine()) != null) {
                                result.append(line);
                            }
                        }
                        HttpInfo httpInfo = this.retInfo(this.httpInfo, netCode, 1, result.toString());
                        return httpInfo;
                    }
                    if (helper.getBusinessType() == 3) {
                        HttpInfo encoding = helper.getDownUpLoadHelper().downloadingFile(helper, res);
                        return encoding;
                    }
                } else {
                    this.showLog("HttpStatus: " + netCode);
                    if (netCode == 400) {
                        HttpInfo encoding = this.retInfo(this.httpInfo, netCode, 15);
                        return encoding;
                    }
                    if (netCode == 404) {
                        HttpInfo encoding = this.retInfo(this.httpInfo, netCode, 14);
                        return encoding;
                    }
                    if (netCode == 416) {
                        HttpInfo encoding = this.retInfo(this.httpInfo, netCode, 11, "\u8bf7\u6c42Http\u6570\u636e\u6d41\u8303\u56f4\u9519\u8bef\n" + result.toString());
                        return encoding;
                    }
                    if (netCode == 500) {
                        HttpInfo encoding = this.retInfo(this.httpInfo, netCode, 4);
                        return encoding;
                    }
                    if (netCode == 502) {
                        HttpInfo encoding = this.retInfo(this.httpInfo, netCode, 13);
                        return encoding;
                    }
                    if (netCode == 504) {
                        HttpInfo encoding = this.retInfo(this.httpInfo, netCode, 12);
                        return encoding;
                    }
                    HttpInfo encoding = this.retInfo(this.httpInfo, netCode, 6);
                    return encoding;
                }
            }
            HttpInfo netCode = this.retInfo(this.httpInfo, 5);
            return netCode;
        }
        catch (Exception e) {
            HttpInfo httpInfo = this.retInfo(this.httpInfo, 4, "[" + e.getMessage() + "]");
            return httpInfo;
        }
        finally {
            if (null != res) {
                res.close();
            }
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

