/*
 * Decompiled with CFR 0.152.
 */
package com.okhttplib.helper;

import android.annotation.SuppressLint;
import android.util.Log;
import com.okhttplib.HttpInfo;
import com.okhttplib.helper.HelperInfo;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.CacheControl;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;

abstract class BaseHelper {
    int cacheSurvivalTime;
    int cacheType;
    OkHttpClient httpClient;
    protected String TAG;
    protected String timeStamp;
    protected boolean showHttpLog;
    protected String requestTag;
    HelperInfo helperInfo;
    HttpInfo httpInfo;
    private final Interceptor NETWORK_INTERCEPTOR = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            Response originalResponse = chain.proceed(originalRequest);
            BaseHelper.this.httpInfo.setFromCache(false);
            if (BaseHelper.this.cacheSurvivalTime == 0) {
                BaseHelper.this.cacheSurvivalTime = 31536000;
            }
            return originalResponse.newBuilder().header("Cache-Control", String.format(Locale.getDefault(), "max-age=%d", BaseHelper.this.cacheSurvivalTime)).build();
        }
    };
    private Interceptor NO_NETWORK_INTERCEPTOR = new Interceptor(){
        int count = 0;

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Response originalResponse;
            Request originalRequest = chain.request();
            switch (BaseHelper.this.cacheType) {
                case 2: {
                    originalRequest = originalRequest.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                    BaseHelper.this.httpInfo.setFromCache(true);
                    originalResponse = chain.proceed(originalRequest);
                    break;
                }
                case 1: {
                    originalRequest = originalRequest.newBuilder().cacheControl(CacheControl.FORCE_NETWORK).build();
                    originalResponse = chain.proceed(originalRequest);
                    break;
                }
                case 3: {
                    if (!BaseHelper.this.helperInfo.getOkHttpUtil().isNetworkAvailable()) {
                        BaseHelper.this.httpInfo.setFromCache(true);
                        originalRequest = originalRequest.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                        originalResponse = chain.proceed(originalRequest);
                        break;
                    }
                    originalRequest = originalRequest.newBuilder().cacheControl(CacheControl.FORCE_NETWORK).build();
                    originalResponse = this.aopChain(chain, originalRequest, CacheControl.FORCE_CACHE, true);
                    break;
                }
                case 4: {
                    if (!BaseHelper.this.helperInfo.getOkHttpUtil().isNetworkAvailable()) {
                        BaseHelper.this.httpInfo.setFromCache(true);
                        originalRequest = originalRequest.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                        originalResponse = chain.proceed(originalRequest);
                        break;
                    }
                    originalResponse = chain.proceed(originalRequest);
                    break;
                }
                default: {
                    originalResponse = chain.proceed(originalRequest);
                }
            }
            return originalResponse;
        }

        private Response aopChain(Interceptor.Chain chain, Request request, CacheControl cacheControl, boolean readCache) {
            Response originalResponse;
            block3: {
                originalResponse = null;
                ++this.count;
                try {
                    originalResponse = chain.proceed(request);
                    if (this.count >= 4) {
                        return originalResponse;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    request = request.newBuilder().cacheControl(cacheControl).build();
                    originalResponse = this.aopChain(chain, request, cacheControl, readCache);
                    if (!readCache) break block3;
                    BaseHelper.this.httpInfo.setFromCache(true);
                }
            }
            return originalResponse;
        }
    };
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private static final X509TrustManager TRUST_MANAGER = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };

    BaseHelper() {
    }

    BaseHelper(HelperInfo helperInfo) {
        this.helperInfo = helperInfo;
        this.httpInfo = helperInfo.getHttpInfo();
        if (this.httpInfo != null) {
            this.httpInfo.setFromCache(true);
        }
        this.cacheSurvivalTime = helperInfo.getCacheSurvivalTime();
        this.cacheType = helperInfo.getCacheType();
        this.TAG = helperInfo.getLogTAG();
        this.timeStamp = helperInfo.getTimeStamp();
        this.showHttpLog = helperInfo.isShowHttpLog();
        this.requestTag = helperInfo.getRequestTag();
        OkHttpClient defaultClient = helperInfo.getOkHttpUtil().getDefaultClient();
        if (helperInfo.isDefault()) {
            if (null == defaultClient) {
                this.httpClient = this.initHttpClient(helperInfo, null);
                helperInfo.getOkHttpUtil().setDefaultClient(this.httpClient);
            } else {
                this.httpClient = this.initHttpClient(helperInfo, defaultClient.cookieJar());
            }
        } else {
            this.httpClient = this.initHttpClient(helperInfo, null);
        }
    }

    private OkHttpClient initHttpClient(HelperInfo helperInfo, CookieJar cookieJar) {
        OkHttpClient.Builder clientBuilder = helperInfo.getClientBuilder();
        clientBuilder.protocols(Arrays.asList(Protocol.SPDY_3, Protocol.HTTP_1_1));
        clientBuilder.addInterceptor(this.NO_NETWORK_INTERCEPTOR);
        clientBuilder.addNetworkInterceptor(this.NETWORK_INTERCEPTOR);
        if (helperInfo.isGzip()) {
            clientBuilder.addInterceptor((Interceptor)new GzipRequestInterceptor());
        }
        if (null != cookieJar) {
            clientBuilder.cookieJar(cookieJar);
        }
        if (helperInfo.getHttpsCertificateStream() == null) {
            this.setDefaultSslSocketFactory(clientBuilder);
        } else {
            this.setSslSocketFactory(clientBuilder);
        }
        return clientBuilder.build();
    }

    private void setDefaultSslSocketFactory(OkHttpClient.Builder clientBuilder) {
        clientBuilder.hostnameVerifier(DO_NOT_VERIFY);
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{TRUST_MANAGER}, new SecureRandom());
            clientBuilder.sslSocketFactory(sc.getSocketFactory(), TRUST_MANAGER);
        }
        catch (Exception e) {
            this.showLog("Https\u8ba4\u8bc1\u5f02\u5e38: " + e.getMessage());
        }
    }

    private void setSslSocketFactory(OkHttpClient.Builder clientBuilder) {
        SSLContext sslContext = this.getSSLContext();
        if (sslContext != null) {
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), TRUST_MANAGER);
        }
    }

    @SuppressLint(value={"TrulyRandom"})
    private SSLContext getSSLContext() {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            InputStream inputStream = this.helperInfo.getHttpsCertificateStream();
            CertificateFactory cerFactory = CertificateFactory.getInstance("X.509");
            Certificate cer = cerFactory.generateCertificate(inputStream);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(null, null);
            keyStore.setCertificateEntry("trust", cer);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, null);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sslContext;
    }

    void showLog(String msg) {
        if (this.showHttpLog) {
            Log.d((String)(this.TAG + "[" + this.timeStamp + "]"), (String)msg);
        }
    }

    private final class GzipRequestInterceptor
    implements Interceptor {
        private GzipRequestInterceptor() {
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            if (originalRequest.body() == null || originalRequest.header("Content-Encoding") != null) {
                return chain.proceed(originalRequest);
            }
            Request compressedRequest = originalRequest.newBuilder().header("Content-Encoding", "gzip").method(originalRequest.method(), this.gzip(originalRequest.body())).build();
            return chain.proceed(compressedRequest);
        }

        private RequestBody gzip(final RequestBody body) {
            return new RequestBody(){

                public MediaType contentType() {
                    return body.contentType();
                }

                public long contentLength() {
                    return -1L;
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)sink));
                    body.writeTo(gzipSink);
                    gzipSink.close();
                }
            };
        }
    }
}

